<?php
/**
 * Kalium WordPress Theme
 *
 * Footer options.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

// Footer Content
kalium_customize_register_control(
	'footer_content',
	[
		'type'            => 'laborator-builder',
		'content_type_id' => 'footer',
		'default'         => static function () {
			return laborator_builder_get_content_type( 'footer' )->get_default_content();
		},
		'dependency'      => [
			'footer_enabled' => true,
		],
	]
);

// Footer Visibility
kalium_customize_register_control(
	'footer_enabled',
	[
		'type'      => 'kalium-toggle',
		'label'     => 'Enable Footer',
		'help'      => 'Show footer area on your site.',
		'separator' => true,
		'default'   => true,
	]
);

// Footer type
kalium_customize_register_control(
	'footer_type',
	[
		'type'       => 'kalium-radio-button',
		'label'      => 'Type',
		'choices'    => [
			'normal' => 'Normal',
			'fixed'  => 'Fixed',
		],
		'dependency' => [
			'footer_enabled' => true,
		],
	]
);

// Fixed footer type animation
kalium_customize_register_control(
	'footer_fixed_animation',
	[
		'type'       => 'kalium-radio-button',
		'label'      => 'Animation',
		'choices'    => [
			'none'  => 'None',
			'fade'  => 'Fade',
			'slide' => 'Slide',
		],
		'dependency' => [
			'footer_enabled' => true,
			'footer_type'    => 'fixed',
		],
	]
);
