<?php
/**
 * Kalium WordPress Theme
 *
 * Maintenance mode.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

// Maintenance Mode
kalium_customize_register_control(
	'maintenance_mode',
	[
		'type'         => 'kalium-toggle',
		'label'        => 'Maintenance Mode',
		'help'         => 'Let your visitors know your website is under maintenance or that it is on a coming soon mode for a new website.',
		'priority'     => kalium()->customize->get_next_priority(),
		'tags'         => 'coming soon, under construction',
		'section_link' => kalium()->customize->section_id( 'maintenance_mode' ),
	]
);

/**
 * Section: Maintenance Mode.
 */

// Section
kalium_customize_register_section(
	'maintenance_mode',
	[
		'title'      => 'Maintenance Mode',
		'active_url' => home_url( '?view-maintenance=true' ),
	]
);

// General tab
kalium_customize_general_tab();

// Title
kalium_customize_register_control(
	'maintenance_mode_title',
	[
		'type'         => 'kalium-text',
		'label'        => 'Title',
		'inline_label' => false,
		'default'      => 'We\'ll be back soon!',
	]
);

// Description
kalium_customize_register_control(
	'maintenance_mode_description',
	[
		'type'    => 'kalium-textarea',
		'label'   => 'Description',
		'rows'    => 8,
		'default' => 'We are currently working on the back-end, our team is making the best to bring the site back in no time.',
	]
);

// Custom logo
kalium_customize_register_control(
	'maintenance_mode_use_uploaded_logo',
	[
		'type'           => 'kalium-toggle',
		'label'          => 'Logo',
		'separator'      => true,
		'separator_type' => 3,
	]
);

// Logo Image
kalium_customize_register_control(
	'maintenance_mode_custom_logo_image',
	[
		'type'       => 'kalium-media',
		'label'      => 'Custom Logo Image',
		'dependency' => [
			'maintenance_mode_use_uploaded_logo' => true,
		],
	]
);

// Background Fill
kalium_customize_register_control(
	'maintenance_mode_custom_logo_max_width',
	[
		'type'       => 'kalium-range',
		'label'      => 'Max. Width',
		'input_type' => 'number',
		'min'        => 10,
		'max'        => 500,
		'default'    => 150,
		'reset'      => true,
		'suffix'     => 'PX',
		'dependency' => [
			'maintenance_mode_use_uploaded_logo' => true,
		],
	]
);

// Countdown timer
kalium_customize_register_control(
	'maintenance_mode_countdown',
	[
		'type'           => 'kalium-toggle',
		'label'          => 'Countdown Timer',
		'help'           => 'Set the date and time when your website will be published.',
		'separator'      => true,
		'separator_type' => 3,
	]
);

// Countdown date
kalium_customize_register_control(
	'maintenance_mode_countdown_date',
	[
		'type'        => 'kalium-text',
		'label'       => 'Date',
		'input_type'  => 'date',
		'input_style' => 'width: 120px',
		'placeholder' => 'YYYY-MM-DD',
		'default'     => date( 'Y-m-d', strtotime( '+3 months' ) ),
		'dependency'  => [
			'maintenance_mode_countdown' => true,
		],
	]
);

// Countdown time
kalium_customize_register_control(
	'maintenance_mode_countdown_time',
	[
		'type'        => 'kalium-text',
		'label'       => 'Time',
		'input_type'  => 'time',
		'placeholder' => 'HH:MM',
		'default'     => '20:30',
		'dependency'  => [
			'maintenance_mode_countdown' => true,
		],
	]
);

// Social Networks
kalium_customize_register_control(
	'maintenance_mode_social_networks',
	[
		'type'           => 'kalium-toggle',
		'label'          => 'Social Networks',
		'separator'      => true,
		'separator_type' => 3,
	]
);

// End of general tab
kalium_customize_end_tab();

// Style tab
kalium_customize_style_tab();

// Text color
kalium_customize_register_control(
	'maintenance_mode_custom_text_color',
	[
		'type'    => 'kalium-color',
		'label'   => 'Text Color',
		'reset'   => true,
		'default' => kalium_color_reference( 'theme_colors_body' ),
		'tooltip' => true,
		'setting' => [
			'transport' => 'postMessage',
		],
	]
);

// Background color
kalium_customize_register_control(
	'maintenance_mode_custom_bg_color',
	[
		'type'    => 'kalium-color',
		'label'   => 'Background Color',
		'reset'   => true,
		'default' => kalium_color_reference( 'theme_colors.color-1' ),
		'tooltip' => true,
		'setting' => [
			'transport' => 'postMessage',
		],
	]
);

// Background Image
kalium_customize_register_control(
	'maintenance_mode_custom_bg_id',
	[
		'type'  => 'kalium-media',
		'label' => 'Background Image',
	]
);

// Background Fill
kalium_customize_register_control(
	'maintenance_mode_custom_bg_size',
	[
		'type'    => 'kalium-radio-button',
		'label'   => 'Background Fill',
		'choices' => [
			'cover'   => 'Cover',
			'contain' => 'Contain',
		],
	]
);

// Overlay background
kalium_customize_register_control(
	'maintenance_mode_custom_bg_color_overlay',
	[
		'type'    => 'kalium-toggle',
		'label'   => 'Color Overlay',
		'help'    => 'Mix background image with background color as overlay.',
		'setting' => [
			'transport' => 'postMessage',
		],
	]
);

// End of style tab
kalium_customize_end_tab();

// End of current section
kalium_customize_end_section();

/**
 * Update preview.
 */

// Background and text
kalium_customize_register_preview_update(
	[
		'type'    => 'css',
		'vars'    => [
			'maintenance_mode_custom_bg_color',
			'maintenance_mode_custom_text_color',
			'maintenance_mode_custom_bg_color_overlay',
		],
		'content' => <<<EOD
<#
var selector = '.maintenance-mode';
#>
{{{ data.api.printInlineStyle( { selector, varName: 'mm-color', value: data.maintenance_mode_custom_text_color } ) }}}
{{{ data.api.printInlineStyle( { selector, varName: 'mm-bg-color', value: data.maintenance_mode_custom_bg_color } ) }}}

{{{ data.api.toggleClass( '.maintenance-mode', 'maintenance-mode--bg-overlay', data.maintenance_mode_custom_bg_color_overlay ) }}}
EOD,
	]
);
