<?php
/**
 * Kalium WordPress Theme
 *
 * Scroll to Top.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

// Scroll to Top
kalium_customize_register_control(
	'scroll_to_top',
	[
		'type'         => 'kalium-toggle',
		'label'        => 'Scroll to Top',
		'help'         => 'Offer your visitor a button to easily scroll back to the top of the page.',
		'priority'     => kalium()->customize->get_next_priority(),
		'section_link' => kalium()->customize->section_id( 'scroll_to_top' ),
	]
);

/**
 * Section: Scroll to Top.
 */

// Section
kalium_customize_register_section(
	'scroll_to_top',
	[
		'title' => 'Scroll to Top',
	]
);

// General tab
kalium_customize_general_tab();

// Show on Footer
kalium_customize_register_control(
	'scroll_to_top_activate_footer',
	[
		'type'          => 'kalium-toggle',
		'heading_title' => 'Trigger',
		'label'         => 'Show on Footer',
		'help'          => 'Show the Scroll to Top button only when visitors arrive to the Footer area of the website.',
		'default'       => true,
	]
);

// Scroll Position
kalium_customize_register_control(
	'scroll_to_top_activate',
	[
		'type'        => 'kalium-unit',
		'label'       => 'Scroll Position',
		'help'        => 'Set the position where the Scroll to Top button starts to show. E.g: If set to 30%, it means that the button shows after visitors scroll 30% of your pages.',
		'input_style' => 'width:80px',
		'reset'       => true,
		'units'       => [ 'px', '%' ],
		'default'     => '50%',
		'dependency'  => [
			'scroll_to_top_activate_footer' => false,
		],
	]
);

// Position
kalium_customize_register_control(
	'scroll_to_top_position',
	[
		'type'           => 'kalium-select',
		'label'          => 'Position',
		'choices'        => [
			'bottom-right'  => 'Bottom Right',
			'bottom-left'   => 'Bottom Left',
			'bottom-center' => 'Bottom Center',
			'top-right'     => 'Top Right',
			'top-left'      => 'Top Left',
			'top-center'    => 'Top Center',
		],
		'separator'      => true,
		'separator_type' => 3,
		'setting'        => [
			'transport' => 'postMessage',
		],
	]
);

// Icon
kalium_customize_register_control(
	'scroll_to_top_icon',
	[
		'type'         => 'kalium-radio-button',
		'label'        => 'Icon',
		'inline_label' => true,
		'input_style'  => 'width:150px',
		'choices'      => [
			'icon-1' => 'Icon 1',
			'icon-2' => 'Icon 2',
		],
	]
);

// Visibility
kalium()->customize->register_visibility_setting( 'scroll_to_top' );

// End of general tab
kalium_customize_end_tab();

// Style tab
kalium_customize_style_tab();

// Icon color
kalium_customize_register_control(
	'scroll_to_top_color',
	[
		'type'    => 'kalium-color',
		'label'   => 'Icon',
		'reset'   => true,
		'choices' => [
			'normal' => 'Normal',
			'hover'  => 'Hover',
		],
		'default' => [
			'normal' => kalium_color_reference( 'button_color.normal' ),
			'hover'  => kalium_color_reference( 'button_color.hover' ),
		],
		'tooltip' => true,
		'setting' => [
			'transport' => 'postMessage',
		],
	]
);

// Background color
kalium_customize_register_control(
	'scroll_to_top_bg',
	[
		'type'    => 'kalium-color',
		'label'   => 'Background',
		'reset'   => true,
		'choices' => [
			'normal' => 'Normal',
			'hover'  => 'Hover',
		],
		'default' => [
			'normal' => kalium_color_reference( 'theme_colors_text.normal', 0.7 ),
			'hover'  => kalium_color_reference( 'theme_colors_text.normal', 0.9 ),
		],
		'tooltip' => true,
		'setting' => [
			'transport' => 'postMessage',
		],
	]
);

// Size
kalium_customize_register_control(
	'scroll_to_top_size',
	[
		'type'       => 'kalium-range',
		'label'      => 'Size',
		'reset'      => true,
		'responsive' => true,
		'default'    => 40,
		'min'        => 20,
		'slider_max' => 100,
		'suffix'     => 'PX',
		'setting'    => [
			'transport' => 'postMessage',
		],
	]
);

// Spacing
kalium_customize_register_control(
	'scroll_to_top_spacing',
	[
		'type'       => 'kalium-range',
		'label'      => 'Spacing',
		'reset'      => true,
		'responsive' => true,
		'default'    => 20,
		'min'        => 0,
		'slider_max' => 100,
		'suffix'     => 'PX',
		'setting'    => [
			'transport' => 'postMessage',
		],
	]
);

// Border Radius
kalium_customize_register_control(
	'scroll_to_top_border_radius',
	[
		'type'    => 'kalium-multi-numeric',
		'label'   => 'Border Radius',
		'reset'   => true,
		'units'   => kalium_get_default_units( 'box-size' ),
		'min'     => 0,
		'setting' => [
			'transport' => 'postMessage',
		],
		'default' => [
			'top'    => 50,
			'right'  => 50,
			'bottom' => 50,
			'left'   => 50,
			'unit'   => '%',
			'link'   => true,
		],
	]
);

// End of Style
kalium_customize_end_tab();

// End of current section
kalium_customize_end_section();

/**
 * Update options in preview.
 */

kalium_customize_register_preview_update(
	[
		'type'    => 'css',
		'vars'    => [
			'scroll_to_top_position',
			'scroll_to_top_visibility',
			'scroll_to_top_color',
			'scroll_to_top_bg',
			'scroll_to_top_size',
			'scroll_to_top_spacing',
			'scroll_to_top_border_radius',
		],
		'content' => <<<EOD
	<#
	var selector = '.scroll-to-top',
		scrollToTopEl = data.api.getElement( selector ), 
		[ posY, posX ] = data.scroll_to_top_position.split( '-' ),
		colors = {
			'button-color': data.scroll_to_top_color.normal,
			'button-hover-color': data.scroll_to_top_color.hover,
			'button-active-color': data.scroll_to_top_color.hover,
			'button-bg': data.scroll_to_top_bg.normal,
			'button-hover-bg': data.scroll_to_top_bg.hover,
			'button-active-bg': data.scroll_to_top_bg.hover
		};
		
	if ( scrollToTopEl ) {
		// Position
		data.api.toggleClassPlaceholder( scrollToTopEl, 'scroll-to-top--pos-*' );
		scrollToTopEl.classList.add( 'scroll-to-top--pos-' + posY, 'scroll-to-top--pos-' + posX  );
		
		// Visibility
		data.api.applyDeviceVisibilityClasses( scrollToTopEl, data.scroll_to_top_visibility );
	}
	#>
	
	<# for ( var colorProp in colors ) { #>
		{{{ data.api.printInlineStyle( { selector, varName: colorProp, value: colors[ colorProp ] } ) }}}
	<# } #>
	
	{{{ data.api.printInlineStyle( { selector, varName: 'stt-size', value: data.scroll_to_top_size, addUnit: 'px' } ) }}}
	{{{ data.api.printInlineStyle( { selector, varName: 'stt-spacing', value: data.scroll_to_top_spacing, addUnit: 'px' } ) }}}
	{{{ data.api.printInlineStyle( { selector, varName: 'button-border-radius', value: data.scroll_to_top_border_radius, parser: 'length' } ) }}}
EOD,
	]
);
