<?php
/**
 * Kalium WordPress Theme
 *
 * Header Style options.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

// Container
kalium_customize_register_control(
	'header_background',
	[
		'type'          => 'kalium-color',
		'heading_title' => 'Container',
		'label'         => 'Background',
		'reset'         => true,
		'enable_clear'  => true,
		'setting'       => [
			'transport' => 'postMessage',
		],
	]
);

// Border
kalium_customize_register_control(
	'header_border',
	[
		'type'         => 'kalium-border-box',
		'label'        => 'Border',
		'reset'        => true,
		'border_style' => true,
		'setting'      => [
			'transport' => 'postMessage',
		],
	]
);

// Padding
kalium_customize_register_control(
	'header_vpadding',
	[
		'type'        => 'kalium-multi-numeric',
		'label'       => 'Padding',
		'reset'       => true,
		'value_props' => [
			'top'    => 'Top',
			'bottom' => 'Bottom',
		],
		'units'       => kalium_get_default_units( 'length' ),
		'setting'     => [
			'transport' => 'postMessage',
		],
	]
);

// Bottom margin
kalium_customize_register_control(
	'header_bottom_spacing',
	[
		'type'       => 'kalium-range',
		'label'      => 'Margin Bottom',
		'reset'      => true,
		'responsive' => true,
		'min'        => 0,
		'max'        => 200,
		'suffix'     => 'PX',
		'setting'    => [
			'transport' => 'postMessage',
		],
	]
);

// Links
kalium_customize_register_control(
	'header_style_links',
	[
		'type'          => 'kalium-color',
		'heading_title' => 'Menu',
		'label'         => 'Links',
		'separator'     => true,
		'reset'         => true,
		'choices'       => [
			'normal' => 'Normal',
			'hover'  => 'Hover',
			'active' => 'Active',
		],
		'default'       => [
			'normal' => kalium_color_reference( 'theme_colors_headings' ),
			'hover'  => kalium_color_reference( 'theme_colors_link.hover' ),
			'active' => kalium_color_variant_active( 'header_style_links.hover' ),
		],
		'tooltip'       => true,
		'setting'       => [
			'transport' => 'postMessage',
		],
		'dependency'    => [
			// TODO: Add dependency to hide option when not using standard menu
		],
	]
);

// Hamburger Menu Trigger Button
kalium_customize_register_control(
	'header_style_menu_trigger',
	[
		'type'    => 'kalium-color',
		'label'   => 'Hamburger Menu',
		'reset'   => true,
		'choices' => [
			'normal' => 'Normal',
			'hover'  => 'Hover',
			'active' => 'Active',
		],
		'default' => [
			'normal' => kalium_color_reference( 'header_style_links.normal' ),
			'hover'  => kalium_color_reference( 'header_style_links.hover' ),
			'active' => kalium_color_variant_active( 'header_style_menu_trigger.hover' ),
		],
		'tooltip' => true,
		'setting' => [
			'transport' => 'postMessage',
		],
	]
);

// Text
kalium_customize_register_control(
	'header_style_text',
	[
		'type'    => 'kalium-color',
		'label'   => 'Text',
		'reset'   => true,
		'default' => kalium_color_reference( 'theme_colors_text.normal' ),
		'setting' => [
			'transport' => 'postMessage',
		],
	]
);

// Menu Item Spacing
kalium_customize_register_control(
	'header_menu_item_spacing',
	[
		'type'             => 'kalium-range',
		'label'            => 'Menu Item Spacing',
		'reset'            => true,
		'min'              => 0,
		'max'              => 100,
		'placeholder'      => 30,
		'initial_position' => 30,
		'units'            => kalium_get_default_units( 'box-size' ),
		'setting'          => [
			'transport' => 'postMessage',
		],
		'dependency'       => [
			'callback' => [
				'type'      => 'user-function',
				'callback'  => 'kaliumAdmin.customize.submenuDependencyCheck',
				'listen_to' => [
					'main_menu_type',
					'header_content',
				],
			],
		],
	]
);

// Pill style
kalium_customize_register_control(
	'header_menu_pills',
	[
		'type'       => 'kalium-toggle',
		'label'      => 'Pill Navigation',
		'separator'  => true,
		'setting'    => [
			'transport' => 'postMessage',
		],
		'dependency' => [
			'callback' => [
				'type'      => 'user-function',
				'callback'  => 'kaliumAdmin.customize.pillsNavDependencyCheck',
				'listen_to' => [
					'main_menu_type',
					'header_content',
				],
			],
		],
	]
);

// Pill background
kalium_customize_register_control(
	'header_menu_pill_background',
	[
		'type'         => 'kalium-color',
		'label'        => 'Background',
		'reset'        => true,
		'choices'      => [
			'normal' => 'Normal',
			'hover'  => 'Hover',
			'active' => 'Active',
		],
		'default'      => [
			'hover'  => kalium_color_reference( 'theme_colors_border' ),
			'active' => kalium_color_reference( 'header_menu_pill_background.hover' ),
		],
		'enable_clear' => true,
		'tooltip'      => true,
		'setting'      => [
			'transport' => 'postMessage',
		],
		'dependency'   => [
			'header_menu_pills' => true,
			'callback'          => [
				'type'      => 'user-function',
				'callback'  => 'kaliumAdmin.customize.pillsNavDependencyCheck',
				'listen_to' => [
					'main_menu_type',
					'header_content',
				],
			],
		],
	]
);

// Pill color
kalium_customize_register_control(
	'header_menu_pill_color',
	[
		'type'         => 'kalium-color',
		'label'        => 'Color',
		'reset'        => true,
		'choices'      => [
			'normal' => 'Normal',
			'hover'  => 'Hover',
			'active' => 'Active',
		],
		'default'      => [
			'normal' => kalium_color_reference( 'header_style_links.normal' ),
			'hover'  => kalium_color_reference( 'header_style_links.hover' ),
			'active' => kalium_color_reference( 'header_style_links.active' ),
		],
		'enable_clear' => true,
		'tooltip'      => true,
		'setting'      => [
			'transport' => 'postMessage',
		],
		'dependency'   => [
			'header_menu_pills' => true,
			'callback'          => [
				'type'      => 'user-function',
				'callback'  => 'kaliumAdmin.customize.pillsNavDependencyCheck',
				'listen_to' => [
					'main_menu_type',
					'header_content',
				],
			],
		],
	]
);

// Pill padding
kalium_customize_register_control(
	'header_menu_pill_padding',
	[
		'type'       => 'kalium-multi-numeric',
		'label'      => 'Padding',
		'reset'      => true,
		'units'      => kalium_get_default_units( 'box-size' ),
		'default'    => [
			'link' => true,
		],
		'setting'    => [
			'transport' => 'postMessage',
		],
		'dependency' => [
			'header_menu_pills' => true,
			'callback'          => [
				'type'      => 'user-function',
				'callback'  => 'kaliumAdmin.customize.pillsNavDependencyCheck',
				'listen_to' => [
					'main_menu_type',
					'header_content',
				],
			],
		],
	]
);

// Pill radius
kalium_customize_register_control(
	'header_menu_pill_radius',
	[
		'type'       => 'kalium-multi-numeric',
		'label'      => 'Border Radius',
		'reset'      => true,
		'units'      => kalium_get_default_units( 'box-size' ),
		'default'    => [
			'link' => true,
		],
		'setting'    => [
			'transport' => 'postMessage',
		],
		'dependency' => [
			'header_menu_pills' => true,
			'callback'          => [
				'type'      => 'user-function',
				'callback'  => 'kaliumAdmin.customize.pillsNavDependencyCheck',
				'listen_to' => [
					'main_menu_type',
					'header_content',
				],
			],
		],
	]
);

// Fullscreen menu background
kalium_customize_register_control(
	'fullscreen_menu_bg',
	[
		'type'          => 'kalium-toggle',
		'heading_title' => 'Fullscreen Menu',
		'label'         => 'Custom Background',
		'separator'     => true,
		'section_link'  => kalium()->customize->section_id( 'fullscreen_menu_bg' ),
		'dependency'    => [
			'callback' => [
				'type'      => 'user-function',
				'callback'  => 'kaliumAdmin.customize.fullscreenMenuDependencyCheck',
				'listen_to' => [
					'main_menu_type',
					'header_content',
				],
			],
		],
	]
);

// Links
kalium_customize_register_control(
	'header_style_fullscreen_links',
	[
		'type'         => 'kalium-color',
		'label'        => 'Links',
		'reset'        => true,
		'choices'      => [
			'normal' => 'Normal',
			'hover'  => 'Hover',
			'active' => 'Active',
		],
		'default'      => [
			'normal' => '#ffffff',
			'hover'  => kalium_color_reference( 'header_style_fullscreen_links.normal' ),
			'active' => kalium_color_reference( 'header_style_fullscreen_links.hover' ),
		],
		'enable_clear' => true,
		'tooltip'      => true,
		'setting'      => [
			'transport' => 'postMessage',
		],
		'dependency'   => [
			'callback' => [
				'type'      => 'user-function',
				'callback'  => 'kaliumAdmin.customize.fullscreenMenuDependencyCheck',
				'listen_to' => [
					'main_menu_type',
					'header_content',
				],
			],
		],
	]
);

// Fullscreen text
kalium_customize_register_control(
	'header_style_fullscreen_text',
	[
		'type'         => 'kalium-color',
		'label'        => 'Text',
		'reset'        => true,
		'enable_clear' => true,
		'default'      => kalium_color_reference( 'theme_colors_body' ),
		'setting'      => [
			'transport' => 'postMessage',
		],
		'dependency'   => [
			'callback' => [
				'type'      => 'user-function',
				'callback'  => 'kaliumAdmin.customize.fullscreenMenuDependencyCheck',
				'listen_to' => [
					'main_menu_type',
					'header_content',
				],
			],
		],
	]
);

// Off-Canvas Side menu
kalium_customize_register_control(
	'header_style_off_canvas_side_overlay',
	[
		'type'          => 'kalium-color',
		'heading_title' => 'Off-Canvas Side',
		'label'         => 'Overlay',
		'separator'     => true,
		'reset'         => true,
		'enable_clear'  => true,
		'default'       => kalium_color_reference( 'theme_colors_overlay' ),
		'setting'       => [
			'transport' => 'postMessage',
		],
		'dependency'    => [
			'callback' => [
				'type'      => 'user-function',
				'callback'  => 'kaliumAdmin.customize.offCanvasSideMenuDependencyCheck',
				'listen_to' => [
					'main_menu_type',
					'header_content',
				],
			],
		],
	]
);

// Off-Canvas Side menu background
kalium_customize_register_control(
	'header_style_off_canvas_side_bg',
	[
		'type'         => 'kalium-color',
		'label'        => 'Background',
		'reset'        => true,
		'enable_clear' => true,
		'default'      => kalium_color_reference( 'theme_colors_body' ),
		'setting'      => [
			'transport' => 'postMessage',
		],
		'dependency'   => [
			'callback' => [
				'type'      => 'user-function',
				'callback'  => 'kaliumAdmin.customize.offCanvasSideMenuDependencyCheck',
				'listen_to' => [
					'main_menu_type',
					'header_content',
				],
			],
		],
	]
);

// Off-Canvas Side menu links
kalium_customize_register_control(
	'header_style_off_canvas_side_links',
	[
		'type'         => 'kalium-color',
		'label'        => 'Links',
		'reset'        => true,
		'choices'      => [
			'normal' => 'Normal',
			'hover'  => 'Hover',
			'active' => 'Active',
		],
		'default'      => [
			'normal' => kalium_color_reference( 'header_style_links.normal' ),
			'hover'  => kalium_color_reference( 'header_style_links.hover' ),
			'active' => kalium_color_variant_active( 'header_style_off_canvas_side_links.hover' ),
		],
		'enable_clear' => true,
		'tooltip'      => true,
		'setting'      => [
			'transport' => 'postMessage',
		],
		'dependency'   => [
			'callback' => [
				'type'      => 'user-function',
				'callback'  => 'kaliumAdmin.customize.offCanvasSideMenuDependencyCheck',
				'listen_to' => [
					'main_menu_type',
					'header_content',
				],
			],
		],
	]
);

// Off-Canvas Side menu text
kalium_customize_register_control(
	'header_style_off_canvas_side_text',
	[
		'type'         => 'kalium-color',
		'label'        => 'Text',
		'reset'        => true,
		'enable_clear' => true,
		'default'      => kalium_color_reference( 'theme_colors_text.normal' ),
		'setting'      => [
			'transport' => 'postMessage',
		],
		'dependency'   => [
			'callback' => [
				'type'      => 'user-function',
				'callback'  => 'kaliumAdmin.customize.offCanvasSideMenuDependencyCheck',
				'listen_to' => [
					'main_menu_type',
					'header_content',
				],
			],
		],
	]
);

// Off-Canvas Top menu
kalium_customize_register_control(
	'header_style_off_canvas_top_bg',
	[
		'type'          => 'kalium-color',
		'heading_title' => 'Off-Canvas Top',
		'label'         => 'Background',
		'separator'     => true,
		'reset'         => true,
		'enable_clear'  => true,
		'default'       => kalium_color_reference( 'theme_colors_link.normal' ),
		'setting'       => [
			'transport' => 'postMessage',
		],
		'dependency'    => [
			'callback' => [
				'type'      => 'user-function',
				'callback'  => 'kaliumAdmin.customize.offCanvasTopMenuDependencyCheck',
				'listen_to' => [
					'main_menu_type',
					'header_content',
				],
			],
		],
	]
);

// Off-Canvas Top menu links
kalium_customize_register_control(
	'header_style_off_canvas_top_links',
	[
		'type'         => 'kalium-color',
		'label'        => 'Links',
		'reset'        => true,
		'choices'      => [
			'normal' => 'Normal',
			'hover'  => 'Hover',
			'active' => 'Active',
		],
		'default'      => [
			'normal' => '#ffffff',
			'hover'  => kalium_color_reference( 'header_style_off_canvas_top_links.normal' ),
			'active' => kalium_color_reference( 'header_style_off_canvas_top_links.hover' ),
		],
		'enable_clear' => true,
		'setting'      => [
			'transport' => 'postMessage',
		],
		'dependency'   => [
			'callback' => [
				'type'      => 'user-function',
				'callback'  => 'kaliumAdmin.customize.offCanvasTopMenuDependencyCheck',
				'listen_to' => [
					'main_menu_type',
					'header_content',
				],
			],
		],
	]
);

// Off-Canvas Top menu text
kalium_customize_register_control(
	'header_style_off_canvas_top_text',
	[
		'type'         => 'kalium-color',
		'label'        => 'Text',
		'reset'        => true,
		'enable_clear' => true,
		'default'      => kalium_color_reference( 'theme_colors_body' ),
		'setting'      => [
			'transport' => 'postMessage',
		],
		'dependency'   => [
			'callback' => [
				'type'      => 'user-function',
				'callback'  => 'kaliumAdmin.customize.offCanvasTopMenuDependencyCheck',
				'listen_to' => [
					'main_menu_type',
					'header_content',
				],
			],
		],
	]
);

// Submenu Pill background
kalium_customize_register_control(
	'header_menu_pill_submenu_bg',
	[
		'type'         => 'kalium-color',
		'label'        => 'Pill Background',
		'reset'        => true,
		'choices'      => [
			'normal' => 'Normal',
			'hover'  => 'Hover',
			'active' => 'Active',
		],
		'enable_clear' => true,
		'tooltip'      => true,
		'default'      => [
			'normal' => kalium_color_reference( 'header_menu_pill_background.normal' ),
			'hover'  => kalium_color_reference( 'header_menu_pill_background.hover' ),
			'active' => kalium_color_reference( 'header_menu_pill_background.active' ),
		],
		'setting'      => [
			'transport' => 'postMessage',
		],
		'dependency'   => [
			'header_menu_pills' => true,
			'callback'          => [
				'type'      => 'user-function',
				'callback'  => 'kaliumAdmin.customize.pillsNavDependencyCheck',
				'listen_to' => [
					'main_menu_type',
					'header_content',
				],
			],
		],
	]
);

// Submenu
kalium_customize_register_control(
	'header_style_submenu_bg',
	[
		'type'          => 'kalium-color',
		'heading_title' => 'Submenu',
		'label'         => 'Background',
		'separator'     => true,
		'reset'         => true,
		'enable_clear'  => true,
		'default'       => kalium_color_reference( 'theme_colors_headings' ),
		'setting'       => [
			'transport' => 'postMessage',
		],
		'dependency'    => [
			'callback' => [
				'type'      => 'user-function',
				'callback'  => 'kaliumAdmin.customize.submenuDependencyCheck',
				'listen_to' => [
					'main_menu_type',
					'header_content',
				],
			],
		],
	]
);

// Submenu Pill background
kalium_customize_register_control(
	'header_menu_pill_submenu_bg',
	[
		'type'         => 'kalium-color',
		'label'        => 'Pill Background',
		'reset'        => true,
		'choices'      => [
			'normal' => 'Normal',
			'hover'  => 'Hover',
			'active' => 'Active',
		],
		'enable_clear' => true,
		'tooltip'      => true,
		'setting'      => [
			'transport' => 'postMessage',
		],
		'dependency'   => [
			'header_menu_pills' => true,
			'callback'          => [
				'type'      => 'user-function',
				'callback'  => 'kaliumAdmin.customize.pillsNavDependencyCheck',
				'listen_to' => [
					'main_menu_type',
					'header_content',
				],
			],
		],
	]
);

// Submenu Links
kalium_customize_register_control(
	'header_style_submenu_links',
	[
		'type'         => 'kalium-color',
		'label'        => 'Links',
		'reset'        => true,
		'choices'      => [
			'normal' => 'Normal',
			'hover'  => 'Hover',
			'active' => 'Active',
		],
		'default'      => [
			'normal' => kalium_color_reference( 'theme_colors_body' ),
			'hover'  => kalium_color_reference( 'header_style_submenu_links.normal' ),
			'active' => kalium_color_reference( 'header_style_submenu_links.hover' ),
		],
		'enable_clear' => true,
		'tooltip'      => true,
		'setting'      => [
			'transport' => 'postMessage',
		],
		'dependency'   => [
			'callback' => [
				'type'      => 'user-function',
				'callback'  => 'kaliumAdmin.customize.submenuDependencyCheck',
				'listen_to' => [
					'main_menu_type',
					'header_content',
				],
			],
		],
	]
);

// Submenu Border
kalium_customize_register_control(
	'header_style_submenu_border',
	[
		'type'         => 'kalium-border-box',
		'label'        => 'Border',
		'reset'        => true,
		'border_style' => true,
		'setting'      => [
			'transport' => 'postMessage',
		],
		'dependency'   => [
			'callback' => [
				'type'      => 'user-function',
				'callback'  => 'kaliumAdmin.customize.submenuDependencyCheck',
				'listen_to' => [
					'main_menu_type',
					'header_content',
				],
			],
		],
	]
);

// Submenu Padding
kalium_customize_register_control(
	'header_style_submenu_padding',
	[
		'type'        => 'kalium-multi-numeric',
		'label'       => 'Padding',
		'reset'       => true,
		'units'       => kalium_get_default_units( 'box-size' ),
		'placeholder' => [
			'top'    => 15,
			'right'  => 15,
			'bottom' => 15,
			'left'   => 15,
		],
		'default'     => [
			'link' => true,
		],
		'setting'     => [
			'transport' => 'postMessage',
		],
		'dependency'  => [
			'callback' => [
				'type'      => 'user-function',
				'callback'  => 'kaliumAdmin.customize.submenuDependencyCheck',
				'listen_to' => [
					'main_menu_type',
					'header_content',
				],
			],
		],
	]
);

// Submenu Border Radius
kalium_customize_register_control(
	'header_style_submenu_border_radius',
	[
		'type'        => 'kalium-multi-numeric',
		'label'       => 'Border Radius',
		'reset'       => true,
		'units'       => kalium_get_default_units( 'box-size' ),
		'min'         => 0,
		'placeholder' => [
			'top'    => 3,
			'right'  => 3,
			'bottom' => 3,
			'left'   => 3,
		],
		'default'     => [
			'link' => true,
		],
		'setting'     => [
			'transport' => 'postMessage',
		],
		'dependency'  => [
			'callback' => [
				'type'      => 'user-function',
				'callback'  => 'kaliumAdmin.customize.submenuDependencyCheck',
				'listen_to' => [
					'main_menu_type',
					'header_content',
				],
			],
		],
	]
);

// Submenu Shadow Color
kalium_customize_register_control(
	'header_style_submenu_shadow',
	[
		'type'               => 'kalium-box-shadow',
		'label'              => 'Shadow',
		'reset'              => true,
		'placeholder'        => [
			'offset_x'      => 0,
			'offset_y'      => 0,
			'blur_radius'   => 5,
			'spread_radius' => 0,
		],
		'units'              => kalium_get_default_units( 'length' ),
		'enable_color_clear' => true,
		'setting'            => [
			'transport' => 'postMessage',
		],
		'dependency'         => [
			'callback' => [
				'type'      => 'user-function',
				'callback'  => 'kaliumAdmin.customize.submenuDependencyCheck',
				'listen_to' => [
					'main_menu_type',
					'header_content',
				],
			],
		],
	]
);

/**
 * Update options in preview.
 */

// Header container
kalium_customize_register_preview_update(
	[
		'type'     => 'css',
		'vars'     => [
			'header_background',
			'header_border',
			'header_vpadding',
			'header_bottom_spacing',
		],
		'selector' => '[data-inline-style="site-header"]',
		'content'  => <<<EOD
			.site-header {
				{{ data.api.cssVarName( 'header-bg' ) }}: {{ data.api.parseColor( data.header_background ) || "transparent" }};
			
				<# var border = data.api.toBorderBox( data.header_border ); #>
				{{ data.api.cssVarName( 'header-border-width' ) }}: {{ border.width }};
				{{ data.api.cssVarName( 'header-border-style' ) }}: {{ border.style }};
				{{ data.api.cssVarName( 'header-border-color' ) }}: {{ border.color }};
				
				<# if ( data.api.isNumber( data.header_vpadding.top ) ) { #>
					{{ data.api.cssVarName( 'header-padding-top' ) }}: {{ data.api.getMultiNumericProp( data.header_vpadding, "top" ) }};
				<# } #>
				
				<# if ( data.api.isNumber( data.header_vpadding.bottom ) ) { #>
					{{ data.api.cssVarName( 'header-padding-bottom' ) }}: {{ data.api.getMultiNumericProp( data.header_vpadding, "bottom" ) }};
				<# } #>
				<# if ( data.api.isNumber( data.header_bottom_spacing ) ) { #>
					{{ data.api.cssVarName( 'header-bottom-spacing' ) }}: {{ data.header_bottom_spacing }}px !important;
				<# } #>
			}
			
			{{{ data.api.printInlineStyle( {
				selector: '.site-header, .site-header.header-bottom-spacing',
				value: data.header_bottom_spacing,
				varName: 'header-bottom-spacing',
				addUnit: 'px',
			} ) }}}
		EOD,
	]
);

// Header border
kalium_customize_register_preview_update(
	[
		'type'    => 'js',
		'vars'    => [
			'header_border',
			'header_bottom_spacing',
		],
		'content' => <<<EOD
var siteHeader = data.api.getElement( ".site-header" ),
	border = data.api.toBorderBox( data.header_border );

siteHeader.classList.remove( "header-bottom-spacing" );

if ( data.api.hasBorder( border ) && ! data.api.isNumber( data.header_bottom_spacing ) ) {
	siteHeader.classList.add( "header-bottom-spacing" );
}

kalium( 'call-function', 'getStickyHeader', function( stickyHeader ) {
	if ( stickyHeader ) {
		stickyHeader.updateSpacerHeight();
	}
} );
EOD,
	]
);

// Menu item spacing
kalium_customize_register_preview_update(
	[
		'type'    => 'css',
		'vars'    => [
			'header_menu_item_spacing',
		],
		'content' => '
		<# if ( data.header_menu_item_spacing ) { #>
			.site-header {
				{{ data.api.cssVarName( "header-elements-spacing" ) }}: {{ data.header_menu_item_spacing }};
			}
			
			.site-header .standard-menu {
				{{ data.api.cssVarName( "menu-item-spacing" ) }}: {{ data.header_menu_item_spacing }};
				{{ data.api.cssVarName( "pill-menu-item-spacing" ) }}: {{ data.header_menu_item_spacing }};
			}
		<# } #>
		',
	]
);

// Nav pills
kalium_customize_register_preview_update(
	[
		'type'    => 'css',
		'vars'    => [
			'header_style_links',
			'header_menu_pills',
			'header_menu_pill_color',
			'header_menu_pill_background',
			'header_menu_pill_submenu_bg',
			'header_menu_pill_padding',
			'header_menu_pill_radius',
		],
		'content' => '
		<# if ( data.header_menu_pills ) { #>
		html .nav-pills {
			{{ data.api.cssVarName( "pill-color" ) }}:  {{ data.api.parseColor( data.header_menu_pill_color.normal ) }};
			{{ data.api.cssVarName( "pill-color-hover" ) }}: {{ data.api.parseColor( data.header_menu_pill_color.hover ) }};
			{{ data.api.cssVarName( "pill-color-active" ) }}: {{ data.api.parseColor( data.header_menu_pill_color.active ) }};
			
			{{ data.api.cssVarName( "pill-bg" ) }}:  {{ data.api.parseColor( data.header_menu_pill_background.normal ) }};
			{{ data.api.cssVarName( "pill-bg-hover" ) }}: {{ data.api.parseColor( data.header_menu_pill_background.hover ) }};
			{{ data.api.cssVarName( "pill-bg-active" ) }}: {{ data.api.parseColor( data.header_menu_pill_background.active ) }};
			
			<# if ( data.header_menu_pill_submenu_bg ) { #>
			{{ data.api.cssVarName( "pill-submenu-bg" ) }}:  {{ data.api.parseColor( data.header_menu_pill_submenu_bg.normal ) || "transparent" }};
			{{ data.api.cssVarName( "pill-submenu-bg-hover" ) }}: {{ data.api.parseColor( data.header_menu_pill_submenu_bg.hover ) || "transparent" }};
			{{ data.api.cssVarName( "pill-submenu-bg-active" ) }}: {{ data.api.parseColor( data.header_menu_pill_submenu_bg.active ) || "transparent" }};
			<# } #>
			
			<# if ( data.api.hasMultiNumericValue( data.header_menu_pill_padding ) ) { #>
				{{ data.api.cssVarName( "pill-padding" ) }}: {{ data.api.toLength( data.header_menu_pill_padding ) }};
			<# } #>
			
			<# if ( data.api.hasMultiNumericValue( data.header_menu_pill_radius ) ) { #>
				{{ data.api.cssVarName( "pill-radius" ) }}: {{ data.api.toLength( data.header_menu_pill_radius ) }};
			<# } #>
		}
		<# } #>',
	]
);

// Nav pills toggle
kalium_customize_register_preview_update(
	[
		'type'    => 'js',
		'vars'    => [
			'header_menu_pills',
		],
		'content' => '
		var navPills = data.api.getElements( ".site-header .header-block, .sidebar-menu-wrapper" );
		
		navPills.forEach( function( el ) {
			el.classList[ data.header_menu_pills ? "add" : "remove" ]( "nav-pills" );
		} );
	',
	]
);

// Submenu padding and radius
kalium_customize_register_preview_update(
	[
		'type'    => 'css',
		'vars'    => [
			'header_style_submenu_border',
			'header_style_submenu_shadow',
			'header_style_submenu_padding',
			'header_style_submenu_border_radius',

			// Not handled
			'header_style_submenu_bg',
			'header_menu_pill_submenu_bg',
		],
		'content' => '.standard-menu .menu ul {
		<# 
		var padding = data.api.toLength( data.header_style_submenu_padding );
		var border = data.api.toBorderBox( data.header_style_submenu_border );
		var borderRadius = data.api.toLength( data.header_style_submenu_border_radius );
		var boxShadow = data.api.toBoxShadow( data.header_style_submenu_shadow, "0 0 5px" );
		
		var firstSubmenu = data.api.getElement( ".standard-menu .sub-menu" );
		
		if ( firstSubmenu ) {
			firstSubmenu.parentElement.classList.add( "sub-visible" );
		}
		#>
		
		<# [ "width", "style", "color" ].forEach( function ( borderProp ) { #>
			<# if ( border[ borderProp ] ) { #>
			{{ data.api.cssVarName( "submenu-border-" + borderProp ) }}: {{ border[ borderProp ] }};
			<# } #>
		<# } ); #>
		
		<# if ( padding ) { #>
			{{ data.api.cssVarName( "submenu-padding" ) }}: {{ padding }}; 
		<# } #>
		
		<# if ( borderRadius ) { #>
			{{ data.api.cssVarName( "submenu-radius" ) }}: {{ borderRadius }}; 
		<# } #>
		
		<# if ( boxShadow ) { #>
			{{ data.api.cssVarName( "submenu-shadow" ) }}: {{ boxShadow }}; 
		<# } #>
	}',
	]
);
