<?php
/**
 * Kalium WordPress Theme
 *
 * Mobile menu options.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

/**
 * Subsection: Mobile Menu.
 */

// Subsection
kalium_customize_register_section(
	'mobile_menu',
	[
		'title'    => 'Mobile Menu',
		'viewport' => 'mobile',
	]
);

// General tab
kalium_customize_general_tab();

// Mobile menu content
kalium_customize_register_control(
	'mobile_menu_content',
	[
		'type'            => 'laborator-builder',
		'heading_title'   => 'Menu Content',
		'content_type_id' => 'mobile_menu',
		'default'         => static function () {
			return laborator_builder_get_content_type( 'mobile_menu' )->get_default_content();
		},
	]
);

// Menu Type
kalium_customize_register_control(
	'menu_mobile_type',
	[
		'type'          => 'kalium-radio-button',
		'heading_title' => 'Menu Options',
		'label'         => 'Type',
		'inline_label'  => false,
		'separator'     => true,
		'choices'       => [
			'slide'      => 'Slide Menu',
			'fullscreen' => 'Full Screen',
		],
		'setting'       => [
			'transport' => 'postMessage',
		],
	]
);

// Slide direction
kalium_customize_register_control(
	'menu_mobile_slide_direction',
	[
		'type'         => 'kalium-radio-button',
		'label'        => 'Slide Direction',
		'inline_label' => false,
		'choices'      => [
			'right' => 'Slide Right',
			'left'  => 'Slide Left',
		],
		'setting'      => [
			'transport' => 'postMessage',
		],
		'dependency'   => [
			'menu_mobile_type' => 'slide',
		],
	]
);

// Close button
kalium_customize_register_control(
	'menu_mobile_close_button',
	[
		'type'         => 'kalium-radio-button',
		'label'        => 'Close Button',
		'inline_label' => false,
		'reset'        => true,
		'choices'      => [
			'none'  => 'None',
			'left'  => 'Left',
			'right' => 'Right',
		],
	]
);

// Mobile menu breakpoint
kalium_customize_register_control(
	'menu_mobile_breakpoint',
	[
		'type'             => 'kalium-range',
		'label'            => 'Breakpoint',
		'reset'            => true,
		'min'              => 400,
		'max'              => 2000,
		'initial_position' => 768,
		'default'          => 768,
		'suffix'           => 'PX',
	]
);

// End of general tab
kalium_customize_end_tab();

// Style tab
kalium_customize_style_tab();

// Overlay color
kalium_customize_register_control(
	'mobile_menu_overlay_bg',
	[
		'type'         => 'kalium-color',
		'label'        => 'Overlay',
		'reset'        => true,
		'enable_clear' => true,
		'default'      => kalium_color_reference( 'theme_colors_overlay' ),
		'setting'      => [
			'transport' => 'postMessage',
		],
	]
);

// Content background
kalium_customize_register_control(
	'mobile_menu_bg',
	[
		'type'       => 'kalium-color',
		'label'      => 'Content Background',
		'reset'      => true,
		'setting'    => [
			'transport' => 'postMessage',
		],
		'default'    => kalium_color_reference( 'theme_colors_body' ),
		'dependency' => [
			'menu_mobile_type' => 'slide',
		],
	]
);

// Links
kalium_customize_register_control(
	'mobile_menu_link_colors',
	[
		'type'         => 'kalium-color',
		'label'        => 'Links',
		'reset'        => true,
		'choices'      => [
			'normal' => 'Normal',
			'hover'  => 'Hover',
			'active' => 'Active',
		],
		'default'      => [
			'normal' => kalium_color_reference( 'header_style_links.normal' ),
			'hover'  => kalium_color_reference( 'header_style_links.hover' ),
			'active' => kalium_color_reference( 'header_style_links.active' ),
		],
		'enable_clear' => true,
		'tooltip'      => true,
		'setting'      => [
			'transport' => 'postMessage',
		],
	]
);

// Text color
kalium_customize_register_control(
	'mobile_menu_text',
	[
		'type'    => 'kalium-color',
		'label'   => 'Text',
		'reset'   => true,
		'default' => kalium_color_reference( 'theme_colors_text.normal' ),
		'setting' => [
			'transport' => 'postMessage',
		],
	]
);

// Close button color
kalium_customize_register_control(
	'mobile_menu_close_button_color',
	[
		'type'       => 'kalium-color',
		'label'      => 'Close Button',
		'reset'      => true,
		'choices'    => [
			'normal' => 'Normal',
			'hover'  => 'Hover',
		],
		'default'    => [
			'normal' => kalium_color_reference( 'mobile_menu_link_colors.normal' ),
			'hover'  => kalium_color_reference( 'mobile_menu_link_colors.hover' ),
		],
		'setting'    => [
			'transport' => 'postMessage',
		],
		'dependency' => [
			'menu_mobile_close_button' => [
				'left',
				'right',
			],
		],
	]
);

// Content width
kalium_customize_register_control(
	'mobile_menu_content_width',
	[
		'type'             => 'kalium-range',
		'label'            => 'Content Max Width',
		'reset'            => true,
		'separator'        => true,
		'separator_type'   => 3,
		'units'            => kalium_get_default_units(
			[
				'px' => [
					'min' => 200,
					'max' => 1000,
				],
				'%'  => [
					'min' => 50,
					'max' => 100,
				],
			]
		),
		'initial_position' => 280,
		'placeholder'      => 280,
		'setting'          => [
			'transport' => 'postMessage',
		],
		'dependency'       => [
			'menu_mobile_type' => 'slide',
		],
	]
);

// Item spacing
kalium_customize_register_control(
	'mobile_menu_item_spacing',
	[
		'type'             => 'kalium-range',
		'label'            => 'Item Spacing',
		'reset'            => true,
		'units'            => kalium_get_default_units( 'length' ),
		'initial_position' => 20,
		'placeholder'      => 20,
		'min'              => 0,
		'max'              => 50,
		'setting'          => [
			'transport' => 'postMessage',
		],
	]
);

// Overlay blur
kalium_customize_register_control(
	'mobile_menu_overlay_blur',
	[
		'type'             => 'kalium-range',
		'label'            => 'Overlay Blur',
		'reset'            => true,
		'units'            => kalium_get_default_units( [ 'px' ] ),
		'initial_position' => 0,
		'placeholder'      => 0,
		'min'              => 0,
		'max'              => 10,
		'setting'          => [
			'transport' => 'postMessage',
		],
	]
);

// Content padding
kalium_customize_register_control(
	'mobile_menu_content_padding',
	[
		'type'        => 'kalium-multi-numeric',
		'label'       => 'Padding',
		'reset'       => true,
		'placeholder' => [
			'top'    => 20,
			'right'  => 20,
			'bottom' => 20,
			'left'   => 20,
		],
		'min'         => 0,
		'max'         => 100,
		'units'       => kalium_get_default_units( 'length' ),
		'setting'     => [
			'transport' => 'postMessage',
		],
	]
);

// End of style tab
kalium_customize_end_tab();

// End of current section
kalium_customize_end_section();

// Style update
kalium_customize_register_preview_update(
	[
		'type'    => 'css',
		'vars'    => [
			'menu_mobile_type',
			'menu_mobile_slide_direction',
			'mobile_menu_content_width',
			'mobile_menu_content_padding',
			'mobile_menu_item_spacing',
			'mobile_menu_overlay_blur',
		],
		'content' => ':root {
		    <#
            var mobileMenu = document.querySelector( ".mobile-menu" );
            
            if ( mobileMenu ) {
                data.api.toggleClassPlaceholder( mobileMenu, "mobile-menu--*", data.menu_mobile_type );
                
                mobileMenu.classList.toggle( "mobile-menu--slide-left", "slide" === data.menu_mobile_type && "left" === data.menu_mobile_slide_direction );
		    }
		    
		    // Reset vars
		    [ "mobile-menu-content-padding", "mobile-menu-overlay-blur" ].map( function( varName ) { data.api.cssVarName( varName ) } );
		    #>
		    
            <# if ( data.mobile_menu_content_width ) { #>
                {{ data.api.cssVarName( "mobile-menu-content-width" ) }}: {{ data.mobile_menu_content_width }};
            <# } #>
            
            <# data.api.cssVarReset( "mobile-menu-content-padding" ); #>
            <# if ( data.api.hasMultiNumericValue( data.mobile_menu_content_padding ) ) { #>
                {{ data.api.cssVarName( "mobile-menu-content-padding" ) }}: {{ data.api.toLength( data.mobile_menu_content_padding, data.api.cssVarReference( "content-spacing-2" ) ) }};
            <# } #>
            
            <# if ( data.mobile_menu_item_spacing ) { #>
                {{ data.api.cssVarName( "mobile-menu-item-spacing" ) }}: {{ data.mobile_menu_item_spacing }};
            <# } #>
            
            <# if ( data.mobile_menu_overlay_blur ) { #>
                <# data.api.getElement( ".mobile-menu-overlay" ).classList[ "0px" !== data.mobile_menu_overlay_blur ? "add" : "remove" ]( "mobile-menu-overlay--blur" ); #>
                {{ data.api.cssVarName( "mobile-menu-overlay-blur" ) }}: {{ data.mobile_menu_overlay_blur }};
            <# } #>
        }',
	]
);
