<?php
/**
 * Kalium WordPress Theme
 *
 * Sticky Header options.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

/**
 * Subsection: Sticky Header.
 */

// Subsection: Sticky Header
kalium_customize_register_section(
	'sticky_header',
	[
		'title' => 'Sticky Header',
	]
);

// General tab
kalium_customize_general_tab();

// Custom logo
kalium_customize_register_control(
	'sticky_header_custom_logo',
	[
		'type'  => 'kalium-toggle',
		'label' => 'Custom Logo',
		'help'  => 'Use custom logo when sticky header is active.',
	]
);

// Logo Image
kalium_customize_register_control(
	'sticky_header_logo',
	[
		'type'           => 'kalium-media',
		'label'          => 'Logo Image',
		'select_label'   => 'Select Custom Logo',
		'library_params' => [
			'type' => 'image',
		],
		'height'         => 80,
		'dependency'     => [
			'sticky_header_custom_logo' => true,
		],
	]
);

// Logo Width
kalium_customize_register_control(
	'sticky_header_logo_width',
	[
		'type'   => 'kalium-range',
		'label'  => 'Logo Width',
		'min'    => 0,
		'max'    => 500,
		'suffix' => 'PX',
		'help'   => 'If you do not assign custom logo image, the width will be applied to the current logo.',
	]
);

// Auto Hide
kalium_customize_register_control(
	'sticky_header_autohide',
	[
		'type'           => 'kalium-toggle',
		'label'          => 'Auto Hide',
		'separator'      => true,
		'separator_type' => 3,
		'help'           => 'Only show sticky header when users scrolls upside.',
	]
);

// Auto Hide Animation
kalium_customize_register_control(
	'sticky_header_autohide_animation_type',
	[
		'type'        => 'kalium-select',
		'label'       => 'Animation',
		'input_style' => 'width:120px',
		'choices'     => [
			'fade'              => 'Fade only',
			'slide'             => 'Slide from top',
			'fade-slide-top'    => 'Fade and slide from top',
			'fade-slide-bottom' => 'Fade and slide from bottom',
		],
		'default'     => 'slide',
		'dependency'  => [
			'sticky_header_autohide' => true,
		],
	]
);

// Auto Hide Duration
kalium_customize_register_control(
	'sticky_header_autohide_duration',
	[
		'type'        => 'kalium-text',
		'label'       => 'Duration',
		'input_type'  => 'number',
		'input_style' => 'width:80px',
		'placeholder' => 0.3,
		'min'         => 0,
		'max'         => 10,
		'step'        => 0.05,
		'suffix'      => 's',
		'dependency'  => [
			'sticky_header_autohide' => true,
		],
	]
);

// Animation - Animate on Scroll
kalium_customize_register_control(
	'sticky_header_animate_duration',
	[
		'type'          => 'kalium-toggle',
		'heading_title' => 'Animation',
		'label'         => 'Animate on Scroll',
		'separator'     => true,
		'default'       => true,
		'help'          => 'Sticky header styles will be animated with scroll wheel.',
	]
);

// Smooth Transition
kalium_customize_register_control(
	'sticky_header_tween_changes',
	[
		'type'       => 'kalium-toggle',
		'label'      => 'Smooth Transition',
		'dependency' => [
			'sticky_header_animate_duration' => true,
		],
	]
);

// Duration
kalium_customize_register_control(
	'sticky_header_duration',
	[
		'type'        => 'kalium-text',
		'label'       => 'Duration',
		'input_type'  => 'number',
		'input_style' => 'width:80px',
		'min'         => 0,
		'max'         => 10,
		'step'        => 0.05,
		'suffix'      => 's',
		'dependency'  => [
			'sticky_header_animate_duration' => false,
		],
	]
);

// Initial Offset
kalium_customize_register_control(
	'sticky_header_initial_offset',
	[
		'type'             => 'kalium-range',
		'label'            => 'Initial Offset',
		'reset'            => true,
		'min'              => 0,
		'max'              => 300,
		'placeholder'      => 10,
		'initial_position' => 10,
		'suffix'           => 'PX',
		'help'             => 'Scroll position when sticky header styles begin animation.',
	]
);

// Responsive
kalium_customize_register_control(
	'sticky_header_responsive',
	[
		'type'          => 'kalium-checkbox-button',
		'heading_title' => 'Responsive',
		'label'         => 'Visibility',
		'separator'     => true,
		'reset'         => true,
		'inline_label'  => false,
		'choices'       => [
			'desktop' => [
				'label' => 'Desktop',
				'icon'  => 'desktop',
			],
			'tablet'  => [
				'label' => 'Tablet',
				'icon'  => 'tablet',
			],
			'mobile'  => [
				'label' => 'Mobile',
				'icon'  => 'mobile',
			],
		],
		'default'       => [
			'desktop',
			'tablet',
			'mobile',
		],
		'help'          => 'Select in which device types the sticky header will be active.',
	]
);

// End of general
kalium_customize_end_tab();

// Style tab
kalium_customize_style_tab();

// Background
kalium_customize_register_control(
	'sticky_header_background_color',
	[
		'type'          => 'kalium-color',
		'heading_title' => 'Container',
		'label'         => 'Background',
		'reset'         => true,
		'enable_clear'  => true,
		'help'          => 'Apply background color when sticky header is active.',
	]
);

// Border
kalium_customize_register_control(
	'sticky_header_border',
	[
		'type'         => 'kalium-border',
		'label'        => 'Border Bottom',
		'reset'        => true,
		'border_style' => true,
		'slider'       => true,
	]
);

// Shadow
kalium_customize_register_control(
	'sticky_header_shadow',
	[
		'type'         => 'kalium-box-shadow',
		'label'        => 'Shadow',
		'enable_clear' => true,
		'reset'        => true,
		'units'        => kalium_get_default_units( 'length' ),
	]
);

// Vertical Padding
kalium_customize_register_control(
	'sticky_header_vertical_padding',
	[
		'type'        => 'kalium-multi-numeric',
		'label'       => 'Padding',
		'reset'       => true,
		'value_props' => [
			'top'    => 'Top',
			'bottom' => 'Bottom',
		],
		'units'       => kalium_get_default_units( 'box-size' ),
		'default'     => [
			'top'    => 10,
			'bottom' => 10,
			'link'   => true,
		],
	]
);

// Links
kalium_customize_register_control(
	'sticky_header_links_color',
	[
		'type'          => 'kalium-color',
		'heading_title' => 'Other Elements',
		'label'         => 'Links',
		'separator'     => true,
		'reset'         => true,
		'choices'       => [
			'normal' => 'Normal',
			'hover'  => 'Hover',
			'active' => 'Active',
		],
		'default'       => [
			'normal' => kalium_color_reference( 'header_style_links.normal' ),
			'hover'  => kalium_color_reference( 'header_style_links.normal' ),
			'active' => kalium_color_variant_active( 'header_style_links.hover' ),
		],
		'tooltip'       => true,
		'setting'       => [
			'transport' => 'postMessage',
		],
	]
);

// Menu trigger
kalium_customize_register_control(
	'sticky_header_menu_trigger',
	[
		'type'      => 'kalium-color',
		'label'     => 'Hamburger Menu',
		'reset'     => true,
		'choices'   => [
			'normal' => 'Normal',
			'hover'  => 'Hover',
			'active' => 'Active',
		],
		'default'   => [
			'normal' => kalium_color_reference( 'sticky_header_links_color.normal' ),
			'hover'  => kalium_color_reference( 'sticky_header_links_color.hover' ),
			'active' => kalium_color_variant_active( 'sticky_header_links_color.active' ),
		],
		'tooltip'   => true,
		'setting'   => [
			'transport' => 'postMessage',
		],
	]
);

// Text color
kalium_customize_register_control(
	'sticky_header_text_color',
	[
		'type'    => 'kalium-color',
		'label'   => 'Text',
		'reset'   => true,
		'default' => kalium_color_reference( 'header_style_text' ),
		'setting' => [
			'transport' => 'postMessage',
		],
	]
);

// Pill background color
kalium_customize_register_control(
	'sticky_header_pill_bg_color',
	[
		'type'       => 'kalium-color',
		'label'      => 'Pill Background',
		'choices'    => [
			'normal' => 'Normal',
			'hover'  => 'Hover',
			'active' => 'Active',
		],
		'default'    => [
			'hover'  => kalium_color_reference( 'header_menu_pill_background.hover' ),
			'active' => kalium_color_reference( 'sticky_header_pill_bg_color.hover' ),
		],
		'reset'      => true,
		'tooltip'    => true,
		'setting'    => [
			'transport' => 'postMessage',
		],
		'dependency' => [
			'header_menu_pills' => true,
		],
	]
);

// Pill text color
kalium_customize_register_control(
	'sticky_header_pill_color',
	[
		'type'       => 'kalium-color',
		'label'      => 'Pill Color',
		'choices'    => [
			'normal' => 'Normal',
			'hover'  => 'Hover',
			'active' => 'Active',
		],
		'default'    => [
			'normal' => kalium_color_reference( 'sticky_header_links_color.normal' ),
			'hover'  => kalium_color_reference( 'sticky_header_links_color.hover' ),
			'active' => kalium_color_reference( 'sticky_header_links_color.active' ),
		],
		'tooltip'    => true,
		'reset'      => true,
		'setting'    => [
			'transport' => 'postMessage',
		],
		'dependency' => [
			'header_menu_pills' => true,
		],
	]
);

// End of style tab
kalium_customize_end_tab();

// End of current section
kalium_customize_end_section();

// Preview
kalium_customize_register_preview_update(
	[
		'type'    => 'css',
		'vars'    => [
			'sticky_header_links_color',
			'sticky_header_text_color',
			'sticky_header_pill_bg_color',
			'sticky_header_pill_color',
		],
		'content' => <<<EOD
<#
var stickyState = '.site-header--sticky-fully-active';
#>

{{{ data.api.printInlineStyle( {
	selector: stickyState,
	value: data.sticky_header_links_color,
	varName: 'header',
	parser: function ( value ) {
		return {
			'link-color': value.normal,
			'link-hover-color': value.hover,
			'link-active-color': value.active,
		};
	},
} ) }}}

{{{ data.api.printInlineStyle( {
	selector: stickyState,
	value: data.sticky_header_text_color,
	varName: 'header-color',
} ) }}}

{{{ data.api.printInlineStyle( {
	selector: stickyState + ' .nav-pills',
	value: data.sticky_header_pill_bg_color,
	varName: 'pill',
	parser: function ( value ) {
		return {
			'bg': value.normal,
			'bg-hover': value.hover,
			'bg-active': value.active,
		};
	},
} ) }}}

{{{ data.api.printInlineStyle( {
	selector: stickyState + ' .nav-pills',
	value: data.sticky_header_pill_color,
	varName: 'pill',
	parser: function ( value ) {
		return {
			'color': value.normal,
			'color-hover': value.hover,
			'color-active': value.active,
		};
	},
} ) }}}
EOD,
	]
);
