<?php
/**
 * Kalium WordPress Theme
 *
 * Top Bar options.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

/**
 * Subsection: Top Bar.
 */

// Subsection: Top Bar
kalium_customize_register_section(
	'top_bar',
	[
		'title' => 'Top Bar',
	]
);

// General tab
kalium_customize_general_tab();

// Content
kalium_customize_register_control(
	'top_bar_content',
	[
		'type'            => 'laborator-builder',
		'content_type_id' => 'legacy_header_top_bar',
	]
);

// Responsive
kalium_customize_register_control(
	'top_bar_responsive',
	[
		'type'         => 'kalium-checkbox-button',
		'label'        => 'Responsive',
		'separator'    => 1,
		'reset'        => true,
		'inline_label' => false,
		'choices'      => [
			'desktop' => [
				'label' => 'Desktop',
				'icon'  => 'desktop',
			],
			'tablet'  => [
				'label' => 'Tablet',
				'icon'  => 'tablet',
			],
			'mobile'  => [
				'label' => 'Mobile',
				'icon'  => 'mobile',
			],
		],
		'default'      => [
			'desktop',
		],
		'help'         => 'Select in which device types the top bar will be visible.',
	]
);

// End of general tab
kalium_customize_end_tab();

// Style tab
kalium_customize_style_tab();

// Background, border and separator colors
kalium_customize_register_control(
	'top_header_bar_container_colors',
	[
		'type'         => 'kalium-color',
		'label'        => 'Container',
		'reset'        => true,
		'enable_clear' => true,
		'choices'      => [
			'background' => 'Background',
			'border'     => 'Bottom Border',
			'separator'  => 'Separator',
		],
		'default'      => [
			'background' => kalium_color_reference( 'header_style_container.background' ),
		],
		'tooltip'      => true,
		'setting'      => [
			'transport' => 'postMessage',
		],
	]
);

// Link colors
kalium_customize_register_control(
	'top_header_bar_link_colors',
	[
		'type'         => 'kalium-color',
		'label'        => 'Links',
		'reset'        => true,
		'enable_clear' => true,
		'choices'      => [
			'normal' => 'Normal',
			'hover'  => 'Hover',
			'active' => 'Active',
		],
		'tooltip'      => true,
		'default'      => [
			'normal' => kalium_color_reference( 'header_style_links.normal' ),
			'hover'  => kalium_color_reference( 'header_style_links.hover' ),
			'active' => kalium_color_reference( 'header_style_links.active' ),
		],
		'setting'      => [
			'transport' => 'postMessage',
		],
	]
);

// Text color
kalium_customize_register_control(
	'top_header_bar_text_color',
	[
		'type'         => 'kalium-color',
		'label'        => 'Text',
		'reset'        => true,
		'enable_clear' => true,
		'default'      => kalium_color_reference( 'header_style_text' ),
		'setting'      => [
			'transport' => 'postMessage',
		],
	]
);

// End of style tab
kalium_customize_end_tab();

// End of current section
kalium_customize_end_section();

/**
 * Update options in preview.
 */

// Top Bar Container
kalium_customize_register_preview_update(
	[
		'type'    => 'js',
		'vars'    => [
			'top_header_bar_container_colors',
		],
		'content' => 'var topHeaderBar = data.api.getElement( ".top-header-bar" );
		
		if ( ! topHeaderBar ) {
			return;
		}
		
		if ( data.api.isColor( data.top_header_bar_container_colors.border ) ) {
			topHeaderBar.classList.add( "top-header-bar--has-border" );
		} else {
			topHeaderBar.classList.remove( "top-header-bar--has-border" );
		}
		
		if ( data.api.isColor( data.top_header_bar_container_colors.separator ) ) {
			topHeaderBar.classList.add( "top-header-bar--with-separators" );
		} else {
			topHeaderBar.classList.remove( "top-header-bar--with-separators" );
		}',
	]
);
