<?php
/**
 * Kalium WordPress Theme
 *
 * Performance.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

// Enqueue style.css file of the theme
kalium_customize_register_control(
	'performance_enqueue_style_css',
	[
		'type'          => 'kalium-toggle',
		'heading_title' => 'Theme',
		'label'         => 'Enqueue style.css',
		'reset'         => true,
		'default'       => true,
		'help'          => 'Removes style.css file of the theme in frontend.',
		'setting'       => [
			'transport' => 'postMessage',
		],
	]
);

// Typography / Preload fonts
kalium_customize_register_control(
	'typolab_font_preload',
	[
		'type'          => 'kalium-toggle',
		'heading_title' => 'Typography',
		'label'         => 'Font Preload',
		'separator'     => true,
		'default'       => TypoLab::$font_preload,
		'help'          => 'This option will load the font files right away on page load. Preloading Local Fonts can speeds up your website even further.',
		'setting'       => [
			'type'      => 'typolab',
			'transport' => 'postMessage',
		],
	]
);

// Pull Google Fonts
kalium_customize_register_control(
	'typolab_pull_google_fonts',
	[
		'type'    => 'kalium-toggle',
		'label'   => 'Load Google Fonts Locally',
		'default' => TypoLab::$pull_google_fonts,
		'help'    => 'Enabling this option downloads Google fonts and save them on your server. This can be great for improving speed of your website and to comply with GDPR law.',
		'setting' => [
			'type'      => 'typolab',
			'transport' => 'postMessage',
		],
	]
);

// Reload Google Fonts
kalium_customize_register_control(
	'typolab_flush_google_fonts',
	[
		'type'         => 'kalium-action-button',
		'label'        => 'Reload Google Fonts',
		'button_title' => 'Flush',
		'loading_text' => 'Flushing...',
		'action'       => admin_url( 'admin-ajax.php?action=typolab_flush_fonts' ),
		'ajax'         => true,
		'variant'      => 'secondary',
		'size'         => 'small',
		'help'         => 'Reset the local fonts cache and get the latest updates of your Google Fonts.',
		'dependency'   => [
			'typolab_pull_google_fonts' => true,
		],
	]
);

// Pull Google Fonts
kalium_customize_register_control(
	'typolab_font_display',
	[
		'type'    => 'kalium-select',
		'label'   => 'Font Face Rendering',
		'choices' => [
			'auto'     => 'Auto',
			'swap'     => 'Swap',
			'block'    => 'Block',
			'fallback' => 'Fallback',
			'optional' => 'Optional',
		],
		'default' => TypoLab::$font_display,
		'help'    => 'Font-display property (<a href="https://developer.mozilla.org/en-US/docs/Web/CSS/@font-face/font-display" target="_blank" rel="noopener noreferrer">read more</a>) defines how font files are loaded and displayed by the browser (Default: Auto).',
		'setting' => [
			'type'      => 'typolab',
			'transport' => 'postMessage',
		],
	]
);

// Preload theme icons
kalium_customize_register_control(
	'kalium_preload_theme_icons',
	[
		'type'  => 'kalium-toggle',
		'label' => 'Preload Theme Icons',
	]
);

// jQuery Migrate script
kalium_customize_register_control(
	'performance_jquery_migrate',
	[
		'type'          => 'kalium-toggle',
		'heading_title' => 'WordPress Libraries',
		'label'         => 'jQuery Migrate Script',
		'separator'     => true,
		'reset'         => true,
		'default'       => true,
		'help'          => 'If you are not using any plugin that may contain old jQuery code, you can disable this script to improve performance.',
		'setting'       => [
			'transport' => 'postMessage',
		],
	]
);

// WordPress Emoji script
kalium_customize_register_control(
	'performance_wp_emoji',
	[
		'type'    => 'kalium-toggle',
		'label'   => 'WordPress Emoji Script',
		'reset'   => true,
		'default' => true,
		'help'    => 'Removes the extra JavaScript file that is used to add support for emojis in older browsers. Emoticons and emojis will still work in browsers which have built-in support for them.',
		'setting' => [
			'transport' => 'postMessage',
		],
	]
);

// WordPress Embed script
kalium_customize_register_control(
	'performance_wp_embed',
	[
		'type'    => 'kalium-toggle',
		'label'   => 'WordPress Embed Script',
		'reset'   => true,
		'default' => true,
		'help'    => 'Removes oEmbed-specific JavaScript. Embed script checks for links to convert to embed frames, i.e. Twitter posts.',
		'setting' => [
			'transport' => 'postMessage',
		],
	]
);

// JPEG quality
kalium_customize_register_control(
	'performance_jpeg_quality',
	[
		'type'          => 'kalium-range',
		'heading_title' => 'Images',
		'label'         => 'JPEG Image Quality',
		'separator'     => true,
		'reset'         => true,
		'placeholder'   => '82',
		'suffix'        => '%',
		'min'           => 50,
		'max'           => 100,
		'help'          => 'By default, WordPress compresses your images for better performance. 82% is the default image compression, if you change this value you must <a href="admin.php?page=kalium&amp;tab=faq#faq-regenerate-thumbnails" target="_blank">regenerate thumbnails</a>.',
		'setting'       => [
			'transport' => 'postMessage',
		],
	]
);
