<?php
/**
 * Kalium WordPress Theme
 *
 * Portfolio page.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

/** @var WP_Customize_Manager $wp_customize */
global $wp_customize;

// Portfolio post type setting
if ( isset( $wp_customize ) ) {
	$wp_customize->add_setting(
		'kalium_portfolio_post_type',
		[
			'type'              => 'option',
			'sanitize_callback' => 'kalium_validate_boolean',
		]
	);
}

// Portfolio post types
$portfolio_post_types = kalium_supported_portfolio_post_types();

// Section link control
kalium_customize_register_control(
	'kalium_post_types_portfolio_page',
	[
		'type'         => 'kalium-section-link',
		'label'        => 'Portfolio Page',
		'priority'     => kalium()->customize->get_next_priority(),
		'section_link' => kalium()->customize->section_id( 'archive' ),
	]
);

/**
 * Section: Portfolio Page.
 */

// Section
kalium_customize_register_section(
	'archive',
	[
		'title' => 'Portfolio Page',
	]
);

// Portfolio Layout
kalium_customize_register_control(
	'portfolio_layout',
	[
		'type'          => 'kalium-radio-image',
		'heading_title' => 'Layout',
		'choices'       => [
			'type-1' => [
				'label' => 'Type 1',
				'image' => kalium()->assets_url( 'admin/images/portfolio/portfolio-type-1.svg' ),
			],
			'type-2' => [
				'label' => 'Type 2',
				'image' => kalium()->assets_url( 'admin/images/portfolio/portfolio-type-2.svg' ),
			],
		],
		'aspect_ratio'  => '109:80',
	]
);

// Items per page
kalium_customize_register_control(
	'portfolio_items_per_page',
	[
		'type'           => 'kalium-quantity',
		'heading_title'  => 'Grid Options',
		'separator'      => true,
		'separator_type' => 4,
		'label'          => 'Items per Page',
		'input_style'    => 'width:120px',
		'reset'          => true,
		'min'            => -1,
		'default'        => 12,
		'help'           => 'Set value to -1 to show all projects.',
	]
);

// Grid Columns
kalium_customize_register_control(
	'portfolio_grid_columns',
	[
		'type'        => 'kalium-quantity',
		'label'       => 'Columns',
		'input_style' => 'width:120px',
		'reset'       => true,
		'responsive'  => true,
		'min'         => 1,
		'max'         => [
			'desktop' => 6,
			'tablet'  => 5,
			'mobile'  => 3,
		],
		'default'     => [
			'desktop' => 4,
			'tablet'  => 2,
			'mobile'  => 1,
		],
		'setting'     => [
			'transport' => 'postMessage',
		],
	]
);

// Columns gap
kalium_customize_register_control(
	'portfolio_grid_columns_gap',
	[
		'type'             => 'kalium-range',
		'label'            => 'Columns Gap',
		'reset'            => true,
		'responsive'       => true,
		'min'              => 0,
		'max_slider'       => 100,
		'suffix'           => 'PX',
		'default'          => 30,
		'initial_position' => 30,
		'setting'          => [
			'transport' => 'postMessage',
		],
	]
);

// Layout mode
kalium_customize_register_control(
	'portfolio_grid_layout_mode',
	[
		'type'    => 'kalium-radio-button',
		'label'   => 'Layout Mode',
		'choices' => [
			'packery'  => 'Masonry',
			'fit-rows' => 'Fit Rows',
		],
	]
);

// Featured Image
kalium_customize_register_control(
	'kalium_post_types_portfolio_page_thumbnails',
	[

		'heading_title' => 'Card Options',
		'separator'     => true,
		'type'          => 'kalium-section-link',
		'label'         => 'Featured Image',
		'section_link'  => kalium()->customize->section_id( 'featured_image' ),
	]
);

// Like feature
kalium_customize_register_control(
	'portfolio_likes',
	[
		'type'         => 'kalium-toggle',
		'label'        => 'Like Feature',
		'default'      => true,
		'section_link' => kalium()->customize->section_id( 'like' ),
	]
);

// Subtitles
kalium_customize_register_control(
	'portfolio_loop_subtitles',
	[
		'type'         => 'kalium-toggle',
		'label'        => 'Subtitle',
		'default'      => true,
		'section_link' => kalium()->customize->section_id( 'subtitle' ),
	]
);

// Reveal Effect
kalium_customize_register_control(
	'portfolio_reveal_effect',
	[
		'type'        => 'kalium-select',
		'label'       => 'Reveal Effect',
		'input_style' => 'width:120px',
		'choices'     => [
			'none'           => 'None',
			'fade'           => 'Fade',
			'slidenfade'     => 'Slide and Fade',
			'zoom'           => 'Zoom In',
			'fade-one'       => 'Fade (one by one)',
			'slidenfade-one' => 'Slide and Fade (one by one)',
			'zoom-one'       => 'Zoom In (one by one)',
		],
		'default'     => 'slidenfade',
	]
);

// Content Alignment
kalium_customize_register_control(
	'portfolio_layout_2_content_position',
	[
		'type'        => 'kalium-select',
		'label'       => 'Content Alignment',
		'input_style' => 'width:120px',
		'width'       => 30,
		'choices'     => [
			'top-left'     => 'Top Left',
			'top-right'    => 'Top Right',
			'center'       => 'Center',
			'bottom-left'  => 'Bottom Left',
			'bottom-right' => 'Bottom Right',
		],
		'default'     => 'bottom-left',
		'dependency'  => [
			'portfolio_layout' => 'type-2',
		],
	]
);

// Show Header Title
kalium_customize_register_control(
	'portfolio_show_header_title',
	[
		'type'          => 'kalium-toggle',
		'heading_title' => 'Page Elements',
		'label'         => 'Title & Description',
		'separator'     => true,
		'default'       => true,
		'section_link'  => kalium()->customize->section_id( 'page_heading' ),
	]
);

// Category Filter
kalium_customize_register_control(
	'portfolio_filters',
	[
		'type'         => 'kalium-toggle',
		'label'        => 'Filters',
		'default'      => true,
		'section_link' => kalium()->customize->section_id( 'filters' ),
	]
);

// Full-width container
kalium_customize_register_control(
	'portfolio_full_width',
	[
		'type'         => 'kalium-toggle',
		'label'        => 'Full Width Container',
		'section_link' => kalium()->customize->section_id( 'full_width' ),
	]
);

// Pagination
kalium_customize_register_control(
	'portfolio_pagination',
	[
		'type'         => 'kalium-section-link',
		'label'        => 'Pagination',
		'section_link' => kalium()->customize->section_id( 'pagination' ),
	]
);

// Lightbox
kalium_customize_register_control(
	'portfolio_lightbox',
	[
		'type'         => 'kalium-section-link',
		'label'        => 'Lightbox Type',
		'section_link' => kalium()->customize->section_id( 'lightbox' ),
	]
);

/**
 * Subsection: Featured Image.
 */

// Subsection: Featured Image
kalium_customize_register_section(
	'featured_image',
	[
		'title' => 'Featured Image',
	]
);

// General tab
kalium_customize_general_tab();

// Hover Effect
kalium_customize_register_control(
	'portfolio_thumbnail_hover_effect',
	[
		'type'    => 'kalium-toggle',
		'label'   => 'Hover Overlay',
		'default' => true,
	]
);

// Hover layer padding
kalium_customize_register_control(
	'portfolio_thumbnail_hover_padding',
	[
		'type'             => 'kalium-range',
		'label'            => 'Offset',
		'min'              => 0,
		'max'              => 50,
		'placeholder'      => 0,
		'initial_position' => 0,
		'reset'            => true,
		'responsive'       => true,
		'suffix'           => 'PX',
		'setting'          => [
			'transport' => 'postMessage',
		],
		'dependency'       => [
			'portfolio_thumbnail_hover_effect' => true,
		],
	]
);

// Thumbnail Hover Icon
kalium_customize_register_control(
	'portfolio_thumbnail_hover_icon',
	[
		'type'         => 'kalium-radio-button',
		'label'        => 'Icon',
		'inline_label' => false,
		'choices'      => [
			'none'   => 'None',
			'eye'    => 'Eye Icon',
			'custom' => 'Custom Icon',
		],
		'default'      => 'eye',
		'dependency'   => [
			'portfolio_layout'                 => 'type-1',
			'portfolio_thumbnail_hover_effect' => true,
		],
	]
);

// Thumbnail Hover Icon Eye
kalium_customize_register_control(
	'portfolio_thumbnail_hover_icon_eye',
	[
		'type'       => 'kalium-radio-button',
		'label'      => 'Eye Icon',
		'choices'    => [
			'static'   => 'Static',
			'animated' => 'Animated',
		],
		'dependency' => [
			'portfolio_layout'                 => 'type-1',
			'portfolio_thumbnail_hover_effect' => true,
			'portfolio_thumbnail_hover_icon'   => 'eye',
		],
	]
);

// Custom Hover icon
kalium_customize_register_control(
	'portfolio_thumbnail_hover_icon_custom',
	[
		'type'           => 'kalium-media',
		'label'          => 'Custom Icon',
		'height'         => 65,
		'library_params' => [
			'type' => 'image',
		],
		'dependency'     => [
			'portfolio_layout'                 => 'type-1',
			'portfolio_thumbnail_hover_effect' => true,
			'portfolio_thumbnail_hover_icon'   => 'custom',
		],
	]
);

// Custom Hover icon width
kalium_customize_register_control(
	'portfolio_thumbnail_hover_icon_custom_width',
	[
		'type'       => 'kalium-range',
		'label'      => 'Icon Width',
		'min'        => 10,
		'max'        => 200,
		'default'    => 35,
		'reset'      => true,
		'suffix'     => 'PX',
		'dependency' => [
			'portfolio_layout'                 => 'type-1',
			'portfolio_thumbnail_hover_effect' => true,
			'portfolio_thumbnail_hover_icon'   => 'custom',
		],
	]
);

// Image size
kalium()->customize->register_image_size_settings(
	'portfolio_thumbnails',
	[
		'default' => 'medium',
	]
);

// Thumbnails aspect ratio
kalium()->customize->register_aspect_ratio_settings( 'portfolio_thumbnails' );

// End of general tab
kalium_customize_end_tab();

// Style tab
kalium_customize_style_tab();

// Border radius
kalium_customize_register_control(
	'portfolio_thumbnail_border_radius',
	[
		'type'       => 'kalium-multi-numeric',
		'label'      => 'Border Radius',
		'responsive' => true,
		'units'      => kalium_get_default_units( 'box-size' ),
		'default'    => [
			'link' => true,
		],
		'reset'      => true,
		'setting'    => [
			'transport' => 'postMessage',
		],
	]
);

// Hover layer bg type
kalium_customize_register_control(
	'portfolio_thumbnail_hover_bg_type',
	[
		'type'          => 'kalium-radio-button',
		'heading_title' => 'Hover Overlay',
		'label'         => 'Background',
		'inline_label'  => false,
		'separator'     => true,
		'choices'       => [
			'color'          => 'Color',
			'dominant-color' => 'Dominant Color',
		],
		'dependency'    => [
			'portfolio_thumbnail_hover_effect' => true,
		],
	]
);

// Hover Background Color
kalium_customize_register_control(
	'portfolio_thumbnail_hover_bg',
	[
		'type'       => 'kalium-color',
		'label'      => 'Background Color',
		'reset'      => true,
		'default'    => kalium_color_reference( 'theme_colors.color-1', 0.9 ),
		'setting'    => [
			'transport' => 'postMessage',
		],
		'dependency' => [
			'portfolio_thumbnail_hover_effect'  => true,
			'portfolio_thumbnail_hover_bg_type' => 'color',
		],
	]
);

// Opacity
kalium_customize_register_control(
	'portfolio_thumbnail_hover_bg_alpha',
	[
		'type'             => 'kalium-range',
		'label'            => 'Color Opacity',
		'reset'            => true,
		'min'              => 0,
		'max'              => 100,
		'initial_position' => 90,
		'default'          => 90,
		'suffix'           => '%',
		'setting'          => [
			'transport' => 'postMessage',
		],
		'dependency'       => [
			'portfolio_thumbnail_hover_effect'  => true,
			'portfolio_thumbnail_hover_bg_type' => 'dominant-color',
		],
	]
);

// Overlay Text Color Type
kalium_customize_register_control(
	'portfolio_thumbnail_hover_text_color_type',
	[
		'type'         => 'kalium-radio-button',
		'label'        => 'Text Color',
		'inline_label' => false,
		'choices'      => [
			'auto'   => 'Auto',
			'custom' => 'Custom Color',
		],
		'dependency'   => [
			'portfolio_thumbnail_hover_effect' => true,
		],
	]
);

// Overlay Text Color
kalium_customize_register_control(
	'portfolio_thumbnail_hover_text_color',
	[
		'type'       => 'kalium-color',
		'label'      => 'Custom Text Color',
		'reset'      => true,
		'default'    => kalium_color_reference( 'theme_colors_text.normal' ),
		'setting'    => [
			'transport' => 'postMessage',
		],
		'dependency' => [
			'portfolio_thumbnail_hover_effect'          => true,
			'portfolio_thumbnail_hover_text_color_type' => 'custom',
		],
	]
);

// End of style tab
kalium_customize_end_tab();

// End of current section
kalium_customize_end_section();

/**
 * Subsection: Like feature.
 */

// Subsection: Like
kalium_customize_register_section(
	'like',
	[
		'title' => 'Like Feature',
	]
);

// Like Icon
kalium_customize_register_control(
	'portfolio_likes_icon',
	[
		'type'       => 'kalium-radio-button',
		'label'      => 'Icon',
		'choices'    => [
			'heart' => [
				'label' => 'Heart',
				'icon'  => 'likeHeart',
			],
			'thumb' => [
				'label' => 'Thumb',
				'icon'  => 'likeThumb',
			],
			'star'  => [
				'label' => 'Star',
				'icon'  => 'likeStar',
			],
		],
		'dependency' => [
			'portfolio_likes' => true,
		],
	]
);

// End of current section
kalium_customize_end_section();

/**
 * Subsection: Category Filter.
 */

// Subsection: Filters
kalium_customize_register_section(
	'filters',
	[
		'title' => 'Filters',
	]
);

// Filters
kalium_customize_register_control(
	'portfolio_filters_taxonomies',
	[
		'type'         => 'kalium-checkbox',
		'label'        => 'Filters',
		'inline_label' => false,
		'choices'      => static function () {
			$taxonomies = get_object_taxonomies( kalium_supported_portfolio_post_types(), 'objects' );
			$choices    = [];

			foreach ( $taxonomies as $taxonomy ) {
				$choices[ $taxonomy->name ] = $taxonomy->label;
			}

			return $choices;
		},
		'default'      => [
			'portfolio_category',
		],
	]
);

// Reset
kalium_customize_register_control(
	'portfolio_filters_reset',
	[
		'type'           => 'kalium-toggle',
		'label'          => 'Show All',
		'default'        => true,
		'separator'      => true,
		'separator_type' => 3,
	]
);

// Reset text
kalium_customize_register_control(
	'portfolio_filters_reset_text',
	[
		'type'        => 'kalium-text',
		'label'       => 'Show All Text',
		'input_style' => 'width: 80px',
		'default'     => esc_html__( 'All', 'kalium' ),
		'dependency'  => [
			'portfolio_filters_reset' => true,
		],
	]
);

// Show count
kalium_customize_register_control(
	'portfolio_filters_count',
	[
		'type'           => 'kalium-toggle',
		'label'          => 'Show Count',
		'separator'      => true,
		'separator_type' => 3,
	]
);

// Count style
kalium_customize_register_control(
	'portfolio_filters_count_style',
	[
		'type'        => 'kalium-select',
		'label'       => 'Style',
		'input_style' => 'width: 100px',
		'choices'     => [
			'style-1' => 'Style 1',
			'style-2' => 'Style 2',
		],
		'dependency'  => [
			'portfolio_filters_count' => true,
		],
	]
);

// Count before
kalium_customize_register_control(
	'portfolio_filters_count_before',
	[
		'type'        => 'kalium-text',
		'label'       => 'Before',
		'input_style' => 'width: 60px',
		'reset'       => true,
		'default'     => '(',
		'dependency'  => [
			'portfolio_filters_count' => true,
		],
	]
);

// Count before
kalium_customize_register_control(
	'portfolio_filters_count_after',
	[
		'type'        => 'kalium-text',
		'label'       => 'After',
		'input_style' => 'width: 60px',
		'reset'       => true,
		'default'     => ')',
		'dependency'  => [
			'portfolio_filters_count' => true,
		],
	]
);

// Subcategories
kalium_customize_register_control(
	'portfolio_filters_sub_terms',
	[
		'type'           => 'kalium-toggle',
		'label'          => 'Subcategories',
		'separator'      => true,
		'separator_type' => 3,
		'default'        => true,
	]
);

// Dynamic Heading
kalium_customize_register_control(
	'portfolio_filters_dynamic_heading',
	[
		'type'           => 'kalium-select',
		'label'          => 'Dynamic Heading',
		'separator'      => true,
		'separator_type' => 3,
		'input_style'    => 'width:130px',
		'choices'        => [
			'disable'       => 'Disable',
			'title'         => 'Change title',
			'content'       => 'Change description',
			'title-content' => 'Change title and description',
		],
		'help'           => 'Change portfolio heading title and/or description when clicking on portfolio filter',
		'dependency'     => [
			'portfolio_show_header_title' => true,
		],
	]
);

// Supported history types
$history_types = [
	'none'      => 'None',
	'hash'      => 'Hash (appended in the end of URL)',
	'pushState' => 'Absolute Link',
];

// Link Type
kalium_customize_register_control(
	'portfolio_filters_history_type',
	[
		'type'        => 'kalium-select',
		'label'       => 'Link Format',
		'input_style' => 'width:130px',
		'choices'     => $history_types,
		'help'        => '<a href="https://docs.kaliumtheme.com/post-types/portfolio/portfolio-page#link-format" target="_blank" rel="noopener">Learn more</a>',
	]
);

// Default Category
kalium_customize_register_control(
	'portfolio_category_default',
	[
		'type'          => 'kalium-select',
		'heading_title' => 'Categories',
		'label'         => 'Default Category',
		'input_style'   => 'width:130px',
		'separator'     => true,
		'choices'       => static function () {
			return array_merge(
				[
					'none' => 'None',
				],
				wp_list_pluck(
					get_terms(
						[
							'taxonomy' => 'portfolio_category',
						]
					),
					'name',
					'slug'
				)
			);
		},
		'dependency'    => [
			'portfolio_filters_taxonomies' => [
				'value'   => 'portfolio_category',
				'compare' => 'CONTAINS',
			],
		],
	]
);

// Filter label
kalium_customize_register_control(
	'portfolio_category_filter_label',
	[
		'type'        => 'kalium-text',
		'label'       => 'Filter Label',
		'input_style' => 'width:130px',
		'dependency'  => [
			'portfolio_filters_taxonomies' => [
				'value'   => 'portfolio_category',
				'compare' => 'CONTAINS',
			],
		],
	]
);

// Default Tag
kalium_customize_register_control(
	'portfolio_tag_default',
	[
		'type'          => 'kalium-select',
		'heading_title' => 'Tags',
		'label'         => 'Default Tag',
		'input_style'   => 'width:130px',
		'separator'     => true,
		'choices'       => static function () {
			return array_merge(
				[
					'none' => 'None',
				],
				wp_list_pluck(
					get_terms(
						[
							'taxonomy' => 'portfolio_tag',
						]
					),
					'name',
					'slug'
				)
			);
		},
		'dependency'    => [
			'portfolio_filters_taxonomies' => [
				'value'   => 'portfolio_tag',
				'compare' => 'CONTAINS',
			],
		],
	]
);

// Filter label
kalium_customize_register_control(
	'portfolio_tag_filter_label',
	[
		'type'        => 'kalium-text',
		'label'       => 'Filter Label',
		'input_style' => 'width:130px',
		'dependency'  => [
			'portfolio_filters_taxonomies' => [
				'value'   => 'portfolio_tag',
				'compare' => 'CONTAINS',
			],
		],
	]
);

// End of current section
kalium_customize_end_section();

/**
 * Subsection: Subtitle.
 */

// Subsection: Subtitle
kalium_customize_register_section(
	'subtitle',
	[
		'title' => 'Subtitle',
	]
);

// Subtitle Content
kalium_customize_register_control(
	'portfolio_loop_subtitles_content',
	[
		'type'       => 'kalium-select',
		'label'      => 'Subtitle Content',
		'choices'    => [
			'categories'        => 'Categories',
			'categories-parent' => 'Parent Categories',
			'tags'              => 'Tags',
			'subtitle'          => 'Subtitle',
		],
		'dependency' => [
			'portfolio_loop_subtitles' => true,
		],
	]
);

// Separator
kalium_customize_register_control(
	'portfolio_loop_subtitles_terms_separator',
	[
		'type'       => 'kalium-text',
		'label'      => 'Separator',
		'default'    => ', ',
		'dependency' => [
			'portfolio_loop_subtitles_content' => [
				'categories',
				'categories-parent',
				'tags',
			],
		],
	]
);

// End of current section
kalium_customize_end_section();

/**
 * Subsection: Title and description.
 */

// Subsection: Title and Description
kalium_customize_register_section(
	'page_heading',
	[
		'title' => 'Title & Description',
	]
);

// Heading Layout
kalium_customize_register_control(
	'portfolio_heading_layout',
	[
		'type'         => 'kalium-radio-button',
		'label'        => 'Heading and Filter Layout',
		'inline_label' => false,
		'choices'      => [
			'type-1' => [
				'label' => 'Align Left',
				'icon'  => 'justifyLeft',
				'size'  => 16,
			],
			'type-2' => [
				'label' => 'Align Center',
				'icon'  => 'justifyCenter',
				'size'  => 16,
			],
			'type-3' => [
				'label' => 'Space Between',
				'icon'  => 'justifySpaceBetween',
				'size'  => 16,
			],
		],
		'columns'      => 'auto',
		'show_labels'  => false,
		'tooltips'     => true,
	]
);

// Portfolio Title
kalium_customize_register_control(
	'portfolio_title',
	[
		'type'         => 'kalium-text',
		'label'        => 'Portfolio Title',
		'inline_label' => false,
		'default'      => 'Portfolio',
	]
);

// Portfolio Description
kalium_customize_register_control(
	'portfolio_description',
	[
		'type'    => 'kalium-textarea',
		'label'   => 'Portfolio Description',
		'rows'    => 7,
		'default' => 'Our everyday work is presented here, we do what we love,
Case studies, video presentations and photo-shootings below',
	]
);

// End of current section
kalium_customize_end_section();

/**
 * Subsection: Full width container.
 */

// Subsection
kalium_customize_register_section(
	'full_width',
	[
		'title' => 'Full Width Container',
	]
);

// Full-width title container
kalium_customize_register_control(
	'portfolio_full_width_heading',
	[
		'type'       => 'kalium-select',
		'label'      => 'Portfolio Heading',
		'reset'      => true,
		'choices'    => [
			'contained'  => 'Container',
			'full-width' => 'Full Width',
		],
		'dependency' => [
			'portfolio_full_width' => true,
		],
	]
);

// Stretch portfolio items to the edge
kalium_customize_register_control(
	'portfolio_full_width_stretch_edge',
	[
		'type'       => 'kalium-toggle',
		'label'      => 'Stretch Items to the Edge',
		'reset'      => true,
		'responsive' => true,
	]
);

// End of section
kalium_customize_end_section();

/**
 * Subsection: Pagination.
 */

// Subsection: Pagination
kalium_customize_register_section(
	'pagination',
	[
		'title' => 'Pagination',
	]
);

// Pagination settings
kalium()->customize->register_pagination_settings( 'portfolio_pagination' );

// End of current section
kalium_customize_end_section();

/**
 * Subsection: Lightbox Settings.
 */

// Subsection: Lightbox
kalium_customize_register_section(
	'lightbox',
	[
		'title' => 'Lightbox Type',
	]
);

// Browse Mode
kalium_customize_register_control(
	'portfolio_lb_navigation_mode',
	[
		'type'    => 'kalium-radio-button',
		'label'   => 'Browse Mode',
		'choices' => [
			'single' => 'Single',
			'linked' => 'Linked',
		],
		'help'    => 'If set to "Linked" mode, lightbox previous and next arrows will continue through all projects shown in the list.',
	]
);

// URL Hash
kalium_customize_register_control(
	'portfolio_lightbox_history_type',
	[
		'type'        => 'kalium-select',
		'label'       => 'Link Format',
		'input_style' => 'width: 150px',
		'choices'     => $history_types,
		'default'     => 'hash',
	]
);

// End of current section
kalium_customize_end_section();

// End of parent section (kalium_post_types_portfolio_page)
kalium_customize_end_section();

/**
 * Update options in preview.
 */

kalium_customize_register_preview_update(
	[
		'type'    => 'css',
		'vars'    => [
			'portfolio_grid_columns',
			'portfolio_grid_columns_gap',
			'portfolio_thumbnail_hover_padding',
			'portfolio_thumbnails_aspect_ratio',
			'portfolio_thumbnails_aspect_ratio_custom',
		],
		'content' => <<<EOD
<#
var portfolioSelectors = '.portfolio-items',
	portfolioContainers = data.api.getElements( portfolioSelectors );

portfolioContainers.forEach( function( portfolioContainer ) {
	// Column classes
	if ( ! portfolioContainer.classList.contains( 'portfolio-items--columns-modified' ) ) {
		data.api.setResponsiveClassNames( portfolioContainer, 'columns', data.portfolio_grid_columns );
	}
} );

// Relayout Isotope
data.api.relayoutIsotope( portfolioSelectors ); 
#>

{{{ data.api.printInlineStyle( {
	selector: portfolioSelectors,
	value: data.portfolio_grid_columns_gap,
	varName: 'grid-gap',
	addUnit: 'px',
} ) }}}

{{{ data.api.printInlineStyle( {
	selector: portfolioSelectors,
	value: data.portfolio_thumbnail_hover_padding,
	varName: 'pi-overlay-offset',
	addUnit: 'px',
} ) }}}

{{{ data.api.printInlineStyle( {
	selector: portfolioSelectors,
	varName: 'custom-aspect-ratio',
	value: data.portfolio_thumbnails_aspect_ratio,
	parser: function( value ) {
		if ( 'custom' === value ) {
			return data.api.currentResponsiveValue( data.portfolio_thumbnails_aspect_ratio_custom );
		}
		
		return 'auto' === value ? null : value;
	},
} ) }}}
EOD,
	]
);

kalium_customize_register_preview_update( [
	'type'    => 'css',
	'vars'    => [
		'portfolio_thumbnail_border_radius',
		'portfolio_thumbnail_hover_bg',
		'portfolio_thumbnail_hover_bg_alpha',
		'portfolio_thumbnail_hover_text_color_type',
		'portfolio_thumbnail_hover_text_color',
	],
	'content' => <<<EOD
<#
var portfolioSelectors = '.portfolio-items',
	firstOverlay = document.querySelector( '.portfolio-item__hover-overlay' );
	
firstOverlay.classList.add( 'portfolio-item__hover-overlay--is-visible' );
#>

{{{ data.api.printInlineStyle( {
	selector: portfolioSelectors,
	varName: 'pi-overlay-bg',
	value: data.portfolio_thumbnail_hover_bg,
} ) }}}

{{{ data.api.printInlineStyle( {
	selector: portfolioSelectors,
	varName: 'pi-overlay-bg-alpha',
	value: data.portfolio_thumbnail_hover_bg_alpha / 100,
} ) }}}

{{{ data.api.printInlineStyle( {
	selector: portfolioSelectors + ' .portfolio-item',
	value: data.portfolio_thumbnail_hover_text_color,
	parser: function( value ) {
		if ( 'custom' === data.portfolio_thumbnail_hover_text_color_type ) {
			value = data.api.parseColor( value );
			
			return {
				[ data.api.cssVarName( 'pi-overlay-color' ) ]: value,
				[ data.api.cssVarName( 'link-hover-color' ) ]: value,
			};
		}
	}
} ) }}}

{{{ data.api.printInlineStyle( {
	selector: portfolioSelectors,
	varName: 'pi-thumbnail-border-radius',
	value: data.portfolio_thumbnail_border_radius,
	parser: 'length',
} ) }}}
EOD,
] );
