<?php
/**
 * Kalium WordPress Theme
 *
 * Colors.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

// Theme color vars
$theme_color_vars = kalium_get_theme_color_vars();

// Section link control
kalium_customize_register_control(
	'kalium_styling_colors',
	[
		'type'         => 'kalium-section-link',
		'label'        => 'Colors',
		'priority'     => kalium()->customize->get_next_priority(),
		'section_link' => kalium()->customize->section_id( 'colors' ),
	]
);

/**
 * Section: Colors.
 */

// Section
kalium_customize_register_section(
	'colors',
	[
		'title' => 'Colors',
	]
);

// Theme base colors
kalium_customize_register_control(
	$theme_color_vars['theme']['id'],
	array_merge(
		[
			'type'         => 'kalium-color',
			'label'        => 'Theme Colors',
			'description'  => 'Choose theme colors or select from predefined palettes',
			'reset'        => true,
			'inline_label' => false,
			'setting'      => [
				'transport' => 'postMessage',
			],
		],
		kalium_get_theme_base_colors_args()
	)
);

// Links
kalium_customize_register_control(
	$theme_color_vars['link']['id'],
	[
		'type'          => 'kalium-color',
		'label'         => 'Links',
		'heading_title' => 'Global Colors',
		'separator'     => true,
		'reset'         => true,
		'choices'       => [
			'normal' => 'Normal',
			'hover'  => 'Hover',
		],
		'default'       => [
			'normal' => kalium_color_reference( 'theme_colors.color-1' ),
			'hover'  => kalium_color_reference( 'theme_colors.color-2' ),
		],
		'tooltip'       => true,
		'setting'       => [
			'transport' => 'postMessage',
		],
	]
);

// Paragraphs
kalium_customize_register_control(
	$theme_color_vars['text']['id'],
	[
		'type'    => 'kalium-color',
		'label'   => 'Text',
		'reset'   => true,
		'tooltip' => true,
		'choices' => [
			'normal' => 'Normal',
			'muted'  => 'Muted',
		],
		'default' => [
			'normal' => kalium_color_reference( 'theme_colors.color-3' ),
			'muted'  => kalium_color_variant( kalium_color_reference( 'theme_colors_text.normal' ), [ 'shift(-22)' ] ),
		],
		'setting' => [
			'transport' => 'postMessage',
		],
	]
);

// Text selection
kalium_customize_register_control(
	$theme_color_vars['text-selection']['id'],
	[
		'type'    => 'kalium-color',
		'label'   => 'Text Selection',
		'reset'   => true,
		'tooltip' => true,
		'choices' => [
			'text'       => 'Text',
			'background' => 'Background',
		],
		'default' => [
			'text'       => kalium_color_reference( 'theme_colors_body' ),
			'background' => kalium_color_reference( 'theme_colors.color-1' ),
		],
		'setting' => [
			'transport' => 'postMessage',
		],
	]
);

// Borders
kalium_customize_register_control(
	$theme_color_vars['border']['id'],
	[
		'type'    => 'kalium-color',
		'label'   => 'Borders',
		'reset'   => true,
		'default' => kalium_color_reference( 'theme_colors.color-5' ),
		'setting' => [
			'transport' => 'postMessage',
		],
	]
);

// Headings
kalium_customize_register_control(
	$theme_color_vars['headings']['id'],
	[
		'type'          => 'kalium-color',
		'label'         => 'Headings (H1 - H6)',
		'heading_title' => 'Headings',
		'separator'     => true,
		'reset'         => true,
		'default'       => kalium_color_reference( 'theme_colors.color-4' ),
		'setting'       => [
			'transport' => 'postMessage',
		],
	]
);

// Heading 1
kalium_customize_register_control(
	$theme_color_vars['h1']['id'],
	[
		'type'    => 'kalium-color',
		'label'   => 'Heading 1 (H1)',
		'reset'   => true,
		'default' => kalium_color_reference( 'theme_colors_headings' ),
		'setting' => [
			'transport' => 'postMessage',
		],
	]
);

// Heading 2
kalium_customize_register_control(
	$theme_color_vars['h2']['id'],
	[
		'type'    => 'kalium-color',
		'label'   => 'Heading 2 (H2)',
		'reset'   => true,
		'default' => kalium_color_reference( 'theme_colors_headings' ),
		'setting' => [
			'transport' => 'postMessage',
		],
	]
);

// Heading 3
kalium_customize_register_control(
	$theme_color_vars['h3']['id'],
	[
		'type'    => 'kalium-color',
		'label'   => 'Heading 3 (H3)',
		'reset'   => true,
		'default' => kalium_color_reference( 'theme_colors_headings' ),
		'setting' => [
			'transport' => 'postMessage',
		],
	]
);

// Heading 4
kalium_customize_register_control(
	$theme_color_vars['h4']['id'],
	[
		'type'    => 'kalium-color',
		'label'   => 'Heading 4 (H4)',
		'reset'   => true,
		'default' => kalium_color_reference( 'theme_colors_headings' ),
		'setting' => [
			'transport' => 'postMessage',
		],
	]
);

// Heading 5
kalium_customize_register_control(
	$theme_color_vars['h5']['id'],
	[
		'type'    => 'kalium-color',
		'label'   => 'Heading 5 (H5)',
		'reset'   => true,
		'default' => kalium_color_reference( 'theme_colors_headings' ),
		'setting' => [
			'transport' => 'postMessage',
		],
	]
);

// Heading 6
kalium_customize_register_control(
	$theme_color_vars['h6']['id'],
	[
		'type'    => 'kalium-color',
		'label'   => 'Heading 6 (H6)',
		'reset'   => true,
		'default' => kalium_color_reference( 'theme_colors_headings' ),
		'setting' => [
			'transport' => 'postMessage',
		],
	]
);

// Footer
kalium_customize_register_control(
	$theme_color_vars['footer']['id'],
	[
		'type'          => 'kalium-color',
		'label'         => 'Footer',
		'heading_title' => 'Other Colors',
		'separator'     => true,
		'reset'         => true,
		'choices'       => [
			'background' => 'Background',
			'text'       => 'Text',
			'headings'   => 'Headings',
			'link'       => 'Link',
			'link-hover' => 'Link Hover',
		],
		'default'       => [
			'background' => kalium_color_reference( 'theme_colors.color-6' ),
			'text'       => kalium_color_reference( 'theme_colors_text.normal' ),
			'headings'   => kalium_color_reference( 'theme_colors_text.normal' ),
			'link'       => kalium_color_reference( 'theme_colors_link.normal' ),
			'link-hover' => kalium_color_reference( 'theme_colors_link.hover' ),
		],
		'tooltip'       => true,
		'setting'       => [
			'transport' => 'postMessage',
		],
	]
);

// Body
kalium_customize_register_control(
	$theme_color_vars['body']['id'],
	[
		'type'    => 'kalium-color',
		'label'   => 'Site Background',
		'reset'   => true,
		'default' => kalium_color_reference( 'theme_colors.color-7' ),
		'setting' => [
			'transport' => 'postMessage',
		],
	]
);

// Overlay
kalium_customize_register_control(
	$theme_color_vars['overlay']['id'],
	[
		'type'    => 'kalium-color',
		'label'   => 'Overlay',
		'reset'   => true,
		'default' => kalium_color_variant( kalium_color_reference( 'theme_colors.color-4' ), [ 'alpha(0.7)' ] ),
		'setting' => [
			'transport' => 'postMessage',
		],
	]
);

// End of current section
kalium_customize_end_section();
