<?php
/**
 * Kalium WordPress Theme
 *
 * Forms.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

// Section link control
kalium_customize_register_control(
	'kalium_styling_forms',
	[
		'type'         => 'kalium-section-link',
		'label'        => 'Forms',
		'priority'     => kalium()->customize->get_next_priority(),
		'section_link' => kalium()->customize->section_id( 'forms' ),
	]
);

/**
 * Section: Forms.
 */

// Section
kalium_customize_register_section(
	'forms',
	[
		'title' => 'Forms',
	]
);

// General tab
kalium_customize_general_tab();

// Form style
kalium_customize_register_control(
	'form_style',
	[
		'type'     => 'kalium-radio-image',
		'label'    => 'Form Layout',
		'reset'    => true,
		'choices'  => [
			'type-1' => [
				'label' => 'Type 1',
				'image' => kalium()->assets_url( 'admin/images/theme-options/form-layout-1.svg' ),
			],
			'type-2' => [
				'label' => 'Type 2',
				'image' => kalium()->assets_url( 'admin/images/theme-options/form-layout-2.svg' ),
			],
		],
		'tooltips' => true,
		'setting'  => [
			'transport' => 'postMessage',
		],
	]
);

// Legacy form style
kalium_customize_register_control(
	'legacy_form_style',
	[
		'type'      => 'kalium-toggle',
		'label'     => 'Legacy Form Style',
		'help'      => 'Use legacy form style for contact form and comment form (from previous ' . kalium_get_theme_name() . ' 3 version)',
		'separator' => true,
	]
);

// End of general tab
kalium_customize_end_tab();

// Style tab
kalium_customize_style_tab();

// Input placeholder text color
kalium_customize_register_control(
	'form_input_placeholder_color',
	[
		'type'          => 'kalium-color',
		'heading_title' => 'Input & Textarea',
		'label'         => 'Placeholder',
		'reset'         => true,
		'default'       => kalium_color_variant( kalium_color_reference( 'theme_colors_text.normal' ), [ 'shift(-40)' ] ),
		'setting'       => [
			'transport' => 'postMessage',
		],
	]
);

// Input text color
kalium_customize_register_control(
	'form_input_color',
	[
		'type'    => 'kalium-color',
		'label'   => 'Text',
		'reset'   => true,
		'choices' => [
			'normal' => 'Normal',
			'hover'  => 'Hover',
			'focus'  => 'Focus',
		],
		'default' => [
			'normal' => kalium_color_reference( 'theme_colors_text.normal' ),
			'hover'  => kalium_color_reference( 'form_input_color.normal' ),
			'focus'  => kalium_color_reference( 'form_input_color.hover' ),
		],
		'tooltip' => true,
		'setting' => [
			'transport' => 'postMessage',
		],
	]
);

// Input background color
kalium_customize_register_control(
	'form_input_bg',
	[
		'type'       => 'kalium-color',
		'label'      => 'Background',
		'reset'      => true,
		'choices'    => [
			'normal' => 'Normal',
			'hover'  => 'Hover',
			'focus'  => 'Focus',
		],
		'default'    => [
			'normal' => kalium_color_reference( 'theme_colors_body' ),
			'hover'  => kalium_color_reference( 'form_input_bg.normal' ),
			'focus'  => kalium_color_reference( 'form_input_bg.hover' ),
		],
		'tooltip'    => true,
		'setting'    => [
			'transport' => 'postMessage',
		],
		'dependency' => [
			'form_style' => 'type-1',
		],
	]
);

// Input border color
kalium_customize_register_control(
	'form_input_border',
	[
		'type'         => 'kalium-color',
		'label'        => 'Border',
		'reset'        => true,
		'choices'      => [
			'normal' => 'Normal',
			'hover'  => 'Hover',
			'focus'  => 'Focus',
		],
		'default'      => [
			'normal' => kalium_color_variant( kalium_color_reference( 'theme_colors.color-8' ), [ 'shift(10)' ] ),
			'hover'  => kalium_color_variant( kalium_color_reference( 'theme_colors.color-5' ), [ 'shift(44)' ] ),
			'focus'  => kalium_color_reference( 'theme_colors_link.normal' ),
		],
		'tooltip'      => true,
		'enable_clear' => true,
		'setting'      => [
			'transport' => 'postMessage',
		],
	]
);

// Border width
kalium_customize_register_control(
	'form_input_border_width',
	[
		'type'        => 'kalium-quantity',
		'label'       => 'Border Width',
		'reset'       => true,
		'responsive'  => true,
		'input_style' => 'width:120px',
		'min'         => 0,
		'max'         => 5,
		'placeholder' => 1,
		'default'     => 1,
		'setting'     => [
			'transport' => 'postMessage',
		],
	]
);

// Input padding
kalium_customize_register_control(
	'form_input_padding',
	[
		'type'        => 'kalium-multi-numeric',
		'label'       => 'Padding',
		'reset'       => true,
		'responsive'  => true,
		'placeholder' => [
			'top'    => 8,
			'right'  => 12,
			'bottom' => 8,
			'left'   => 12,
		],
		'min'         => 0,
		'max'         => 50,
		'default'     => [
			'link' => false,
		],
		'units'       => kalium_get_default_units( 'length' ),
		'setting'     => [
			'transport' => 'postMessage',
		],
	]
);

// Input border Radius
kalium_customize_register_control(
	'form_input_radius',
	[
		'type'        => 'kalium-multi-numeric',
		'label'       => 'Border Radius',
		'reset'       => true,
		'responsive'  => true,
		'placeholder' => [
			'top'    => 3,
			'right'  => 3,
			'bottom' => 3,
			'left'   => 3,
		],
		'min'         => 0,
		'max'         => 100,
		'units'       => kalium_get_default_units( 'box-size' ),
		'setting'     => [
			'transport' => 'postMessage',
		],
		'dependency'  => [
			'form_style' => 'type-1',
		],
	]
);

// Input box shadow
kalium_customize_register_control(
	'form_input_shadow',
	[
		'type'               => 'kalium-box-shadow',
		'heading_title'      => 'Box Shadow',
		'label'              => 'Normal',
		'separator'          => true,
		'reset'              => true,
		'enable_color_clear' => true,
		'placeholder'        => [
			'offset_x'      => 0,
			'offset_y'      => 1,
			'blur_radius'   => 2,
			'spread_radius' => 0,
		],
		'default'            => [
			'color' => kalium_color_variant( '#000000', [ 'alpha(0.05)' ] ),
		],
		'units'              => kalium_get_default_units( 'box-size' ),
		'setting'            => [
			'transport' => 'postMessage',
		],
		'dependency'         => [
			'form_style' => 'type-1',
		],
	]
);

// Input box shadow hover
kalium_customize_register_control(
	'form_input_shadow_hover',
	[
		'type'               => 'kalium-box-shadow',
		'label'              => 'Hover',
		'reset'              => true,
		'enable_color_clear' => true,
		'placeholder'        => [
			'offset_x'      => 0,
			'offset_y'      => 1,
			'blur_radius'   => 2,
			'spread_radius' => 0,
		],
		'default'            => [
			'color' => kalium_color_reference( 'form_input_shadow.color' ),
		],
		'units'              => kalium_get_default_units( 'box-size' ),
		'setting'            => [
			'transport' => 'postMessage',
		],
		'dependency'         => [
			'form_style' => 'type-1',
		],
	]
);

// Input box shadow active size
kalium_customize_register_control(
	'form_input_shadow_focus',
	[
		'type'               => 'kalium-box-shadow',
		'label'              => 'Focus',
		'reset'              => true,
		'enable_color_clear' => true,
		'placeholder'        => [
			'offset_x'      => 0,
			'offset_y'      => 0,
			'blur_radius'   => 0,
			'spread_radius' => 4,
		],
		'default'            => [
			'color' => kalium_color_variant( kalium_color_reference( 'form_input_border.focus' ), [ 'alpha(0.1)' ] ),
		],
		'units'              => kalium_get_default_units( 'box-size' ),
		'setting'            => [
			'transport' => 'postMessage',
		],
		'dependency'         => [
			'form_style' => 'type-1',
		],
	]
);

// Textarea height
kalium_customize_register_control(
	'form_textarea_height',
	[
		'type'          => 'kalium-range',
		'heading_title' => 'Textarea',
		'label'         => 'Height',
		'reset'         => true,
		'responsive'    => true,
		'separator'     => true,
		'min'           => 50,
		'max'           => 400,
		'default'       => 120,
		'suffix'        => 'PX',
		'setting'       => [
			'transport' => 'postMessage',
		],
	]
);

// Checkbox color
kalium_customize_register_control(
	'form_checkbox_color',
	[
		'type'          => 'kalium-color',
		'heading_title' => 'Checkbox & Radio',
		'label'         => 'Checked',
		'separator'     => true,
		'reset'         => true,
		'default'       => kalium_color_reference( 'form_input_border.focus' ),
		'setting'       => [
			'transport' => 'postMessage',
		],
	]
);

// Checkbox border radius
kalium_customize_register_control(
	'form_checkbox_radius',
	[
		'type'        => 'kalium-multi-numeric',
		'label'       => 'Border Radius',
		'reset'       => true,
		'responsive'  => true,
		'placeholder' => [
			'top'    => 3,
			'right'  => 3,
			'bottom' => 3,
			'left'   => 3,
		],
		'min'         => 0,
		'max'         => 100,
		'units'       => kalium_get_default_units( 'box-size' ),
		'setting'     => [
			'transport' => 'postMessage',
		],
	]
);

// End of style tab
kalium_customize_end_tab();

// End of current section
kalium_customize_end_section();

/**
 * Update options in preview.
 */

// Form style
kalium_customize_register_preview_update(
	[
		'type'    => 'js',
		'vars'    => [
			'form_style',
		],
		'content' => 'var body = data.api.getElement( "body" );
		
		body.classList[ "type-2" === data.form_style ? "add" : "remove" ]( "form-style-2" );',
	]
);

// All form styles
kalium_customize_register_preview_update(
	[
		'type'    => 'css',
		'vars'    => [
			'form_input_placeholder_color',
			'form_input_color',
			'form_input_bg',
			'form_input_border',
			'form_input_border_width',
			'form_input_padding',
			'form_input_radius',
			'form_input_shadow',
			'form_input_shadow_hover',
			'form_input_shadow_focus',
			'form_textarea_height',
			'form_checkbox_color',
			'form_checkbox_radius',
		],
		'content' => <<<EOD
			{{{ data.api.printInlineStyle( { selector: ':root', varName: 'input-placeholder-color', value: data.form_input_placeholder_color } ) }}}
			
			{{{ data.api.printInlineStyle( {
				selector: ':root',
				value: data.form_input_color,
				parser: function( value ) {
					return {
						[ data.api.cssVarName( 'input-color' ) ]: data.api.parseColor( value.normal ), 
						[ data.api.cssVarName( 'input-hover-color' ) ]: data.api.parseColor( value.hover ), 
						[ data.api.cssVarName( 'input-focus-color' ) ]: data.api.parseColor( value.focus ), 
					};
				},
			} ) }}}
			
			{{{ data.api.printInlineStyle( {
				selector: ':root',
				value: data.form_input_bg,
				parser: function( value ) {
					return {
						[ data.api.cssVarName( 'input-bg' ) ]: data.api.parseColor( value.normal ), 
						[ data.api.cssVarName( 'input-hover-bg' ) ]: data.api.parseColor( value.hover ), 
						[ data.api.cssVarName( 'input-focus-bg' ) ]: data.api.parseColor( value.focus ), 
					};
				},
			} ) }}}
			
			{{{ data.api.printInlineStyle( {
				selector: ':root',
				value: data.form_input_border,
				parser: function( value ) {
					return {
						[ data.api.cssVarName( 'input-border-color' ) ]: data.api.parseColor( value.normal ), 
						[ data.api.cssVarName( 'input-border-color-rgb' ) ]: data.api.parseColorRGB( value.normal ).join( ', ' ), 
						
						[ data.api.cssVarName( 'input-hover-border-color' ) ]: data.api.parseColor( value.hover ), 
						[ data.api.cssVarName( 'input-hover-border-color-rgb' ) ]: data.api.parseColorRGB( value.hover ).join( ', ' ),
						
						[ data.api.cssVarName( 'input-focus-border-color' ) ]: data.api.parseColor( value.focus ), 
						[ data.api.cssVarName( 'input-focus-border-color-rgb' ) ]: data.api.parseColorRGB( value.focus ).join( ', ' ),
					};
				},
			} ) }}}
			
			{{{ data.api.printInlineStyle( {
				selector: ':root',
				value: data.form_checkbox_color,
				parser: function( value ) {
					return {
						[ data.api.cssVarName( 'checkbox-checked-color' ) ]: data.api.parseColor( value ), 
						[ data.api.cssVarName( 'checkbox-checked-color-rgb' ) ]: data.api.parseColorRGB( value ).join( ', ' ), 
					};
				},
			} ) }}}
			
		{{{ data.api.printInlineStyle( {
			selector: ':root',
			value: data.form_input_shadow,
			parser: function( value ) {
				var shadow = data.api.toBoxShadow( value, "0 1px 2px", true );
				
				return {
					[ data.api.cssVarName( 'input-shadow-color' ) ]: shadow.color,
					[ data.api.cssVarName( 'input-shadow-size' ) ]: shadow.size,
				};
			}
		} ) }}}
			
		:root {
            <#
			// Box shadow on hover
            var previousShadowSize = data.api.toBoxShadowSize( data.form_input_shadow, "0 1px 2px" );
            var hoverShadow = data.api.toBoxShadow( data.form_input_shadow_hover, previousShadowSize, true );
            
            if ( hoverShadow.color ) { #>
            {{ data.api.cssVarName( "input-hover-shadow-color" ) }}: {{ hoverShadow.color }};
            <# } 
            if ( hoverShadow.size ) { #>
            {{ data.api.cssVarName( "input-hover-shadow-size" ) }}: {{ hoverShadow.size }};
            <# } #>
			
            <#
			// Box shadow on focus
			var focusShadow = data.api.toBoxShadow( data.form_input_shadow_focus, "0 0 0 .25rem", true );
            #>
            {{ data.api.cssVarName( "input-focus-shadow-color" ) }}: {{ focusShadow.color }};
            {{ data.api.cssVarName( "input-focus-shadow-size" ) }}: {{ focusShadow.size }};
        }
       
        {{{ data.api.printInlineStyle( {
            selector: ':root',
            varName: 'input-border-width',
            value: data.form_input_border_width,
            addUnit: 'px',
        } ) }}}
        
        {{{ data.api.printInlineStyle( {
            selector: ':root',
            value: data.form_input_padding,
            varName: 'input-padding',
            parser: function( value ) {
                return data.api.toLength( value, '8px 12px' );
            },
        } ) }}}
        
        {{{ data.api.printInlineStyle( {
            selector: ':root',
            value: data.form_input_radius,
            varName: 'input-border-radius',
            parser: function( value ) {
                return data.api.toLength( value, data.api.cssVarReference( 'border-radius' ) );
            },
        } ) }}}
		
        
        {{{ data.api.printInlineStyle( {
            selector: ':root',
            value: data.form_checkbox_radius,
            varName: 'checkbox-border-radius',
            parser: function( value ) {
                return data.api.toLength( value, data.api.cssVarReference( 'border-radius' ) );
            },
        } ) }}}
        
        {{{ data.api.printInlineStyle( {
            selector: ':root',
            varName: 'textarea-height',
            value: data.form_textarea_height,
            addUnit: 'px',
        } ) }}}
EOD,
	]
);
