<?php
/**
 * Kalium WordPress Theme
 *
 * Layout.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

// Section link control
kalium_customize_register_control(
	'kalium_styling_layout',
	[
		'type'         => 'kalium-section-link',
		'label'        => 'Layout',
		'priority'     => kalium()->customize->get_next_priority(),
		'section_link' => kalium()->customize->section_id( 'layout' ),
	]
);

/**
 * Section: Layout.
 */

// Section
kalium_customize_register_section(
	'layout',
	[
		'title' => 'Layout',
	]
);

// Container type
kalium_customize_register_control(
	'grid_container_fullwidth',
	[
		'type'    => 'kalium-toggle',
		'label'   => 'Full Width Container',
		'setting' => [
			'transport' => 'postMessage',
		],
	]
);

// Container sizes
$container_sizes = [
	'large'  => kalium_get_predefined_container_max_width( 'large' ),
	'medium' => kalium_get_predefined_container_max_width( 'medium' ),
	'small'  => kalium_get_predefined_container_max_width( 'small' ),
];

// Predefined Container Width
kalium_customize_register_control(
	'grid_container_width',
	[
		'type'         => 'kalium-radio-button',
		'label'        => 'Container Width',
		'reset'        => true,
		'inline_label' => false,
		'choices'      => [
			'large'  => [
				'label'   => 'Large',
				'tooltip' => $container_sizes['large'],
			],
			'medium' => [
				'label'   => 'Medium',
				'tooltip' => $container_sizes['medium'],
			],
			'small'  => [
				'label'   => 'Small',
				'tooltip' => $container_sizes['small'],
			],
			'custom' => 'Custom',
		],
		'setting'      => [
			'transport' => 'postMessage',
		],
		'dependency'   => [
			'grid_container_fullwidth' => false,
		],
	]
);

// Grid Container Width
kalium_customize_register_control(
	'grid_container_width_custom',
	[
		'type'             => 'kalium-range',
		'label'            => 'Max Container Width',
		'reset'            => true,
		'min'              => 600,
		'max'              => 2600,
		'placeholder'      => 1296,
		'initial_position' => 1296,
		'suffix'           => 'PX',
		'setting'          => [
			'transport' => 'postMessage',
		],
		'dependency'       => [
			'grid_container_fullwidth' => false,
			'grid_container_width'     => 'custom',
		],
	]
);

// Block spacing
kalium_customize_register_control(
	'block_spacing',
	[
		'type'             => 'kalium-range',
		'heading_title'    => 'Block Editor',
		'label'            => 'Block Spacing',
		'separator'        => true,
		'reset'            => true,
		'step'             => 10,
		'min'              => 0,
		'max'              => 80,
		'default'          => 40,
		'marks'            => true,
		'with_input_field' => false,
		'show_tooltip'     => true,
		'tooltip_content'  => [
			[
				'value' => 0,
				'label' => 'No Spacing',
			],
			[
				'value' => 10,
				'label' => 'XX Small',
			],
			[
				'value' => 20,
				'label' => 'X Small',
			],
			[
				'value' => 30,
				'label' => 'Small',
			],
			[
				'value' => 40,
				'label' => 'Medium',
			],
			[
				'value' => 50,
				'label' => 'Large',
			],
			[
				'value' => 60,
				'label' => 'X Large',
			],
			[
				'value' => 70,
				'label' => 'XX Large',
			],
			[
				'value' => 80,
				'label' => 'Custom',
			],
		],
		'setting'          => [
			'transport' => 'postMessage',
		],
	]
);

// Custom block spacing
kalium_customize_register_control(
	'block_spacing_custom',
	[
		'type'        => 'kalium-unit',
		'label'       => 'Custom Block Spacing',
		'units'       => kalium_get_default_units(),
		'input_style' => 'max-width: 80px',
		'responsive'  => true,
		'setting'     => [
			'transport' => 'postMessage',
		],
		'dependency'  => [
			'block_spacing' => 80,
		],
	]
);

// End of current section
kalium_customize_end_section();

/**
 * Update options in preview.
 */

// Vars
$spacing_sizes = wp_json_encode(
	wp_list_pluck(
		kalium_get_spacing_sizes(),
		'size',
		'slug'
	)
);

// Transparent header and fullwidth header
kalium_customize_register_preview_update(
	[
		'type'     => 'css',
		'vars'     => [
			'grid_container_fullwidth',
			'grid_container_width',
			'grid_container_width_custom',
			'block_spacing',
			'block_spacing_custom',
		],
		'selector' => '[data-inline-style="container-width"]',
		'content'  => <<<EOD
	<#
		var maxWidth = null,
			predefinedMaxWidths = {
				large: '{$container_sizes['large']}',
				medium: '{$container_sizes['medium']}',
				small: '{$container_sizes['small']}',
			},
			spacingSizes = {$spacing_sizes},
			blockSpacing = null;
		
		if ( data.grid_container_fullwidth ) {
			maxWidth = '100%';
		} else if ( predefinedMaxWidths[ data.grid_container_width ] ) {
			maxWidth = predefinedMaxWidths[ data.grid_container_width ];
		} else if ( "custom" === data.grid_container_width && data.api.isNumber( data.grid_container_width_custom ) ) {
			maxWidth = data.grid_container_width_custom + "px";
		}
		
		if ( data.api.isNumber( data.block_spacing ) ) {
			if ( spacingSizes[ data.block_spacing ] ) {
				blockSpacing = spacingSizes[ data.block_spacing ];
			} else if ( 80 === data.block_spacing ) {
				blockSpacing = data.block_spacing_custom;
			} else {
				blockSpacing = '0px';
			}
		}
	#>
	{{{ data.api.printInlineStyle( {
		selector: ':root',
		varName: 'content-width',
		value: maxWidth,
	} ) }}}
	
	{{{ data.api.printInlineStyle( {
		selector: ':root',
		varName: 'block-spacing',
		value: blockSpacing,
	} ) }}}
	
	.container,
	.entry-content > * {
		transition: max-width 200ms ease, margin-block-start 200ms ease;
	}
EOD,
	]
);
