<?php
/**
 * Kalium WordPress Theme
 *
 * Links.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

// Section link control
kalium_customize_register_control(
	'kalium_styling_links',
	[
		'type'         => 'kalium-section-link',
		'label'        => 'Links',
		'priority'     => kalium()->customize->get_next_priority(),
		'section_link' => kalium()->customize->section_id( 'links' ),
	]
);

/**
 * Section: Links.
 */

// Section
kalium_customize_register_section(
	'links',
	[
		'title' => 'Links',
	]
);

// Link style
kalium_customize_register_control(
	'link_style',
	[
		'type'    => 'kalium-select',
		'label'   => 'Link Style',
		'choices' => [
			'standard'  => 'Standard',
			'underline' => 'Underline',
			'swap'      => 'Swap',
			'fill'      => 'Fill',
		],
		'default' => 'underline',
	]
);

// Underline / Underline Type
kalium_customize_register_control(
	'link_style_underline_type',
	[
		'type'          => 'kalium-radio-button',
		'heading_title' => 'Line Options',
		'label'         => 'Type',
		'separator'     => true,
		'reset'         => true,
		'choices'       => [
			'static'   => 'Static',
			'animated' => 'Animated',
		],
		'default'       => 'animated',
		'dependency'    => [
			'link_style' => 'underline',
		],
	]
);

// Underline Animation
kalium_customize_register_control(
	'link_style_underline_animation',
	[
		'type'       => 'kalium-select',
		'label'      => 'Animation',
		'reset'      => true,
		'choices'    => [
			'left'          => 'Left',
			'right'         => 'Right',
			'left-to-right' => 'Left to Right',
			'inside-out'    => 'Inside Out',
			'outside-in'    => 'Outside In',
		],
		'default'    => 'right',
		'setting'    => [
			'transport' => 'postMessage',
		],
		'dependency' => [
			'link_style'                => 'underline',
			'link_style_underline_type' => 'animated',
		],
	]
);

// Thickness
kalium_customize_register_control(
	'link_style_underline_thickness',
	[
		'type'             => 'kalium-range',
		'label'            => 'Thickness',
		'reset'            => true,
		'units'            => kalium_get_default_units( 'length' ),
		'placeholder'      => 1,
		'initial_position' => 1,
		'setting'          => [
			'transport' => 'postMessage',
		],
		'dependency'       => [
			'link_style' => 'underline',
		],
	]
);

// Position
kalium_customize_register_control(
	'link_style_underline_position',
	[
		'type'       => 'kalium-radio-button',
		'label'      => 'Position',
		'reset'      => true,
		'choices'    => [
			'bottom' => 'Bottom',
			'center' => 'Line-through',
		],
		'setting'    => [
			'transport' => 'postMessage',
		],
		'dependency' => [
			'link_style' => 'underline',
		],
	]
);

// Color
kalium_customize_register_control(
	'link_style_underline_color',
	[
		'type'       => 'kalium-color',
		'label'      => 'Line Color',
		'reset'      => true,
		'setting'    => [
			'transport' => 'postMessage',
		],
		'dependency' => [
			'link_style' => 'underline',
		],
	]
);

// Swap / Direction
kalium_customize_register_control(
	'link_style_swap_direction',
	[
		'type'          => 'kalium-radio-button',
		'heading_title' => 'Swap Options',
		'label'         => 'Direction',
		'help'          => 'Multiple lines links do not support Swap style and may appear distorted.',
		'separator'     => true,
		'choices'       => [
			'top'    => 'Top',
			'bottom' => 'Bottom',
		],
		'setting'       => [
			'transport' => 'postMessage',
		],
		'dependency'    => [
			'link_style' => 'swap',
		],
	]
);

// Fill / Type
kalium_customize_register_control(
	'link_style_fill_type',
	[
		'type'          => 'kalium-radio-button',
		'heading_title' => 'Fill Options',
		'label'         => 'Type',
		'separator'     => true,
		'choices'       => [
			'background' => 'Background',
			'text'       => 'Text',
		],
		'dependency'    => [
			'link_style' => 'fill',
		],
	]
);

// Text Fill Direction
kalium_customize_register_control(
	'link_style_fill_text_direction',
	[
		'type'       => 'kalium-radio-button',
		'label'      => 'Direction',
		'choices'    => [
			'forwards'  => 'Forwards',
			'backwards' => 'Backwards',
		],
		'setting'    => [
			'transport' => 'postMessage',
		],
		'dependency' => [
			'link_style'           => 'fill',
			'link_style_fill_type' => 'text',
		],
	]
);

// Background Fill Direction
kalium_customize_register_control(
	'link_style_fill_bg_direction',
	[
		'type'         => 'kalium-radio-button',
		'label'        => 'Direction',
		'inline_label' => false,
		'choices'      => [
			'top'    => 'Top',
			'right'  => 'Right',
			'bottom' => 'Bottom',
			'left'   => 'Left',
		],
		'setting'      => [
			'transport' => 'postMessage',
		],
		'dependency'   => [
			'link_style'           => 'fill',
			'link_style_fill_type' => 'background',
		],
	]
);

// Show underline
kalium_customize_register_control(
	'link_style_fill_bg_underline',
	[
		'type'       => 'kalium-toggle',
		'label'      => 'Show Underline',
		'setting'    => [
			'transport' => 'postMessage',
		],
		'dependency' => [
			'link_style'                   => 'fill',
			'link_style_fill_type'         => 'background',
			'link_style_fill_bg_direction' => 'top',
		],
	]
);

// Background Fill Underline
kalium_customize_register_control(
	'link_style_fill_bg_underline_thickness',
	[
		'type'             => 'kalium-range',
		'label'            => 'Thickness',
		'reset'            => true,
		'units'            => kalium_get_default_units( 'length' ),
		'placeholder'      => 1,
		'initial_position' => 1,
		'setting'          => [
			'transport' => 'postMessage',
		],
		'dependency'       => [
			'link_style'                   => 'fill',
			'link_style_fill_type'         => 'background',
			'link_style_fill_bg_direction' => 'top',
			'link_style_fill_bg_underline' => true,
		],
	]
);

// Reverse state
kalium_customize_register_control(
	'link_style_reverse_state',
	[
		'type'           => 'kalium-toggle',
		'label'          => 'Reverse State',
		'separator'      => true,
		'separator_type' => 3,
		'setting'        => [
			'transport' => 'postMessage',
		],
		'dependency'     => [
			'link_style' => [ 'underline', 'fill' ],
		],
	]
);

// End of current section
kalium_customize_end_section();

/**
 * Update options in preview.
 */

// Emulate link style options in live preview
kalium_customize_register_preview_update(
	[
		'type'     => 'css',
		'vars'     => [
			'link_style_underline_animation',
			'link_style_underline_thickness',
			'link_style_underline_position',
			'link_style_underline_color',
			'link_style_swap_direction',
			'link_style_fill_type',
			'link_style_fill_bg_direction',
			'link_style_fill_bg_underline',
			'link_style_fill_bg_underline_thickness',
			'link_style_fill_text_direction',
		],
		'selector' => '[data-inline-style="link-style-options"]',
		'content'  => '
		<# 
		var linkStyle = data.api.getSetting( "link_style" );
		var lsPrefix = function( varName ) {
			return data.api.cssVarName( "ls-" + varName, false );  
		};
		#>
		
		:root {
			<#
			// Underline 
			if ( "underline" === linkStyle ) {
				var isStatic = "static" === data.api.getSetting( "link_style_underline_type" );
				
				// Animation
				switch ( data.link_style_underline_animation ) {
					
					// Left
					case "left":
						#>
						{{ lsPrefix( "line-direction-value" ) }}: 100%;
						{{ lsPrefix( "line-direction-hover-value" ) }}: 100%;
						<#
						break;
						
					// Left to right
					case "left-to-right":
						#>
						{{ lsPrefix( "line-direction-hover-value" ) }}: 100%;
						{{ lsPrefix( "transition-value" ) }}: {{ data.api.cssVarReference( lsPrefix( "transition-left-to-right" ), false ) }};
						<#
						break;
						
					// Inside out
					case "inside-out":
						#>
						{{ lsPrefix( "line-direction-value" ) }}: 50%;
						<#
						break;
						
					// Inside out
					case "outside-in":
						#>
						{{ lsPrefix( "is-outside-in" ) }}: {{ data.api.cssVarReference( "on" ) }};
						{{ lsPrefix( "line-width-hover-value" ) }}: 50%;
						<#
						break;
				}
				
				// Thickness
				if ( data.link_style_underline_thickness ) {
					#>
					{{ lsPrefix( "line-thickness-value" ) }}: {{ data.link_style_underline_thickness }};
					<#
				}
				
				// Position
				if ( "center" === data.link_style_underline_position ) {
					if ( isStatic ) {
						#>
						{{ lsPrefix( "line-hover-value" ) }}: line-through;
						<#
					} else {
						#>
						{{ lsPrefix( "line-position-value" ) }}: 55%;
						<#
					}
				}
				
				// Color
				if ( data.link_style_underline_color ) {
					var parsedColor = data.api.parseColor( data.link_style_underline_color );
					
					#>
					{{ lsPrefix( "color-value" ) }}: {{ parsedColor }};
					{{ lsPrefix( "color-hover-value" ) }}: {{ parsedColor }};
					<#
				}
			}
			// Swap
			else if ( "swap" === linkStyle ) {
				var swapDirection = data.link_style_swap_direction;
				
				if ( "bottom" === swapDirection ) {
					#>
						{{ lsPrefix( "swap-direction-1-hover-value" ) }}: 1;
						{{ lsPrefix( "swap-direction-2-value" ) }}: -1;
					<#
				}
			}
			// Fill
			else if ( "fill" === linkStyle ) {
				
				// Fill Background
				if ( "background" === data.link_style_fill_type ) {
					switch ( data.link_style_fill_bg_direction ) {
						
						// Left
						case "left":
							#>
							{{ lsPrefix( "fill-bg-height-value" ) }}: 100%; 
							{{ lsPrefix( "fill-bg-width-value" ) }}: 0%; 
							{{ lsPrefix( "fill-bg-pos-x-value" ) }}: 100%; 
							<#
							break;
						
						// Right
						case "right":
							#>
							{{ lsPrefix( "fill-bg-height-value" ) }}: 100%; 
							{{ lsPrefix( "fill-bg-width-value" ) }}: 0%; 
							<#
							break;
						
						// Bottom
						case "bottom":
							#>
							{{ lsPrefix( "fill-bg-pos-y-value" ) }}: 0%;  
							<#
							break;
							
						// Top
						default:
							if ( data.link_style_fill_bg_underline ) {
								var underlineThickness = data.link_style_fill_bg_underline_thickness || ".1em";
								
								#>
								{{ lsPrefix( "fill-bg-height-value" ) }}: {{ underlineThickness }};  
								<#
							}
					}
				}
				// Fill text 
				else {
				
					// Direction backwards
					if ( "backwards" === data.link_style_fill_text_direction ) {
						#>
						{{ lsPrefix( "is-backwards" ) }}: {{ data.api.cssVarReference( "on" ) }};
						{{ lsPrefix( "fill-direction-value" ) }}: 0%;
						{{ lsPrefix( "fill-direction-hover-value" ) }}: 100%;
						<#
					}
				}
			}
			#>
		}
		',
	]
);

// Reverse state
kalium_customize_register_preview_update(
	[
		'type'    => 'js',
		'vars'    => [
			'link_style_reverse_state',
		],
		'content' => '
			var toggled = !! data.link_style_reverse_state;
			
			document.body.classList[ toggled ? "add" : "remove" ]( "link-style-reverse" );
		',
	]
);
