<?php
/**
 * Kalium WordPress Theme
 *
 * Free shipping bar.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

// Free shipping bar
kalium_customize_register_control(
	'shop_free_shipping_bar',
	[
		'type'         => 'kalium-toggle',
		'label'        => 'Free Shipping Bar',
		'setting'      => [
			'transport' => 'postMessage',
		],
		'help'         => 'Free shipping progress bar is shown only if there is free shipping method available with minimum order amount set.',
		'section_link' => kalium()->customize->section_id( 'free_shipping_bar' ),
	]
);

/**
 * Subsection: Free Shipping Progress Bar.
 */

// Subsection
kalium_customize_register_section(
	'free_shipping_bar',
	[
		'title' => 'Free Shipping Bar',
	]
);

// General tab
kalium_customize_general_tab();

// Locations to show free shipping bar
kalium_customize_register_control(
	'shop_free_shipping_bar_locations',
	[
		'type'         => 'kalium-checkbox',
		'label'        => 'Locations to Show',
		'inline_label' => false,
		'choices'      => [
			'mini-cart'      => 'Mini Cart Drawer',
			'cart'           => 'Cart Page',
			'checkout'       => 'Checkout Page',
			'single-product' => 'Product Page',
		],
		'default'      => [
			'mini-cart',
			'cart',
		],
	]
);

// Initial message
kalium_customize_register_control(
	'shop_free_shipping_bar_initial_message',
	[
		'type'    => 'kalium-textarea',
		'label'   => 'Initial Message',
		'reset'   => true,
		'rows'    => 5,
		'default' => sprintf( esc_html__( '%s away from free shipping!', 'kalium' ), '[amount_left]' ),
	]
);

// Qualified message
kalium_customize_register_control(
	'shop_free_shipping_bar_qualified_message',
	[
		'type'        => 'kalium-textarea',
		'label'       => 'Qualified for Free Shipping Message',
		'reset'       => true,
		'rows'        => 5,
		'description' => '<p>Available Shortcodes:</p>
<code style="font-size: 10px; display: inline-block; margin-bottom: 10px">[amount_left]</code> - Shows the amount left<br>
<code style="font-size: 10px; display: inline-block; margin-bottom: 10px">[min_amount]</code> - Shows the minimum amount
</p>',
		'default'     => esc_html__( 'Free shipping will be applied at checkout!', 'kalium' ),
	]
);

// End of general tab
kalium_customize_end_tab();

// Style tab
kalium_customize_style_tab();

// Progress Bar
kalium_customize_register_control(
	'shop_free_shipping_bar_colors',
	[
		'type'    => 'kalium-color',
		'label'   => 'Progress Bar',
		'reset'   => true,
		'choices' => [
			'bg'       => 'Background',
			'progress' => 'Progress',
			'stripes'  => 'Stripes',
		],
		'default' => [
			'bg'       => kalium_color_reference( 'theme_colors_border' ),
			'progress' => kalium_color_reference( 'theme_colors_link.normal' ),
			'stripes'  => kalium_color_reference( 'theme_colors_body', 0.2 ),
		],
		'tooltip' => true,
		'setting' => [
			'transport' => 'postMessage',
		],
	]
);

// End of style tab
kalium_customize_end_tab();

// End of current section
kalium_customize_end_section();

/**
 * Update preview.
 */

// Progress bar style
kalium_customize_register_preview_update(
	[
		'type'    => 'css',
		'vars'    => [
			'shop_free_shipping_bar_colors',
		],
		'content' => <<<EOD
.free-shipping-bar {
	{{{ data.api.printInlineStyle( { varName: 'progress-bg', value: data.shop_free_shipping_bar_colors.bg } ) }}};
	{{{ data.api.printInlineStyle( { varName: 'progress-color', value: data.shop_free_shipping_bar_colors.progress } ) }}};
	{{{ data.api.printInlineStyle( { varName: 'progress-stripes-color', value: data.shop_free_shipping_bar_colors.stripes } ) }}};
}
EOD,
	]
);
