<?php
/**
 * Kalium WordPress Theme
 *
 * Alert Box widget.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

vc_map(
	[
		'base'        => 'lab_message',
		'name'        => 'Alert Box',
		'description' => 'Theme styled alerts',
		'category'    => 'Laborator',
		'icon'        => kalium()->file_url( 'includes/wpbakery/assets/images/info.svg' ),
		'params'      => [
			[
				'type'        => 'dropdown',
				'heading'     => 'Message Type',
				'param_name'  => 'type',
				'std'         => 'default',
				'admin_label' => true,
				'value'       => [
					'Default' => 'default',
					'Info'    => 'info',
					'Success' => 'success',
					'Warning' => 'warning',
					'Error'   => 'error',
				],
				'description' => 'Select the type of the alert message.',
			],
			[
				'type'        => 'textarea_safe',
				'heading'     => 'Message',
				'param_name'  => 'message',
				'description' => 'Enter your message to display in the dialogue, you can include HTML tags too.',
			],
			[
				'type'       => 'checkbox',
				'heading'    => 'Close Button',
				'param_name' => 'close_button',
				'value'      => [
					'Allow user to dismiss the alert (X - icon)' => 'yes',
				],
			],
			[
				'type'        => 'textfield',
				'heading'     => 'Extra class name',
				'param_name'  => 'el_class',
				'description' => 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.',
			],
			[
				'type'       => 'css_editor',
				'heading'    => 'Css',
				'param_name' => 'css',
				'group'      => 'Design options',
			],
		],
	]
);

class WPBakeryShortCode_Lab_Message extends WPBakeryShortCode {}
