<?php
/**
 * Kalium WordPress Theme
 *
 * Portfolio Like + Share widget.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

if ( is_admin() && ( $post_id = kalium()->request->query( 'post' ) ) ) {
	$wp_post = get_post( $post_id );

	if ( $wp_post && ! in_array( $wp_post->post_type, kalium()->portfolio->get_post_types(), true ) ) {
		return;
	}
}

vc_map(
	[
		'base'        => 'lab_portfolio_share_like',
		'name'        => 'Like + Share',
		'description' => 'Portfolio item social sharing links',
		'category'    => [ 'Laborator', 'Portfolio' ],
		'icon'        => kalium()->file_url( 'includes/wpbakery/assets/images/like-social-sharing.svg' ),
		'params'      => [
			[
				'type'        => 'dropdown',
				'heading'     => 'Layout',
				'param_name'  => 'layout',
				'std'         => 'default',
				'value'       => [
					'Plain text'    => 'default',
					'Rounded icons' => 'rounded',
				],
				'admin_label' => true,
				'description' => 'Select layout of social sharing links.',
			],
			[
				'type'        => 'dropdown',
				'heading'     => 'Alignment',
				'param_name'  => 'alignment',
				'std'         => 'center',
				'value'       => [
					'Left'   => 'left',
					'Center' => 'center',
					'Right'  => 'right',
				],
				'admin_label' => true,
				'description' => 'Set alignment of social media links inside the column.',
			],
			[
				'type'        => 'textfield',
				'heading'     => 'Extra class name',
				'param_name'  => 'el_class',
				'description' => 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.',
			],
			[
				'type'       => 'css_editor',
				'heading'    => 'Css',
				'param_name' => 'css',
				'group'      => 'Design options',
			],
		],
	]
);

class WPBakeryShortCode_Lab_Portfolio_Share_Like extends WPBakeryShortCode {}
