<?php
/**
 * Kalium WordPress Theme
 *
 * Team Members widget.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

$icon = kalium()->file_url( 'includes/wpbakery/assets/images/members.svg' );

// Team Members
vc_map(
	[
		'base'                    => 'lab_team_members',
		'name'                    => 'Team Members',
		'description'             => 'List your members',
		'category'                => 'Laborator',
		'content_element'         => true,
		'show_settings_on_create' => true,
		'icon'                    => $icon,
		'as_parent'               => [ 'only' => 'lab_team_members_member,lab_team_members_placeholder' ],
		'params'                  => [
			[
				'type'        => 'dropdown',
				'heading'     => 'Layout Type',
				'param_name'  => 'layout_type',
				'std'         => 'inside',
				'value'       => [
					'Titles Inside'  => 'titles-inside',
					'Visible Titles' => 'visible-titles',
				],
				'description' => 'Select layout type to show team members.',
			],
			[
				'type'        => 'dropdown',
				'heading'     => 'Members per Row',
				'param_name'  => 'columns_count',
				'std'         => '3',
				'value'       => [
					'1 Member per Row'  => '1',
					'2 Members per Row' => '2',
					'3 Members per Row' => '3',
					'4 Members per Row' => '4',
				],
				'description' => 'Set number of columns for team members.',
			],
			\Kalium\Compatibility\WPBakery::$laborator_vc_general_params['reveal_effect'],
			[
				'type'        => 'dropdown',
				'heading'     => 'Hover Style',
				'param_name'  => 'hover_style',
				'std'         => 'full',
				'value'       => [
					'None'                       => 'none',
					'Full background hover'      => 'full',
					'Distanced background hover' => 'distanced',
				],
				'description' => 'Select hover effect style to apply for team members entries.',
			],
			[
				'type'        => 'colorpicker',
				'heading'     => 'Custom Hover Color',
				'param_name'  => 'hover_bg',
				'description' => 'You can set custom hover color.',
				'dependency'  => [
					'element' => 'hover_style',
					'value'   => [ 'full', 'distanced' ],
				],
			],
			[
				'type'        => 'colorpicker',
				'heading'     => 'Custom Hover Text Color',
				'param_name'  => 'hover_txt',
				'description' => 'You can set custom hover text color.',
				'dependency'  => [
					'element' => 'hover_style',
					'value'   => [ 'full', 'distanced' ],
				],
			],
			[
				'type'        => 'textfield',
				'heading'     => 'Image size',
				'param_name'  => 'img_size',
				'description' => 'Enter image size. Example: Enter image size in pixels: 200x100 (Width x Height). Leave empty to use "460x460" size.',
			],
			[
				'type'        => 'textfield',
				'heading'     => 'Extra class name',
				'param_name'  => 'el_class',
				'description' => 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.',
			],
			[
				'type'       => 'css_editor',
				'heading'    => 'Css',
				'param_name' => 'css',
				'group'      => 'Design options',
			],
		],
		'js_view'                 => 'VcColumnView',
		'default_content'         => '[lab_team_members_member name="Team member 1" sub_title="Founder"][lab_team_members_member name="Team member 2" sub_title="Manager"][lab_team_members_placeholder]',
	]
);

// Team Member (child of Team Members)
vc_map(
	[
		'base'            => 'lab_team_members_member',
		'name'            => 'Team Member',
		'description'     => 'Member details',
		'category'        => 'Laborator',
		'content_element' => true,
		'icon'            => $icon,
		'as_child'        => [ 'only' => 'lab_team_members' ],
		'params'          => [
			[
				'type'        => 'attach_image',
				'heading'     => 'Image',
				'param_name'  => 'image',
				'value'       => '',
				'description' => 'Add team member image here.',
			],
			[
				'type'        => 'textfield',
				'heading'     => 'Name',
				'param_name'  => 'name',
				'admin_label' => true,
				'description' => 'Name of the member.',
			],
			[
				'type'        => 'textfield',
				'heading'     => 'Sub Title',
				'param_name'  => 'sub_title',
				'description' => 'Position or title of the member.',
			],
			[
				'type'        => 'textarea_safe',
				'heading'     => 'Description',
				'param_name'  => 'description',
				'description' => 'Include a small description for this member, this text area supports HTML too.',
			],
			[
				'type'        => 'vc_link',
				'heading'     => 'Link',
				'param_name'  => 'link',
				'description' => 'Make the name and thumbnail clickable (Optional).',
			],
			[
				'type'        => 'textfield',
				'heading'     => 'Extra class name',
				'param_name'  => 'el_class',
				'description' => 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.',
			],
		],
	]
);

// Placeholder (child of Team Members)
vc_map(
	[
		'base'            => 'lab_team_members_placeholder',
		'name'            => 'Placeholder',
		'description'     => 'Anonymous member',
		'category'        => 'Laborator',
		'content_element' => true,
		'icon'            => $icon,
		'as_child'        => [ 'only' => 'lab_team_members' ],
		'params'          => [
			[
				'type'        => 'textfield',
				'heading'     => 'Image Title',
				'param_name'  => 'image_title',
				'value'       => 'your-image.jpg',
				'description' => 'Add some text that will be paced after the image (Optional).',
			],
			[
				'type'        => 'textfield',
				'heading'     => 'Title',
				'param_name'  => 'title',
				'admin_label' => true,
				'value'       => 'You Here',
				'description' => 'Insert a sample title.',
			],
			[
				'type'        => 'textfield',
				'heading'     => 'Sub Title',
				'param_name'  => 'sub_title',
				'value'       => 'Join us now!',
				'description' => 'Insert a sample sub title (Optional).',
			],
			[
				'type'        => 'vc_link',
				'heading'     => 'Sub Title Link',
				'param_name'  => 'link',
				'description' => 'Make the name and thumbnail clickable (Optional).',
				'dependency'  => [
					'element'   => 'sub_title',
					'not_empty' => true,
				],
			],
			[
				'type'        => 'textfield',
				'heading'     => 'Extra class name',
				'param_name'  => 'el_class',
				'description' => 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.',
			],
		],
	]
);

class WPBakeryShortCode_Lab_Team_Members extends WPBakeryShortCodesContainer {}
class WPBakeryShortCode_Lab_Team_Members_Member extends WPBakeryShortCode {}
class WPBakeryShortCode_Lab_Team_Members_Placeholder extends WPBakeryShortCode {}
