<?php
/**
 * Kalium WordPress Theme
 *
 * Social Networks widget.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

vc_map(
	[
		'base'        => 'lab_vc_social_networks',
		'name'        => 'Social Networks',
		'description' => 'Social network links',
		'category'    => 'Laborator',
		'icon'        => kalium()->file_url( 'includes/wpbakery/assets/images/social-networks.svg' ),
		'params'      => [
			[
				'type'        => 'dropdown',
				'heading'     => 'Display Type',
				'param_name'  => 'display_type',
				'std'         => 'no',
				'value'       => [
					'Rounded icons' => 'rounded-icons',
					'Text only'     => 'text-only',
					'Icon + text'   => 'icon-text',
				],
				'description' => 'Select style of social network links.',
				'admin_label' => true,
			],
			[
				'type'        => 'dropdown',
				'heading'     => 'Colored',
				'param_name'  => 'colored',
				'std'         => 'no',
				'value'       => [
					'Colored text'                => 'text',
					'Colored text on hover'       => 'text-hover',
					'Colored background'          => 'bg',
					'Colored background on hover' => 'bg-hover',
					'None'                        => 'none',
				],
				'description' => 'Use colored social networks.',
				'admin_label' => true,
			],
			[
				'type'        => 'textfield',
				'heading'     => 'Extra class name',
				'param_name'  => 'el_class',
				'description' => 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.',
			],
			[
				'type'       => 'css_editor',
				'heading'    => 'Css',
				'param_name' => 'css',
				'group'      => 'Design options',
			],
		],
	]
);

class WPBakeryShortCode_Lab_VC_Social_Networks extends WPBakeryShortCode {

	/**
	 * Shortcode content.
	 *
	 * @param array  $atts
	 * @param string $content
	 *
	 * @return string
	 */
	public function content( $atts, $content = '' ) {
		// Atts
		$defaults = [
			'display_type' => '',
			'el_class'     => '',
			'colored'      => '',
			'css'          => '',
		];

		$atts = vc_shortcode_attribute_parse( $defaults, $atts );

		extract( $atts );

		// Element Class
		$class = $this->getExtraClass( $el_class );

		$css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $class, $this->settings['base'], $atts );
		$css_class = "lab-vc-social-networks {$css_class} display-type-{$display_type}";

		$colored_attr = '';

		switch ( $colored ) {
			case 'text':
				$colored_attr = 'colored';
				break;

			case 'text-hover':
				$colored_attr = 'colored="hover"';
				break;

			case 'bg':
				$colored_attr = 'colored-bg';
				break;

			case 'bg-hover':
				$colored_attr = 'colored-bg="hover"';
				break;
		}

		ob_start();

		$shortcode_attrs = '';

		if ( 'rounded-icons' === $display_type ) {
			$shortcode_attrs .= ' rounded';
		}

		if ( ! empty( $colored_attr ) ) {
			$shortcode_attrs .= ' ' . $colored_attr;
		}

		?>
		<div class="<?php echo esc_attr( $css_class ) . vc_shortcode_custom_css_class( $css, ' ' ); ?>">
		<?php echo do_shortcode( sprintf( '[lab_social_networks%s]', $shortcode_attrs ) ); ?>
		</div>
		<?php

		return ob_get_clean();
	}
}
