<?php
/**
 * Kalium WordPress Theme
 *
 * Posts loop.
 *
 * @var string $id
 * @var array $classes
 *
 * @author  Laborator
 * @link    https://kaliumtheme.com
 * @version 4.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

?>
<ul id="<?php echo esc_attr( $id ); ?>" <?php kalium_class_attr( $classes ); ?>>
	
	<?php
	/**
	 * Blog posts loop
	 */
	if ( have_posts() ) :

		/**
		 * Before blog loop
		 */
		do_action( 'kalium_blog_loop_before' );

		while ( have_posts() ) :
			the_post();

			kalium_blog_loop_post_template();

			endwhile;

		/**
		 * After blog loop
		 */
		do_action( 'kalium_blog_loop_after' );

		/**
		 * No posts found
		 */
		else :

			/**
			 * No posts to show
			 *
			 * @hooked kalium_blog_no_posts_found_message - 10
			 */
			do_action( 'kalium_blog_no_posts_found' );

		endif;
		?>
	
</ul>
