<?php
/**
 * Kalium WordPress Theme
 *
 * Single post template.
 *
 * @var array $classes
 * @var bool $collapse_mobile
 * @var bool $columns
 *
 * @author  Laborator
 * @link    https://kaliumtheme.com
 * @version 4.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

/**
 * Before post.
 */
do_action( 'kalium_blog_single_post_before' );

?>
<article id="post-<?php the_ID(); ?>" <?php post_class( [ 'post', kalium_conditional( kalium_is_narrow_blog_layout(), 'container-narrow' ) ] ); ?>>

	<?php
	/**
	 * Post start.
	 *
	 * @hooked kalium_blog_single_post_featured_image - 10
	 */
	do_action( 'kalium_blog_single_post_start' );
	?>

	<header class="entry-header container-child">
		<?php
			/**
			 * Entry header.
			 *
			 * @hooked kalium_blog_post_title - 10
			 * @hooked kalium_blog_post_meta - 20
			 */
			do_action( 'kalium_blog_single_post_header' );
		?>
	</header>

	<?php
		/**
		 * Single post details
		 *
		 * @hooked kalium_blog_post_content - 10
		 */
		do_action( 'kalium_blog_single_post_content' );
	?>

	<footer class="entry-footer container-child">
		<?php
			/**
			 * Entry footer.
			 *
			 * @hooked kalium_blog_single_post_tags_list - 10
			 * @hooked kalium_blog_single_post_share_networks - 20
			 */
			do_action( 'kalium_blog_single_post_footer' );
		?>
	</footer>

	<?php
		/**
		 * Post end.
		 */
		do_action( 'kalium_blog_single_post_end' );
	?>
	
</article>
<?php
/**
 * After post.
 */
do_action( 'kalium_blog_single_post_after' );
