<?php
/**
 * Kalium WordPress Theme
 *
 * Load more pagination button.
 *
 * @var array $classes
 * @var string $view_more_text
 * @var string $last_page_text
 * @var string $loading_style
 * @var string $loading_spinner
 * @var array $options
 *
 * @author  Laborator
 * @link    https://kaliumtheme.com
 * @version 4.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

?>
<div <?php kalium_class_attr( $classes ); ?> data-options="<?php echo esc_attr( wp_json_encode( $options ) ); ?>">
	<div class="load-more__content">
		<div class="load-more__status">
			<div class="infinite-scroll-request"><i class="<?php echo esc_attr( $loading_spinner ); ?>"></i></div>
			<div class="infinite-scroll-last"><?php echo $last_page_text; ?></div>
		</div>
		<button type="button" class="load-more__view-more"><?php echo $view_more_text; ?></button>
	</div>
</div>
