<?php
/**
 * Kalium WordPress Theme
 *
 * Page heading title and description
 *
 * @var array $classes
 * @var array $container_classes
 * @var string $heading_tag
 * @var string $title
 * @var string $description
 *
 * @author  Laborator
 * @link    https://kaliumtheme.com
 * @version 4.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

?>
<section <?php kalium_class_attr( $classes ); ?> role="heading">

	<div <?php kalium_class_attr( $container_classes ); ?>>

		<div class="row">

			<?php
			/**
			 * Before page heading hooks.
			 */
			do_action( 'kalium_page_heading_before' );
			?>

			<div class="page-heading__title-container col section-title">

				<?php
				if ( $title ) {
					kalium_element(
						[
							'tag_name'   => $heading_tag,
							'attributes' => [
								'class' => [
									'page-heading__title',
									kalium_get_link_block_class(),
								],
							],
							'content'    => $title,
							'echo'       => true,
						]
					);
				}

				if ( $description ) {
					kalium_element(
						[
							'tag_name'   => 'div',
							'attributes' => [
								'class' => [
									'page-heading__description',
								],
							],
							'content'    => $description,
							'echo'       => true,
						]
					);
				}
				?>

			</div>

			<?php
			/**
			 * After page heading hooks.
			 */
			do_action( 'kalium_page_heading_after' );
			?>

		</div>

	</div>

</section>
