<?php
/**
 * Kalium WordPress Theme
 *
 * Social Icon element.
 *
 * @var \Laborator_Builder\Elements\Social_Icon $element
 * @var string $label
 * @var string $link
 * @var string $color
 *
 * @author  Laborator
 * @link    https://kaliumtheme.com
 * @version 4.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

// Icon
if ( $element->get_option( 'has_icon', true ) ) {
	printf( '<span class="social-icon__col social-icon__icon">%s</span>', $element->get_social_icon() );
}

// Label
if ( $element->get_option( 'has_label', true ) ) {
	$label = $label ?: $element->get_attribute( 'label' )->get_option( 'placeholder' );
	printf( '<span class="social-icon__col social-icon__label"><span class="link">%s</span></span>', esc_html( $label ) );
}
