<?php
/**
 * Kalium WordPress Theme
 *
 * Product Description element.
 *
 * @var int $max_words
 * @var string $max_words_more
 * @var int $max_lines
 * @var string $show_more_type
 *
 * @author  Laborator
 * @link    https://kaliumtheme.com
 * @version 4.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}
global $product;

// Excerpt
$excerpt = strip_tags( $product->get_short_description() );

// More text
if ( empty( $max_words_more ) ) {
	$max_words_more = null;
}

// Truncate number of words
if ( is_numeric( $max_words ) && $max_words > 0 ) {
	$excerpt = wp_trim_words( $excerpt, $max_words, $max_words_more );
}

// Classes
$classes = [
	'expanding-text',
	'expanding-text--style-' . $show_more_type,
];

?>
<div <?php kalium_class_attr( $classes ); ?>>
	<div class="expanding-text__content"><?php echo esc_html( $excerpt ); ?></div>
</div>
