<?php
/**
 * Kalium WordPress Theme
 *
 * Maintenance mode.
 *
 * @var string $page_title
 * @var string $page_description
 * @var string $site_logo
 * @var bool $countdown
 * @var string $countdown_date
 * @var bool $social_networks
 * @var array $aov_args
 *
 * @author  Laborator
 * @link    https://kaliumtheme.com
 * @version 4.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

?>
<div class="maintenance-mode__content">
	<?php

	// Logo
	if ( $site_logo ) {
		?>
		<div class="site-logo" <?php kalium_animate_on_viewport( $aov_args, false ); ?>>
			<?php echo $site_logo; ?>
		</div>
		<?php
	}

	// Description
	?>
	<div class="description" <?php kalium_animate_on_viewport( $aov_args, false ); ?>>
		<?php
		// Title
		if ( $page_title ) {
			printf( '<h1>%s</h1>', esc_html( $page_title ) );
		}

		// Description
		if ( $page_description ) {
			echo kalium_format_content( $page_description );
		}
		?>
	</div>
	<?php

	// Countdown
	if ( $countdown ) {
		?>
		<div class="countdown" data-date="<?php echo esc_attr( $countdown_date ); ?>">
			<li <?php kalium_animate_on_viewport( $aov_args, false ); ?>>
				<span class="days"></span>
				<span class="timeRefDays" data-text="<?php esc_attr_e( 'Days', 'kalium' ); ?>" data-text-singular="<?php esc_attr_e( 'Day', 'kalium' ); ?>"></span>
			</li>
			<li <?php kalium_animate_on_viewport( $aov_args, false ); ?>>
				<span class="hours"></span>
				<span class="timeRefHours" data-text="<?php esc_attr_e( 'Hours', 'kalium' ); ?>" data-text-singular="<?php esc_attr_e( 'Hour', 'kalium' ); ?>"></span>
			</li>
			<li <?php kalium_animate_on_viewport( $aov_args, false ); ?>>
				<span class="minutes"></span>
				<span class="timeRefMinutes" data-text="<?php esc_attr_e( 'Minutes', 'kalium' ); ?>" data-text-singular="<?php esc_attr_e( 'Minute', 'kalium' ); ?>"></span>
			</li>
			<li <?php kalium_animate_on_viewport( $aov_args, false ); ?>>
				<span class="seconds"></span>
				<span class="timeRefSeconds" data-text="<?php esc_attr_e( 'Seconds', 'kalium' ); ?>" data-text-singular="<?php esc_attr_e( 'Second', 'kalium' ); ?>"></span>
			</li>
		</div>
		<?php
	}

	// Social networks
	if ( $social_networks ) {
		?>
		<div class="social-networks" <?php kalium_animate_on_viewport( $aov_args, false ); ?>>
			<?php echo do_shortcode( '[kalium_social_icons radius="rounded"]' ); ?>
		</div>
		<?php
	}
	?>
</div>
