<?php
/**
 * Kalium WordPress Theme
 *
 * Breadcrumb widget.
 *
 * @var array $atts
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

// Attributes
if ( function_exists( 'vc_map_get_attributes' ) ) {
	$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
}

// Extract attributes
extract( $atts );

// Element class
$class     = $this->getExtraClass( $el_class );
$css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $class, $this->settings['base'], $atts );

$classes = [
	'lab-breadcrumb',
	$css_class,
	vc_shortcode_custom_css_class( $css ),
];

?>
<div <?php kalium_class_attr( $classes ); ?>>
	<?php
	/**
	 * Breadcrumb.
	 */
	kalium_breadcrumb(
		[
			'container' => false,
		]
	);
	?>
</div>
