<?php
/**
 * Kalium WordPress Theme
 *
 * Divider widget.
 *
 * @var array $atts
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

// Attributes
if ( function_exists( 'vc_map_get_attributes' ) ) {
	$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
}

// Extract attributes
extract( $atts );

// Instance ID
$instance_id = 'divider-' . kalium_generate_unique_string();

// Element class
$class     = $this->getExtraClass( $el_class );
$css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $class, $this->settings['base'], $atts );

$classes = [
	'lab-divider',
	$css_class,
	vc_shortcode_custom_css_class( $css )
];

if ( 'text' === $type ) {
	$classes[] = 'divider-type-' . $text_style;
} else {
	$classes[] = 'divider-plain';
	$classes[] = 'type-' . $plain_style;
}

if ( 'text' === $type ) {

	if ( $text_color ) {

		if ( $text_style == 4 && empty( $text_color_font ) ) {
			$text_color_font = '#ffffff';
		}

		$text_color_font = empty( $text_color_font ) ? $text_color : $text_color_font;

		kalium_append_custom_css( "#{$instance_id} .lab-divider-content span", "color: {$text_color_font};" );

		switch ( $text_style ) {

			case '1':
				kalium_append_custom_css( "#{$instance_id} div span", "border-color: {$text_color};" );
				break;

			case '2':
			case '3':
				kalium_append_custom_css( "#{$instance_id} .divider-line span ", "border-top-color: {$text_color};" );
				break;

			case '4':
				kalium_append_custom_css( "#{$instance_id} div span", "border-color: {$text_color};" );
				kalium_append_custom_css( "#{$instance_id} .lab-divider-content span", "background-color: {$text_color};" );
				break;

			case '5':
				kalium_append_custom_css( "#{$instance_id} .divider-line span", "background-color: {$text_color};" );
				break;

		}
	}

	?>
	<div id="<?php echo esc_html( $instance_id ); ?>" <?php kalium_class_attr( $classes ); ?>>
		<div class="divider-line divider-left">
			<span></span>
			<span class="double-line"></span>
		</div>

		<div class="lab-divider-content">
			<span><?php echo do_shortcode( $title ); ?></span>
		</div>

		<div class="divider-line divider-right">
			<span></span>
			<span class="double-line"></span>
		</div>
	</div>
	<?php
} else {
	$width = floatval( $plain_width );

	$plain_style_attr = '';

	if ( $width && is_numeric( $width ) && $width > 0 && $width <= 100 ) {
		$plain_style_attr .= 'display: block; width: ' . $width . ( strstr( $plain_width, 'px' ) ? 'px' : '%' ) . ';';
	}

	if ( $plain_color ) {
		$plain_style_attr .= ' border-bottom-color: ' . $plain_color;
	}

	kalium_append_custom_css( "#{$instance_id} .lab-divider-content", $plain_style_attr );

	?>
	<div id="<?php echo esc_attr( $instance_id ); ?>" <?php kalium_class_attr( $classes ); ?>>
		<div class="lab-divider-content"></div>
	</div>
	<?php
}
