<?php
/**
 * Kalium WordPress Theme
 *
 * Alert widget.
 *
 * @var array $atts
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

// Attributes
if ( function_exists( 'vc_map_get_attributes' ) ) {
	$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
}

// Extract attributes
extract( $atts );

// Message field fix
$message_safe = $message;

if ( strpos( $message, '#E-' ) == 0 ) {
	$message = vc_value_from_safe( $message );
}

// Element class
$class     = $this->getExtraClass( $el_class );
$css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $class, $this->settings['base'], $atts );

$classes = [
	'lab-alert',
	'alert',
	'fade',
	'in',
	$css_class,
	vc_shortcode_custom_css_class( $css ),
];

switch ( $type ) {
	case 'info':
		$classes[] = 'alert-info';
		break;

	case 'success':
		$classes[] = 'alert-success';
		break;

	case 'warning':
		$classes[] = 'alert-warning';
		break;

	case 'error':
		$classes[] = 'alert-danger';
		break;

	default:
		$classes[] = 'alert-default';
}

?>
<div <?php kalium_class_attr( $classes ); ?> role="alert">
	<?php if ( $close_button ) : ?>
		<button type="button" class="close" data-dismiss="alert">
			<span aria-hidden="true"></span>
			<span class="sr-only"><?php esc_html_e( 'Close', 'kalium' ); ?></span>
		</button>
	<?php endif; ?>

	<?php echo wp_kses_post( apply_filters( 'the_content', $message ) ); ?>
</div>
