<?php
/**
 * Kalium WordPress Theme
 *
 * Share and like widget.
 *
 * @var array $atts
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

// Attributes
if ( function_exists( 'vc_map_get_attributes' ) ) {
	$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
}

// Extract attributes
extract( $atts );

$like_share_args = [];

if ( 'rounded' === $layout ) {
	$like_share_args['secondary'] = true;
}

if ( 'center' === $alignment ) {
	$like_share_args['centered'] = true;
}

// Element class
$class     = $this->getExtraClass( $el_class );
$css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $class, $this->settings['base'], $atts );

$classes = [
	'lab-portfolio-share-like',
	'lab-portfolio-share-like--' . $alignment,
	$css_class,
	vc_shortcode_custom_css_class( $css ),
];

?>
<div <?php kalium_class_attr( $classes ); ?>>
	<?php
	kalium_portfolio_single_like_and_share( $like_share_args );
	?>
</div>
