<?php
/**
 * Kalium WordPress Theme
 *
 * Service box content.
 *
 * @var array $atts
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

// Attributes
if ( function_exists( 'vc_map_get_attributes' ) ) {
	$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
}

// Extract attributes
extract( $atts );

// Link
$link = vc_build_link( $link );

// Element class
$class     = $this->getExtraClass( $el_class );
$css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $class, $this->settings['base'], $atts );

$classes = [
	'icon-box-content',
	'text-alignment-' . $text_alignment,
	$css_class,
	vc_shortcode_custom_css_class( $css ),
];

$heading_classes = [
	kalium_get_link_style_class_by_context( 'wpb_lab_service_box_title' ),
];

?>
<div <?php kalium_class_attr( $classes ); ?>>
	<h3 <?php kalium_class_attr( $heading_classes ); ?>>
		<?php if ( $link['url'] ) : ?>
			<a href="<?php echo esc_url( $link['url'] ); ?>" title="<?php echo esc_attr( $link['title'] ); ?>" target="<?php echo esc_attr( $link['target'] ); ?>"><?php echo esc_html( $title ); ?></a>
		<?php else : ?>
			<?php echo esc_html( $title ); ?>
		<?php endif; ?>
	</h3>

	<div class="entry-content">
		<?php echo wp_kses_post( wpautop( $description ) ); ?>
	</div>
</div>
