<?php 
/**
 * Templates Name: Elementor
 * Widget: Products
 */

extract($settings);

if (isset($limit) && !((bool) $limit)) {
    return;
}

$this->settings_layout();

// Generate a unique cache key for the query
$cache_key = 'kera_products_query_' . md5(serialize($settings));
$loop = get_transient($cache_key);

if ($loop === false) {
    /** Get Query Products */
    $loop = kera_get_query_products($categories, $cat_operator, $product_type, $limit, $orderby, $order);
    set_transient($cache_key, $loop, DAY_IN_SECONDS); // Cache for 1 day
}

$attr_row = $this->get_render_attribute_string('row');

?>

<div <?php $this->print_render_attribute_string('wrapper'); ?>>

    <?php $this->render_element_heading(); ?>

    <?php 
    wc_get_template('layout-products/layout-products.php', array(
        'loop' => $loop,
        'product_style' => $product_style,
        'attr_row' => $attr_row
    ));
    ?>

    <?php $this->render_item_button(); ?>
</div>