<?php 
/**
 * Templates Name: Elementor
 * Widget: Site Logo
 */

if( $settings['logo_select'] === 'global_logo' ){
    $custom_logo = $this->get_value();

    $settings['image']['url'] = $custom_logo['url'];
    $settings['image']['id'] = '';

}else{
    $settings['image']['url'] = $settings['image_logo']['url'];
    $settings['image']['id'] = $settings['image_logo']['id'];
}

if ( empty( $settings['image']['url'] ) ) {
    return;
}


$has_caption = ! empty( $settings['caption'] );

$this->add_render_attribute( 'content', 'class', 'header-logo' );

if ( ! empty( $settings['shape'] ) ) {
    $this->add_render_attribute( 'wrapper', 'class', 'elementor-image-shape-' . $settings['shape'] );
}
 
$link = $this->get_link_url( $settings );

if ( !empty($link['url']) ) {
    $this->add_render_attribute( 'link', [
        'href' => $link['url'],
    ] );
} ?>

<div <?php $this->print_render_attribute_string( 'wrapper' ); ?>>

    <div <?php $this->print_render_attribute_string( 'content' ); ?>>
        <?php if ( !empty($link['url']) ) : ?>

             <a <?php $this->print_render_attribute_string( 'link' ); ?>>
                <?php echo  Elementor\Group_Control_Image_Size::get_attachment_image_html( $settings ); ?>
            </a>
 
        <?php else: ?>
            <?php echo  Elementor\Group_Control_Image_Size::get_attachment_image_html( $settings ); ?>
        <?php endif; ?>
    </div>

</div>