<?php if ( ! defined('KERA_THEME_DIR')) exit('No direct script access allowed');

if (!function_exists('kera_clear_header_layouts_transient')) {
    function kera_clear_header_layouts_transient($post_id, $post, $update) {
        if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
            return;
        }

        if ($post->post_status !== 'publish') {
            return;
        }

        $transient_name = 'kera_header_layouts';
        delete_transient($transient_name);
    }
    add_action('save_post_tbay_header', 'kera_clear_header_layouts_transient', 10, 3);
}

if (!function_exists('kera_clear_footer_layouts_transient')) {
    function kera_clear_footer_layouts_transient($post_id, $post, $update) {
        if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
            return;
        }

        if ($post->post_status !== 'publish') {
            return;
        }
 
        delete_transient('kera_footer_layouts');
        delete_transient('kera_footer_builder_' . md5($post_id));
    }
    add_action('save_post_tbay_footer', 'kera_clear_footer_layouts_transient', 10, 3);
}

if (!function_exists('kera_clear_variation_swatchs_transient')) {
    function kera_clear_variation_swatchs_transient($attribute_id = null, $attribute = null) {
        $transient_name = 'kera_variation_swatchs';
        delete_transient($transient_name);
    }

    add_action('woocommerce_attribute_added', 'kera_clear_variation_swatchs_transient', 10, 2);
    add_action('woocommerce_attribute_updated', 'kera_clear_variation_swatchs_transient', 10, 2);
    add_action('woocommerce_attribute_deleted', 'kera_clear_variation_swatchs_transient', 10, 2);
}

if (!function_exists('kera_clear_post_tags_transient')) {
    function kera_clear_post_tags_transient($post_id) {
        delete_transient('kera_post_tags_' . $post_id);
    }

    add_action('save_post', 'kera_clear_post_tags_transient');
}

if (!function_exists('kera_clear_post_galleries_transient')) {
    function kera_clear_post_galleries_transient($meta_id, $object_id, $meta_key, $meta_value) {
        if ($meta_key === 'tbay_post_gallery_files') {
            delete_transient('kera_post_galleries_' . $object_id . '_full');
        }
    }

    add_action('update_post_meta', 'kera_clear_post_galleries_transient', 10, 4);
}

if (!function_exists('kera_clear_author_info_transient')) {
    function kera_clear_author_info_transient($user_id) {
        delete_transient('kera_post_author_info_' . $user_id);
    }

    add_action('profile_update', 'kera_clear_author_info_transient');
}

if (!function_exists('kera_clear_header_id_transient')) {
    function kera_clear_header_id_transient($post_id) {
        $header = get_post_field('post_name', $post_id);
        delete_transient('kera_header_id_' . md5($header));
    }

    add_action('save_post_tbay_header', 'kera_clear_header_id_transient');
}

if (!function_exists('kera_clear_footer_id_transient')) {
    function kera_clear_footer_id_transient($post_id) {
        $footer = get_post_field('post_name', $post_id);
        delete_transient('kera_footer_id_' . md5($footer));
    }

    add_action('save_post_tbay_footer', 'kera_clear_footer_id_transient');
}

if (!function_exists('kera_clear_post_categories_transient')) {
    function kera_clear_post_categories_transient($post_id) {
        if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
            return;
        }

        $transient_name = 'kera_post_categories_' . $post_id;
        delete_transient($transient_name);
    }
    add_action('save_post', 'kera_clear_post_categories_transient');
}

if ( ! function_exists( 'kera_clear_product_gallery_transient' ) ) {
    function kera_clear_product_gallery_transient( $product_id = null ) {
        global $wpdb;

        if ( $product_id ) {
            $cache_key = 'kera_product_gallery_' . $product_id;
            delete_transient( $cache_key );
        } else {
            $wpdb->query( "DELETE FROM $wpdb->options WHERE option_name LIKE '_transient_kera_product_gallery_%'" );
        }
    }

    add_action( 'woocommerce_update_product', 'kera_clear_product_gallery_transient', 10, 1 );
    add_action( 'update_option_woocommerce_thumbnail_image_width', 'kera_clear_product_gallery_transient' );
    add_action( 'update_option_woocommerce_thumbnail_image_height', 'kera_clear_product_gallery_transient' );

    add_action( 'delete_post', 'kera_handle_product_deletion', 10, 1 );
    function kera_handle_product_deletion( $post_id ) {
        if ( get_post_type( $post_id ) === 'product' ) {
            kera_clear_product_gallery_transient( $post_id );
        }
    }
}

if ( ! function_exists( 'kera_swatches_list' ) ) {
    function kera_swatches_list( $attribute_name = false ) {
        global $product;
        $id = $product->get_id();
        if ( empty( $id ) || ! $product->is_type( 'variable' ) ) {
            return false;
            exit();
        }

        $attribute_name = $attribute_name ? sanitize_key( $attribute_name ) : kera_get_swatches_attribute();
        if ( empty( $attribute_name ) ) {
            return false;
            exit();
        }

        $cache_key = 'kera_swatches_' . $id . '_' . $attribute_name;
        $output = get_transient( $cache_key );
        if ( false === $output ) {
            $available_variations = $product->get_available_variations();
            if ( empty( $available_variations ) ) {
                return false;
                exit();
            }

            $swatches_to_show = kera_get_option_variations( $attribute_name, $available_variations, false, $id );
            if ( empty( $swatches_to_show ) ) {
                return false;
                exit();
            }

            $terms = wc_get_product_terms( $id, $attribute_name, array( 'fields' => 'slugs' ) );
            $swatches_to_show = array_intersect_key( $swatches_to_show, array_flip( $terms ) );

            ob_start();
            wc_get_template( 'custom/swatches-list.php', array(
                'attribute_name'    => $attribute_name,
                'swatches_to_show'  => $swatches_to_show,
            ) );
            $output = ob_get_clean();

            set_transient( $cache_key, $output, HOUR_IN_SECONDS );
        }

        return $output;
        exit();
    }
}

if ( ! function_exists( 'kera_clear_swatches_transient' ) ) {
    /**
     * Delete transient for product swatches.
     *
     * @param int|null $product_id Product ID. If null, delete all related transients.
     * @param string|null $attribute_name Attribute name. If null, delete all transients for the product.
     */
    function kera_clear_swatches_transient( $product_id = null, $attribute_name = null ) {
        global $wpdb;

        if ( $product_id && $attribute_name ) {
            // Delete transient for a specific product and attribute
            $cache_key = 'kera_swatches_' . $product_id . '_' . sanitize_key( $attribute_name );
            delete_transient( $cache_key );
        } elseif ( $product_id ) {
            // Delete all swatches transients for a specific product
            $wpdb->query( $wpdb->prepare(
                "DELETE FROM $wpdb->options WHERE option_name LIKE %s",
                '_transient_kera_swatches_' . $product_id . '_%'
            ) );
        } else {
            // Delete all transients related to kera_swatches
            $wpdb->query( "DELETE FROM $wpdb->options WHERE option_name LIKE '_transient_kera_swatches_%'" );
        }
    }

    // Automatically delete transient when a product is updated
    add_action( 'woocommerce_update_product', 'kera_clear_swatches_transient_on_update', 10, 1 );
    function kera_clear_swatches_transient_on_update( $product_id ) {
        kera_clear_swatches_transient( $product_id ); // Delete all swatches for the product
    }

    // Automatically delete transient when a product is deleted
    add_action( 'delete_post', 'kera_handle_swatches_deletion', 10, 1 );
    function kera_handle_swatches_deletion( $post_id ) {
        if ( get_post_type( $post_id ) === 'product' ) {
            kera_clear_swatches_transient( $post_id );
        }
    }

    // Automatically delete transient when a product variation is saved
    add_action( 'woocommerce_save_product_variation', 'kera_clear_swatches_transient_on_variation_save', 10, 2 );
    function kera_clear_swatches_transient_on_variation_save( $variation_id, $i ) {
        $product_id = wp_get_post_parent_id( $variation_id );
        if ( $product_id ) {
            kera_clear_swatches_transient( $product_id );
        }
    }
}

if (!function_exists('kera_clear_tbay_megamenu_transient_on_save')) {
    /**
     * Delete transients related to a specific tbay_megamenu post when updated.
     */
    function kera_clear_tbay_megamenu_transient_on_save($post_id) {
        // Check if this is an autosave or revision
        if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
            return;
        }


        $transient_list = get_option('kera_megamenu_transients', array());

        $transient_mmenu_list = get_option('kera_mmenu_transients', array());

        foreach ($transient_list as $transient_name => $related_post_id) {
            if ($related_post_id == $post_id) {
                delete_transient($transient_name);
                unset($transient_list[$transient_name]);
            }
        }

        foreach ($transient_mmenu_list as $transient_name => $related_post_id) {
            if ($related_post_id == $post_id) {
                delete_transient($transient_name);
                unset($transient_mmenu_list[$transient_name]);
            }
        }

        update_option('kera_megamenu_transients', $transient_list);
    }
    add_action('save_post_tbay_megamenu', 'kera_clear_tbay_megamenu_transient_on_save');
}

if (!function_exists('kera_delete_menu_transient')) {
    add_action('wp_create_nav_menu', 'kera_delete_menu_transient', 10, 1);
    add_action('wp_delete_nav_menu', 'kera_delete_menu_transient', 10, 1);
    function kera_delete_menu_transient($menu_id) {
        $cache_key = 'kera_available_menus';
        delete_transient($cache_key);
    }
}

if (!function_exists('kera_clear_woocommerce_tags_transient')) {
    function kera_clear_woocommerce_tags_transient($term_id) {
        $transient_name = 'kera_woocommerce_tags';
        delete_transient($transient_name);
    }
    add_action('created_product_tag', 'kera_clear_woocommerce_tags_transient', 10, 1);
    add_action('delete_product_tag', 'kera_clear_woocommerce_tags_transient', 10, 1);
    add_action('edited_product_tag', 'kera_clear_woocommerce_tags_transient', 10, 1);
}

if (! function_exists('kera_clear_megamenu_cache')) {
    function kera_clear_megamenu_cache($post_id) {
        set_transient('kera_megamenu_cache_clear', true, 60);
    }
    add_action('save_post_tbay_megamenu', 'kera_clear_megamenu_cache');
    add_action('delete_post_tbay_megamenu', 'kera_clear_megamenu_cache');
    add_action('wp_trash_post_tbay_megamenu', 'kera_clear_megamenu_cache');
}

if (!function_exists('kera_clear_all_product_transients')) {
    add_action('woocommerce_product_set_stock', 'kera_clear_all_product_transients');
    add_action('woocommerce_update_product_sale_price', 'kera_clear_all_product_transients');
    add_action('save_post_product', 'kera_clear_all_product_transients');
    add_action('delete_post_product', 'kera_clear_all_product_transients');
    add_action('edit_post_product', 'kera_clear_all_product_transients');
    function kera_clear_all_product_transients( $post_id ) {
        if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
            return;
        }
        if ( get_post_type( $post_id ) !== 'product' ) {
            return;
        }

        global $wpdb;
        
        $prefixes = array(
            'kera_products_query_',
            'kera_product_categories_',
            'kera_product_categories_tab_loop_',
            'kera_product_count_down_loop_',
            'kera_product_flash_sales_loop_',
            'kera_product_tabs_loop_',
        );
        
        foreach ( $prefixes as $prefix ) {
            $wpdb->query( 
                $wpdb->prepare( 
                    "DELETE FROM {$wpdb->options} WHERE option_name LIKE %s", 
                    '_transient_' . $prefix . '%' 
                ) 
            );
            $wpdb->query( 
                $wpdb->prepare( 
                    "DELETE FROM {$wpdb->options} WHERE option_name LIKE %s", 
                    '_transient_timeout_' . $prefix . '%' 
                ) 
            );
        }

        delete_transient('kera_on_sale_products');
        delete_transient( 'kera_woocommerce_tags' );
    }
}