<?php
if (!defined('ABSPATH') || function_exists('Kera_Elementor_Widget_Image') ) {
    exit; // Exit if accessed directly.
}

use Elementor\Widget_Image;


abstract class Kera_Elementor_Widget_Image extends Widget_Image {
	public function get_name_template() {
        return str_replace('tbay-', '', $this->get_name());
    }

    public function get_categories() {
        return [ 'kera-elements' ];
    }

    public function get_name() {
        return 'tbay-base';
    }

    /**
	 * Get view template
	 *
	 * @param string $tpl_name
	 */
	protected function get_view_template($tpl_slug, $tpl_name, $settings = []) {
		$cache_key = 'kera_template_' . md5($tpl_slug . $tpl_name);
		$located = get_transient($cache_key);
	
		if (false === $located) {
			$templates = [];
			$settings = $settings ?: $this->get_settings_for_display();
			$tpl_name = $tpl_name ? trim(str_replace('.php', '', $tpl_name), DIRECTORY_SEPARATOR) : '';
	
			if ($tpl_name) {
				$templates[] = "elementor_templates/{$tpl_slug}-{$tpl_name}.php";
				$templates[] = "elementor_templates/{$tpl_slug}/{$tpl_name}.php";
			}
			$templates[] = "elementor_templates/{$tpl_slug}.php";
	
			foreach ($templates as $template) {
				$located = file_exists(KERA_THEMEROOT . '/' . $template) ? locate_template($template) : false;
				if ($located) {
					break;
				}
			}
	
			set_transient($cache_key, $located, WEEK_IN_SECONDS);
		}
	
		if ($located) {
			include $located;
		} else {
			printf(
				/* translators: %1$s: template slug, %2$s: template name */
				esc_html__('Failed to load template with slug "%1$s" and name "%2$s".', 'kera'),
				esc_html($tpl_slug),
				esc_html($tpl_name)
			);
		}
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		$this->add_render_attribute('wrapper', 'class', ['tbay-element', 'tbay-element-' . $this->get_name_template()]);
	
		$this->get_view_template($this->get_name_template(), '', $settings);
	}
}