<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

class Kera_Elementor_Addons {
	public function __construct() {
        $this->include_control_customize_widgets();
        $this->include_render_customize_widgets();

		add_action( 'elementor/elements/categories_registered', array( $this, 'add_category' ) );

		add_action( 'elementor/widgets/register', array( $this, 'include_widgets' ) );

		add_action( 'wp', [ $this, 'register_scripts_frontend' ] );

        // editor
        add_action('elementor/editor/after_register_scripts', [ $this, 'editor_after_register_scripts' ]);

        // frontend
        // Register widget scripts
        add_action('elementor/frontend/after_register_scripts', [ $this, 'frontend_after_register_scripts' ]);
        add_action( 'elementor/frontend/after_enqueue_scripts', [ $this, 'frontend_after_enqueue_scripts' ] );
        add_action('elementor/editor/after_enqueue_styles', [$this, 'enqueue_editor_icons'], 99);

    
        add_action( 'widgets_init', array( $this, 'register_wp_widgets' ) );
    }  
   
    /**
     * Register scripts in Elementor editor
     */
    public function editor_after_register_scripts() {
        // Placeholder for future script registration
    } 

    /**
     * Enqueue frontend scripts and styles
     */
    public function frontend_after_enqueue_scripts() {
        wp_enqueue_script('jquery-treeview');
        wp_enqueue_script('kera-script');
        wp_enqueue_script('jquery-countdowntimer');
        wp_enqueue_style('sumoselect');
        wp_enqueue_script('jquery-sumoselect');
    }

    public function enqueue_editor_icons() {
        wp_enqueue_style( 'simple-line-icons', KERA_STYLES . '/simple-line-icons.css', array(), '2.4.0' );
        wp_enqueue_style( 'fontawesome', KERA_STYLES . '/fontawesome.css', array(), '5.10.2' );
        wp_enqueue_style( 'material-design-iconic-font', KERA_STYLES . '/material-design-iconic-font.css', array(), '2.2.0' ); 
        Elementor\Icons_Manager::enqueue_shim();

    }


    /**
     * @internal Used as a callback
     */
    public function frontend_after_register_scripts() {
        $this->editor_after_register_scripts();
    }


    /**
     * Register WordPress widgets
     */
    public function register_wp_widgets() {
        // Placeholder for future widget registration
    }

    /**
     * Register frontend scripts
     */
    public function register_scripts_frontend() {
        // Placeholder for future script registration
    }

    /**
     * Add custom category to Elementor
     *
     * @param \Elementor\Elements_Manager $elements_manager
     */
    public function add_category( $elements_manager ) {
        $elements_manager->add_category(
            'kera-elements',
            array(
                'title' => esc_html__('Kera Elements', 'kera'),
                'icon'  => 'fa fa-plug',
            )
        );
    }

    /**
     * @param $widgets_manager Elementor\Widgets_Manager
     */
    public function include_widgets($widgets_manager) {
        $this->include_abstract_widgets($widgets_manager);
        $this->include_general_widgets($widgets_manager);
        $this->include_header_widgets($widgets_manager);
        $this->include_woocommerce_widgets($widgets_manager);
	} 


    /**
     * Include general widgets
     *
     * @param \Elementor\Widgets_Manager $widgets_manager
     */
    public function include_general_widgets($widgets_manager) {
        $elements = kera_elementor_general_widgets();

        foreach ($elements as $file) {
            $path = KERA_ELEMENTOR . '/elements/general/' . sanitize_file_name($file) . '.php';
            if (file_exists($path)) {
                require_once $path;
            }
        }
    } 

    /**
     * Include WooCommerce widgets
     *
     * @param \Elementor\Widgets_Manager $widgets_manager
     */
    public function include_woocommerce_widgets($widgets_manager) {
        if (!kera_is_Woocommerce_activated()) {
            return;
        }

        $woo_elements = kera_elementor_woocommerce_widgets();

        foreach ($woo_elements as $file) {
            $path = KERA_ELEMENTOR . '/elements/woocommerce/' . sanitize_file_name($file) . '.php';
            if (file_exists($path)) {
                require_once $path;
            }
        }
    } 

    /**
     * Include header widgets
     *
     * @param \Elementor\Widgets_Manager $widgets_manager
     */
    public function include_header_widgets($widgets_manager) {
        $elements = kera_elementor_header_widgets();

        foreach ($elements as $file) {
            $path = KERA_ELEMENTOR . '/elements/header/' . sanitize_file_name($file) . '.php';
            if (file_exists($path)) {
                require_once $path;
            }
        }
    }


    /**
     * Include abstract widgets
     *
     * @param \Elementor\Widgets_Manager $widgets_manager
     */
    public function include_abstract_widgets($widgets_manager) {
        $abstracts = apply_filters('kera_abstract_elements_array', [
            'image',
            'base',
            'responsive',
            'carousel',
        ]);

        foreach ($abstracts as $file) {
            $path = KERA_ELEMENTOR . '/abstract/' . sanitize_file_name($file) . '.php';
            if (file_exists($path)) {
                require_once $path;
            }
        }
    }

    /**
     * Include control customize widgets
     */
    public function include_control_customize_widgets() {
        $widgets = apply_filters('kera_customize_elements_array', [
            'sticky-header',
            'column',
            'column-border',
            'section-stretch-row',
            'settings-layout',
        ]);

        foreach ($widgets as $file) {
            $path = KERA_ELEMENTOR . '/elements/customize/controls/' . sanitize_file_name($file) . '.php';
            if (file_exists($path)) {
                require_once $path;
            }
        }
    } 

    /**
     * Include render customize widgets
     */
    public function include_render_customize_widgets() {
        $widgets = apply_filters('kera_customize_elements_array', [
            'sticky-header',
            'column-border',
        ]);

        foreach ($widgets as $file) {
            $path = KERA_ELEMENTOR . '/elements/customize/render/' . sanitize_file_name($file) . '.php';
            if (file_exists($path)) {
                require_once $path;
            }
        }
    }
}

new Kera_Elementor_Addons();

