<?php
if (!defined('ABSPATH') || !class_exists('WooCommerce')) {
    exit;
}

if (!class_exists('Kera_Cart')) :

    class Kera_Cart
    {
        private static $instance;

        /**
         * @return Kera_Cart
         */
        public static function getInstance()
        {
            if (!isset(self::$instance) || !(self::$instance instanceof Kera_Cart)) {
                self::$instance = new self();
            }
            return self::$instance;
        }

        /**
         * Setup class.
         *
         * @since 1.0
         */
        public function __construct()
        {
            // Cart modal
            add_action('wp_ajax_kera_add_to_cart_product', [$this, 'woocommerce_cart_modal'], 10);
            add_action('wp_ajax_nopriv_kera_add_to_cart_product', [$this, 'woocommerce_cart_modal'], 10);
            add_action('wp_footer', [$this, 'add_to_cart_modal_html'], 20);

            // Cart fragments
            add_filter('woocommerce_add_to_cart_fragments', [$this, 'add_to_cart_fragments'], 10, 1);
            add_filter('woocommerce_add_to_cart_fragments', [$this, 'add_to_cart_fragments_mobile'], 20, 1);

            // Cart position
            add_filter('kera_cart_position', [$this, 'woocommerce_cart_position'], 10, 1);
            add_filter('body_class', [$this, 'body_classes_cart_postion'], 40, 1);

            // Mobile add to cart message
            add_filter('wc_add_to_cart_message_html', [$this, 'add_to_cart_message_html_mobile'], 10, 1);

            // Show add to cart on mobile
            add_filter('kera_show_cart_mobile', [$this, 'show_cart_mobile'], 10, 1);
            add_filter('body_class', [$this, 'body_classes_show_cart_mobile'], 10, 1);

            // AJAX remove product
            add_action('wp_ajax_product_remove', [$this, 'ajax_product_remove'], 10);
            add_action('wp_ajax_nopriv_product_remove', [$this, 'ajax_product_remove'], 10);
        }

        /**
         * Add cart modal HTML to footer
         */
		public function add_to_cart_modal_html() {
			if( is_account_page() || is_checkout() || ( function_exists('is_vendor_dashboard') && is_vendor_dashboard() ) ) return;        
		    ?>
		    <div id="tbay-cart-modal" tabindex="-1" role="dialog" aria-hidden="true">
		        <div class="modal-dialog modal-lg">
		            <div class="modal-content">
		                <div class="modal-body">
		                    <div class="modal-body-content"></div>
		                </div>
		            </div>
				</div>
				<div id="tbay-cart-modal-close"></div>
		    </div>
		    <?php    
		}

        /**
         * AJAX handler for cart modal
         */
        public function woocommerce_cart_modal()
        {
            check_ajax_referer('kera_cart_modal_nonce', 'nonce');

            $product_id = isset($_GET['product_id']) ? absint($_GET['product_id']) : 0;
            $product_qty = isset($_GET['product_qty']) ? absint($_GET['product_qty']) : 1;

            if (!$product_id) {
                wp_send_json_error(['message' => esc_html__('Invalid product ID', 'kera')]);
                wp_die();
            }

            wc_get_template(
                'content-product-cart-modal.php',
                ['product_id' => $product_id, 'product_qty' => $product_qty]
            );

            wp_die(); 
        }

        /**
         * Determine cart position
         */
        public function woocommerce_cart_position($position)
        {
            if (apply_filters('kera_check_cart_position_is_mobile', wp_is_mobile())) {
                return 'right';
            }

            $valid_positions = ['popup', 'left', 'right', 'no-popup'];
            $default_position = kera_tbay_get_config('woo_mini_cart_position', 'popup');
            $position = isset($_GET['ajax_cart']) ? sanitize_key($_GET['ajax_cart']) : $default_position;

            return in_array($position, $valid_positions) ? $position : $default_position;
        }

        /**
         * Add cart position classes to body
         */
        public function body_classes_cart_postion($classes)
        {
            $position = apply_filters('kera_cart_position', '');
            $class = isset($_GET['ajax_cart']) ? 'ajax_cart_' . sanitize_key($_GET['ajax_cart']) : 'ajax_cart_' . $position;
            $classes[] = trim($class);
            return $classes;
        }

        /**
         * Fragments for mobile cart
         */
        public function add_to_cart_fragments_mobile($fragments)
        {
            ob_start();
            ?>
            <span class="mini-cart-items cart-mobile">
                <?php echo esc_html(WC()->cart->cart_contents_count); ?>
            </span>
            <?php
            $fragments['span.cart-mobile'] = ob_get_clean();
            return $fragments;
        }

        /**
         * Fragments for desktop cart
         */
        public function add_to_cart_fragments($fragments)
        {
            $count = WC()->cart->get_cart_contents_count();
            $fragments['.mini-cart .mini-cart-items'] = sprintf(
                _n(
                    ' <span class="mini-cart-items"> %d </span> ',
                    ' <span class="mini-cart-items"> %d </span> ',
                    $count,
                    'kera'
                ),
                esc_html($count)
            );
            $fragments['.mini-cart .mini-cart-total'] = trim(WC()->cart->get_cart_subtotal());
            return $fragments;
        }

        /**
         * Customize add to cart message on mobile
         */
        public function add_to_cart_message_html_mobile($message)
        {
            if (isset($_REQUEST['kera_buy_now']) && $_REQUEST['kera_buy_now'] == true) {
                return '';
            }

            if (wp_is_mobile() && !intval(kera_tbay_get_config('enable_buy_now', false))) {
                return '';
            }

            return $message;
        }

        /**
         * Check if cart should show on mobile
         */
        public function show_cart_mobile($active)
        {
            $active = kera_tbay_get_config('enable_add_cart_mobile', false);
            return isset($_GET['add_cart_mobile']) ? sanitize_text_field($_GET['add_cart_mobile']) : $active;
        }

        /**
         * Add mobile cart classes to body
         */
        public function body_classes_show_cart_mobile($classes)
        {
            $active = apply_filters('kera_show_cart_mobile', false);
            if ($active) {
                $classes[] = 'tbay-show-cart-mobile';
            }
            return $classes;
        }

        /**
         * AJAX handler to remove product from cart
         */
        public function ajax_product_remove()
        {
            check_ajax_referer('kera_cart_remove_nonce', 'nonce');

            $product_id = isset($_POST['product_id']) ? absint($_POST['product_id']) : 0;
            $cart_item_key = isset($_POST['cart_item_key']) ? sanitize_key($_POST['cart_item_key']) : '';

            if (!$product_id || !$cart_item_key) {
                wp_send_json_error(['message' => esc_html__('Invalid request', 'kera')]);
                wp_die();
            }

            foreach (WC()->cart->get_cart() as $key => $item) {
                if ($item['product_id'] == $product_id && $key == $cart_item_key) {
                    WC()->cart->remove_cart_item($key);
                    break;
                }
            }

            WC()->cart->calculate_totals();
            WC()->cart->maybe_set_cart_cookies();

            ob_start();
            woocommerce_mini_cart();
            $mini_cart = ob_get_clean();

            $data = [
                'fragments' => apply_filters('woocommerce_add_to_cart_fragments', [
                    'div.widget_shopping_cart_content' => '<div class="widget_shopping_cart_content">' . $mini_cart . '</div>',
                ]),
                'cart_hash' => apply_filters('woocommerce_cart_hash', WC()->cart->get_cart_for_session() ? md5(json_encode(WC()->cart->get_cart_for_session())) : '', WC()->cart->get_cart_for_session()),
            ];

            wp_send_json($data);
            wp_die();
        }
    }

endif;

if (!function_exists('kera_cart')) {
    function kera_cart()
    {
        return Kera_Cart::getInstance();
    }
    kera_cart();
}