<?php
if ( ! defined( 'ABSPATH' ) || !class_exists('WooCommerce') ) {
	exit;
}

if ( ! class_exists( 'Kera_Shop_WooCommerce' ) ) :


	class Kera_Shop_WooCommerce  {

		static $instance;

		/**
		 * @return osf_WooCommerce
		 */
		public static function getInstance() {
			if ( ! isset( self::$instance ) && ! ( self::$instance instanceof Kera_Shop_WooCommerce ) ) {
				self::$instance = new Kera_Shop_WooCommerce();
			}

			return self::$instance;
		}


		/**
		 * Setup class.
		 *
		 * @since 1.0
		 *
		 */
		public function __construct() {

			add_action( 'woocommerce_archive_description', array( $this, 'shop_category_image'), 2 );
			add_action('woocommerce_before_main_content', array( $this, 'shop_remove_des_image'), 20);

			/*Shop page*/
			add_action( 'woocommerce_before_shop_loop', array( $this, 'shop_display_modes'), 40 );
			add_action( 'woocommerce_before_shop_loop', array( $this, 'shop_filter_before') , 1 );
			add_action( 'woocommerce_before_shop_loop', array( $this, 'content_shop_filter_before') , 15 );
			add_action( 'woocommerce_before_shop_loop', array( $this, 'content_shop_filter_after') , 70 );
			add_action( 'woocommerce_before_shop_loop', array( $this, 'shop_filter_after') , 70 );

			add_action( 'kera_woo_template_main_before', array( $this, 'shop_product_top_sidebar'), 50 );

			add_filter( 'loop_shop_per_page', array( $this, 'shop_per_page'), 10 );
			add_filter( 'loop_shop_columns', array( $this, 'shop_columns'), 10 );

			add_action( 'kera_tbay_after_shop_loop_item_title', array( $this, 'add_slider_image'), 10 );

			/*display image mode*/
			add_filter( 'kera_woo_display_image_mode', array( $this, 'get_display_image_mode'), 10, 1 );

			add_filter( 'kera_woo_config_product_layout', array( $this, 'product_layout_style') );

			add_action('woocommerce_before_shop_loop_item_title', array( $this, 'the_display_image_mode'), 10);

			/*swatches*/
			add_action( 'kera_woo_after_shop_loop_item_caption', array( $this, 'the_woocommerce_variable'), 5 );
			add_action( 'kera_woo_list_after_caption', array( $this, 'the_woocommerce_variable'), 5 );
			add_action( 'kera_woo_after_shop_loop_item_caption', array( $this, 'grid_variable_swatches_pro'), 10 );
			add_action( 'kera_woo_list_after_caption', array( $this, 'list_variable_swatches_pro'), 5 );


			/*Shop filter config*/
			add_action( 'init', array( $this, 'shop_filter_config'), 10 );

			/*Shop Query*/
			add_action( 'woocommerce_product_query', array( $this, 'product_per_page_query'), 10, 2 );
			add_action( 'woocommerce_product_query', array( $this, 'product_category_query'),30 ,2 );
 
			/*Load more shop grid*/
			add_action('wp_ajax_nopriv_tbay_grid_post_ajax', array( $this, 'ajax_load_more_grid_product'), 10);
			add_action('wp_ajax_tbay_grid_post_ajax', array( $this, 'ajax_load_more_grid_product'), 10);

			/*Load more shop list*/
			add_action('wp_ajax_nopriv_tbay_list_post_ajax', array( $this, 'ajax_load_more_list_product'), 10);
			add_action('wp_ajax_tbay_list_post_ajax', array( $this, 'ajax_load_more_list_product'), 10);

			/*Display category image on category archive*/
			add_action('woocommerce_before_main_content', array( $this, 'shop_product_top_archive'), 10);

			add_filter( 'kera_woocommerce_sub_categories', array( $this, 'show_product_subcategories'), 10, 1 );

			add_filter( 'kera_sidebar_top_archive', array( $this, 'sidebar_top_archive_active'), 10, 1 );

			add_filter( 'woocommerce_show_page_title' , array( $this, 'remove_title_product_archives_active'), 10, 1 );

			add_filter( 'kera_woo_config_display_mode', array( $this, 'display_modes_active'), 10, 1 );

			/*The YITH BRAND*/
			add_action('kera_tbay_before_image_item', array( $this, 'the_brands_the_name') , 10);

			/** Add recent view */
			// add_action( 'woocommerce_after_main_container', array( $this, 'recent_viewed') , 0 );
		}

		public function shop_display_modes() {

			$active  = apply_filters( 'kera_woo_config_display_mode', 10,2 );

	        if ( !$active || !wc_get_loop_prop( 'is_paginated' ) || ( !woocommerce_products_will_display() && !kera_woo_is_vendor_page() ) ) {
	            return;
	        }
	        
			$woo_mode      = kera_tbay_woocommerce_get_display_mode();

	        $grid = ($woo_mode == 'grid') ? 'active' : '';
	        $list = ($woo_mode == 'list') ? 'active' : '';

	        ?>
	        <div class="display-mode-warpper">
	        	<span class="d-sm-none"><?php esc_html_e('View: ', 'kera'); ?></span>
	            <a href="javascript:void(0);" id="display-mode-grid" class="display-mode-btn <?php echo esc_attr($grid); ?>" title="<?php esc_attr_e('Grid','kera'); ?>" ><i class="icon-grid"></i></a>
	            <a href="javascript:void(0);" id="display-mode-list" class="display-mode-btn list <?php echo esc_attr($list); ?>" title="<?php esc_attr_e('List','kera'); ?>" ><i class="icon-list"></i></a>
	        </div>

	        <?php
		}

		public function shop_filter_before() {
			$notproducts =  ( kera_is_check_hidden_filter() ) ? ' hidden' : '';

	        echo '<div class="tbay-filter'. esc_attr( $notproducts ) . '">';
		}

		public function shop_filter_after() {	
			echo '</div>';
		}
		
		public function content_shop_filter_before() {
	        echo '<div class="main-filter d-flex justify-content-end">';
		}

		public function content_shop_filter_after() {	
			echo '</div>';
		}

		public function shop_product_top_sidebar() {

			$sidebar_configs = kera_tbay_get_woocommerce_layout_configs();

	        if( !is_product()  && isset($sidebar_configs['product_top_sidebar']) && $sidebar_configs['product_top_sidebar'] ) {
	            ?>

	            <?php if(is_active_sidebar('product-top-sidebar')) : ?>
	                <div class="product-top-sidebar">
	                    <div class="container">
	                        <div class="content">
	                            <?php dynamic_sidebar('product-top-sidebar'); ?>
	                        </div>
	                    </div>
	                </div>
	            <?php endif;
	        } 

		}

		public function shop_per_page()
		{
			$value = isset($_GET['product_per_page']) && is_numeric($_GET['product_per_page']) ? absint($_GET['product_per_page']) : kera_tbay_get_config('number_products_per_page', 12);
			return $value;
		}

		public function shop_columns()
		{
			$value = isset($_GET['product_columns']) && is_numeric($_GET['product_columns']) ? absint($_GET['product_columns']) : kera_tbay_get_config('product_columns', 4);
			return in_array($value, [1, 2, 3, 4, 5, 6]) ? $value : 4;
		}

		public function add_slider_image() {

			if( wp_is_mobile() ) return;

	        $images_mode   = apply_filters( 'kera_woo_display_image_mode', 10,2 );

	        if( $images_mode == 'slider' ) {
	            echo kera_tbay_woocommerce_get_silder_product_thumbnail();
	        }

		}

		public function get_display_image_mode($mode)
		{
			$mode = kera_tbay_get_config('product_display_image_mode', 'one');
			$mode = isset($_GET['display_image_mode']) ? sanitize_key($_GET['display_image_mode']) : $mode;
			return wp_is_mobile() ? 'one' : $mode;
		}

		public function the_display_image_mode() {

		 	$images_mode   = apply_filters( 'kera_woo_display_image_mode', 10,2 );

	        if( wp_is_mobile() ) $images_mode = 'one';

	        switch ($images_mode) {
	            case 'one':
	                echo woocommerce_get_product_thumbnail();
	                break;        

	            case 'two':
	                echo kera_tbay_woocommerce_get_two_product_thumbnail();
	                break;
	                
	            case 'slider':
	                echo '';
	                break;
	            
	            default:
	                echo woocommerce_get_product_thumbnail();
	                break;
	        }

		}

		public function the_woocommerce_variable() {
			global $product;

	        $active = apply_filters( 'kera_enable_variation_selector', 10,2 );

	        if( $product->is_type( 'variable' ) && class_exists( 'Woo_Variation_Swatches' ) && $active  ) {

	            ?>
	            	<?php echo kera_swatches_list() ?>
	            <?php

	        }
		}

		public function grid_variable_swatches_pro() {

			if ( class_exists( 'Woo_Variation_Swatches_Pro' )  ) {
			    add_action( 'kera_woo_after_shop_loop_item_caption', 'wvs_pro_archive_variation_template', 5 ); 
			}

		}

		public function list_variable_swatches_pro() {
			if ( class_exists( 'Woo_Variation_Swatches_Pro' ) ) {
	            add_action( 'woocommerce_after_shop_loop_item_title', 'wvs_pro_archive_variation_template', 20 ); 
	        }
		}

		public function shop_category_image() {
			$active = apply_filters( 'kera_woo_pro_des_image', 10,2 );
			if( !$active ) return;

			if ( is_product_category() && !is_search()  ){
				$cat 			= get_queried_object();
				$thumbnail_id 	= get_term_meta( $cat->term_id, 'thumbnail_id', true );
				$image 			= wp_get_attachment_url( $thumbnail_id );
				if ( $image ) {
					echo '<img src="' . esc_url($image) . '" alt="' . esc_attr( $cat->name) . '" />';
				}
			}
		}

		function shop_remove_des_image() { 
			$active = apply_filters( 'kera_woo_pro_des_image', 10,2 );
	
		    if ( !$active ) {
				remove_action( 'woocommerce_archive_description', 'woocommerce_taxonomy_archive_description', 10 );
				remove_action( 'woocommerce_archive_description', 'woocommerce_product_archive_description', 10 );
		   }
		}

		public function product_type_fillter(){
	        $default = 'best_selling';
	        $options = array(
	            'best_selling'      => esc_html__('Best Selling', 'kera'),
	            'featured_product'  => esc_html__('Featured Products', 'kera'),
	            'recent_product'    => esc_html__('Recent Products', 'kera'),
	            'on_sale'           => esc_html__('On Sale', 'kera'),
	            'random_product'    => esc_html__('Random Products', 'kera')
	        );
	        $name = 'product_type';
	        kera_woocommerce_product_fillter($options, $name, $default);
	    }
	    public  function product_per_page_fillter(){
	        $columns = kera_tbay_get_config('product_columns', 4);
	        $default = kera_tbay_get_config('number_products_per_page');
	        $options= array();
	        for($i=1; $i<=5; $i++){
	            $options[$i*$columns] =  $i*$columns.' '.esc_html__( ' products', 'kera');
	        }
	        $options['-1'] = esc_html__('All products', 'kera' );
	        $name = 'product_per_page';
	        kera_woocommerce_product_fillter($options, $name, $default);
	    }
		
		public function product_category_fillter()
		{
			$args = [
				'taxonomy' => 'product_cat',
				'orderby' => 'name',
				'hierarchical' => 1,
				'hide_empty' => 0,
			];
			$all_categories = get_categories($args);
			$options = ['-1' => esc_html__('All Categories', 'kera')];
			$class = ['level-0'];
			$default = esc_html__('All Categories', 'kera');
		
			foreach ($all_categories as $cat) {
				$level = count(get_ancestors($cat->term_id, 'product_cat'));
				$options[$cat->slug] = sprintf('%s (%d)', $cat->name, $cat->count);
				$class[] = 'level-' . $level;
			}
		
			kera_woocommerce_product_fillter($options, 'product_category', $default, $class);
		}

		public function shop_filter_config() {
			if( isset($_GET['product_type_fillter'])  ) {
	            $product_type_fillter = $_GET['product_type_fillter'];
	        } else {
	            $product_type_fillter = kera_tbay_get_global_config('product_type_fillter');
	        }        

	        if( isset($_GET['product_per_page_fillter'])  ) {
	            $product_per_page_fillter = $_GET['product_per_page_fillter'];
	        } else {
	            $product_per_page_fillter = kera_tbay_get_global_config('product_per_page_fillter');
	        }        

	        if( isset($_GET['product_category_fillter'] )  ) {
	            $product_category_fillter = $_GET['product_category_fillter'];
	        } else {
	            $product_category_fillter = kera_tbay_get_global_config('product_category_fillter');
	        }

	        if ( $product_type_fillter ) {
	            add_action( 'woocommerce_product_query', array( $this, 'product_type_query'), 20 ,2 );
	            add_action('woocommerce_before_shop_loop', array( $this, 'product_type_fillter'), 25);
	        }

	        if ( $product_per_page_fillter ) {
	            add_action('woocommerce_before_shop_loop', array( $this, 'product_per_page_fillter'), 25);
	        }

	        if ( $product_category_fillter ) {
	            add_action('woocommerce_before_shop_loop', array( $this, 'product_category_fillter'), 25);
	        }
		}

		public function product_per_page_query( $q ) {
			$default            = kera_tbay_get_config('number_products_per_page');
			$product_per_page   = kera_woocommerce_get_fillter('product_per_page',$default);
			if ( function_exists( 'woocommerce_products_will_display' ) && $q->is_main_query() ) :
				$q->set( 'posts_per_page', $product_per_page );
			endif;
		}
		public function product_type_query( $q ) {
	        $name = 'product_type';
	        $default = 'recent_products';

	        $product_type = kera_woocommerce_get_fillter($name, $default);
	        $args    = kera_woocommerce_meta_query($product_type);
	        $queries = array('meta_key', 'orderby', 'order', 'post__in', 'tax_query', 'meta_query');
	        if ( function_exists( 'woocommerce_products_will_display' ) && $q->is_main_query() ) :
	            foreach($queries as $query){
	                if(isset($args[$query])){
	                    $q->set( $query, $args[$query] );
	                }
	            }
	        endif;
		}
		
		public function product_category_query( $q ) {

			$default            = -1;
	        $product_cat        = kera_woocommerce_get_fillter('product_category',$default);


	        $tax_query = (array) $q->get( 'tax_query' );

	        $tax_query[] = array(
	                'posts_per_page' => -1,
	                'tax_query' => array(
	                    'relation' => 'AND',
	                    array(
	                        'taxonomy' => 'product_cat',
	                        'field' => 'slug',
	                        'terms' => $product_cat
	                    )
	                ),
	                'post_type' => 'product',
	                'orderby' => 'title,'
	        );


	        if ( function_exists( 'woocommerce_products_will_display' ) && $q->is_main_query() && $product_cat != -1 ) :
	           $q->set( 'tax_query', $tax_query );
	        endif;

		}

		public function ajax_load_more_grid_product() {
			// prepare our arguments for the query
	        $args = json_decode( stripslashes( $_POST['query'] ), true );
	     
	        // it is always better to use WP_Query but not here
	        query_posts( $args );

	        $list = 'grid';
	      
	        if( have_posts() ) :
	     
	            while( have_posts() ): the_post();
	     
	                wc_get_template( 'content-product.php', array('list' => $list));

	     
	            endwhile;
	     
	        endif;
	        die; // here we exit the script and even no wp_reset_postdata() required!
		}

		public function shop_product_top_archive() {
			if( !is_product() && !is_search() ){
	            $active = apply_filters( 'kera_sidebar_top_archive', 10,2 );
	            $active = ( is_search() ) ? false : $active; 
	            $sidebar_id = 'product-top-archive';

	            if( $active && is_active_sidebar($sidebar_id) ) { ?> 
	                <aside id="sidebar-top-archive" class="sidebar top-archive-content">
	                <?php dynamic_sidebar($sidebar_id); ?>
	            </aside>
	            <?php }
	        }
		}

		public function product_layout_style() {
	        $type_array   = apply_filters( 'kera_get_template_product', 10,1 );
	        $type = kera_tbay_get_config('product_layout_style', 'v1'); 

	        $type = (isset($_GET['product_layout_style'])) ? $_GET['product_layout_style'] : $type;
	        
	        if (!in_array( $type, $type_array)) $type = 'v1';
	  
	        if( apply_filters( 'kera_product_layout_mobile', wp_is_mobile() ) ) {
	            $type = 'v1';
	        }
	        

	        return $type;
		}

		public function ajax_load_more_list_product() {
	 		// prepare our arguments for the query
	        $args = json_decode( stripslashes( $_POST['query'] ), true );
	     
	        // it is always better to use WP_Query but not here
	        query_posts( $args );

	        $list = 'list'; 
	     
	        if( have_posts() ) :
	     
	            while( have_posts() ): the_post();
	     
	                wc_get_template( 'content-product.php', array('list' => $list));

	     
	            endwhile; 
	     
	        endif;
	        die; // here we exit the script and even no wp_reset_postdata() required!
		}

		public function show_product_subcategories( $loop_html = '' ) {
			if ( wc_get_loop_prop( 'is_shortcode' ) && ! WC_Template_Loader::in_content_filter() ) {
	            return $loop_html;
	        }

	        $display_type = woocommerce_get_loop_display_mode();

	        // If displaying categories, append to the loop.
	        if ( 'subcategories' === $display_type || 'both' === $display_type ) {
	            ob_start();
	            woocommerce_output_product_categories( array(
	                'parent_id' => is_product_category() ? get_queried_object_id() : 0,
	            ) );
	            $loop_html .= ob_get_clean();

	            if ( 'subcategories' === $display_type ) {
	                wc_set_loop_prop( 'total', 0 );

	                // This removes pagination and products from display for themes not using wc_get_loop_prop in their product loops.  @todo Remove in future major version.
	                global $wp_query;

	                if ( $wp_query->is_main_query() ) {
	                    $wp_query->post_count    = 0;
	                    $wp_query->max_num_pages = 0;
	                }
	            }
	        }

	        return $loop_html;
		}

		public function sidebar_top_archive_active( $active ) {
	 		$active = kera_tbay_get_config('show_product_top_archive', false);

	        $active = (isset($_GET['product_top_archive'])) ? (boolean)$_GET['product_top_archive'] : (boolean)$active;

	        return $active;
		}

		public function title_product_archives_active( ) {
	 		$active = kera_tbay_get_config('title_product_archives', false);

	        $active = (isset($_GET['title_product_archives'])) ? (boolean)$_GET['title_product_archives'] : (boolean)$active;

	        return $active;
		}

		public function remove_title_product_archives_active() {
			$active = $this->title_product_archives_active();

	        $active = ( is_search() ) ? true : $active; 

	        return $active;
		}


		public function display_modes_active() {
	 		$active = kera_tbay_get_config('enable_display_mode', true);

	        $active = (isset($_GET['enable_display_mode'])) ? (boolean)$_GET['enable_display_mode'] : (boolean)$active;

	        return $active;
		}


		public function the_brands_the_name() {
			if( !kera_tbay_get_config('enable_brand', false) || !class_exists( 'YITH_WCBR' )) return;


            global $product;

            $terms = wp_get_post_terms($product->get_id(),'yith_product_brand');

            if( !is_array($terms) ) return;

            $brand = '<ul class="show-brand">';


            foreach ($terms as $term) {
                
                $name = $term->name;
                $url = get_term_link( $term->slug, 'yith_product_brand' );

                $brand  .= '<li><a href="'. esc_url($url) .'">'. esc_html($name) .'</a></li>';

            }
            
        	$brand  .= '</ul>';

	        echo  trim($brand);
		}

	}
endif;


if ( !function_exists('kera_shop_wooCommerce') ) {
	function kera_shop_wooCommerce() { 
		return Kera_Shop_WooCommerce::getInstance();
	}
	kera_shop_wooCommerce();
}