<?php


if (!function_exists('kera_tbay_get_products')) {
    function kera_tbay_get_products($categories = array(), $product_type = 'featured_product', $paged = 1, $post_per_page = -1, $orderby = '', $order = '', $offset  = 0)
    {
        global $woocommerce;
        $args = array(
            'post_type'      => 'product',
            'posts_per_page' => $post_per_page,
            'post_status'    => 'publish',
            'paged'          => $paged,
            'orderby'        => $orderby,
            'order'          => $order,
            'offset'         => $offset,
            'meta_query'     => WC()->query->get_meta_query(),
            'tax_query'      => WC()->query->get_tax_query(),
        );

        if (isset($args['orderby'])) {
            if ('price' == $args['orderby']) {
                $args = array_merge($args, array(
                    'meta_key'  => '_price',
                    'orderby'   => 'meta_value_num'
                ));
            }
            if ('featured' == $args['orderby']) {
                $args = array_merge($args, array(
                    'meta_key'  => '_featured',
                    'orderby'   => 'meta_value'
                ));
            }
            if ('sku' == $args['orderby']) {
                $args = array_merge($args, array(
                    'meta_key'  => '_sku',
                    'orderby'   => 'meta_value'
                ));
            }
        }

        if (!empty($categories) && is_array($categories)) {
            $args['tax_query']    = array(
                array(
                    'taxonomy'      => 'product_cat',
                    'field'         => 'slug',
                    'terms'         => $categories,
                    'operator'      => 'IN'
                )
            );
        }

        switch ($product_type) {
            case 'best_selling':
                $args['meta_key'] = 'total_sales';
                $args['orderby'] = 'meta_value_num';
                $args['ignore_sticky_posts']   = 1;
                $args['meta_query'] = array();
                $args['meta_query'][] = $woocommerce->query->stock_status_meta_query();
                $args['meta_query'][] = $woocommerce->query->visibility_meta_query();
                break;
            case 'featured_product':
                $args['ignore_sticky_posts']    = 1;
                $args['meta_query']             = array();
                $args['meta_query'][]           = $woocommerce->query->stock_status_meta_query();
                $args['meta_query'][]           = $woocommerce->query->visibility_meta_query();
                $args['tax_query'][]              = array(
                    array(
                        'taxonomy' => 'product_visibility',
                        'field'    => 'name',
                        'terms'    => 'featured',
                        'operator' => 'IN'
                    )
                );

                break;
            case 'top_rate':
                $args['meta_key']       = '_wc_average_rating';
                $args['orderby']        = 'meta_value_num';
                $args['order']          = 'DESC';
                $args['meta_query']     = array();
                $args['meta_query'][]   = WC()->query->get_meta_query();
                $args['tax_query'][]    = WC()->query->get_tax_query();
                break;

            case 'recent_product':
                $args['meta_query'] = array();
                $args['meta_query'][] = $woocommerce->query->stock_status_meta_query();
                break;
            case 'random_product':
                $args['orderby']    = 'rand';
                $args['meta_query'] = array();
                $args['meta_query'][] = $woocommerce->query->stock_status_meta_query();
                break;
            case 'deals':
                $product_ids_on_sale    = wc_get_product_ids_on_sale();
                $product_ids_on_sale[]  = 0;
                $args['post__in'] = $product_ids_on_sale;
                $args['meta_query'] = array();
                $args['meta_query'][] = $woocommerce->query->stock_status_meta_query();
                $args['meta_query'][] = $woocommerce->query->visibility_meta_query();
                $args['meta_query'][] =  array(
                    'relation' => 'AND',
                    array(
                        'relation' => 'OR',
                        array(
                            'key'           => '_sale_price',
                            'value'         => 0,
                            'compare'       => '>',
                            'type'          => 'numeric'
                        ),
                        array(
                            'key'           => '_min_variation_sale_price',
                            'value'         => 0,
                            'compare'       => '>',
                            'type'          => 'numeric'
                        ),
                    ),
                    array(
                        'key'           => '_sale_price_dates_to',
                        'value'         => time(),
                        'compare'       => '>',
                        'type'          => 'numeric'
                    ),
                );
                break;
            case 'on_sale':
                $product_ids_on_sale    = wc_get_product_ids_on_sale();
                $product_ids_on_sale[]  = 0;
                $args['post__in'] = $product_ids_on_sale;
                break;
        }

        if('yes' === get_option('woocommerce_hide_out_of_stock_items')) {
            $args['meta_query'][] =  array(
                'relation' => 'AND',
                array(
                    'key' => '_stock_status',
                    'value' => 'instock',
                    'compare' => '=',
                )
            );
        }

        $args['tax_query'][] = array(
            'relation' => 'AND',
            array(
               'taxonomy' =>   'product_visibility',
                'field'    =>   'slug',
                'terms'    =>   array('exclude-from-search', 'exclude-from-catalog'),
                'operator' =>   'NOT IN',
            )
        );

        return new WP_Query($args);
    }
}


if ( ! function_exists( 'kera_tbay_get_woocommerce_mini_cart' ) ) {
    function kera_tbay_get_woocommerce_mini_cart( $args = array() ) {

        $args = wp_parse_args(
            $args,
            array(
                'icon_array'                    => [
                    'has_svg' => false,
                    'iconClass' => 'icon- icon-handbag',
                ],
                'show_title_mini_cart'          => '',
                'title_mini_cart'               => esc_html__('Shopping cart', 'kera'),
                'title_dropdown_mini_cart'      => esc_html__('Shopping cart', 'kera'),
                'price_mini_cart'               => '',
            )
        );

        $position = apply_filters('kera_cart_position', 10, 2);

        $mark = '';
        if(!empty($position)) {
            $mark = '-';
        }

        wc_get_template('cart/mini-cart-button'.$mark.$position.'.php', array('args' => $args)) ;
    }
}

// breadcrumb for woocommerce page
if (!function_exists('kera_tbay_woocommerce_breadcrumb_defaults')) {
    function kera_tbay_woocommerce_breadcrumb_defaults($args)
    {
        global $post;

        $breadcrumb_img = kera_tbay_get_config('woo_breadcrumb_image');
        $breadcrumb_color = kera_tbay_get_config('woo_breadcrumb_color');
        $style = array();
        $img = '';

        $sidebar_configs = kera_tbay_get_woocommerce_layout_configs();


        $breadcrumbs_layout = kera_tbay_get_config('product_breadcrumb_layout', 'color');


        if(isset($_GET['breadcrumbs_layout'])) {
            $breadcrumbs_layout = $_GET['breadcrumbs_layout'];
        }

        switch ($breadcrumbs_layout) {
            case 'image':
                $breadcrumbs_class = ' breadcrumbs-image';
                break;
            case 'color':
                $breadcrumbs_class = ' breadcrumbs-color';
                break;
            case 'text':
                $breadcrumbs_class = ' breadcrumbs-text';
                break;
            default:
                $breadcrumbs_class  = ' breadcrumbs-text';
        }

        if(isset($sidebar_configs['breadscrumb_class'])) {
            $breadcrumbs_class .= ' '.$sidebar_configs['breadscrumb_class'];
        }

        if(!is_page()) {
            $current_page = true;

            switch ($current_page) {
                case is_shop():
                    $page_id = wc_get_page_id('shop');
                    break;
                case is_checkout():
                case is_order_received_page():
                    $page_id = wc_get_page_id('checkout');
                    break;
                case is_edit_account_page():
                case is_add_payment_method_page():
                case is_lost_password_page():
                case is_account_page():
                case is_view_order_page():
                    $page_id = wc_get_page_id('myaccount');
                    break;

                default:
                    $page_id = $post->ID;
                    break;
            }
        } else {
            $page_id = $post->ID;
        }

        if (isset($breadcrumb_img['url']) && !empty($breadcrumb_img['url']) && $breadcrumbs_layout !== 'color' && $breadcrumbs_layout !== 'text') {
            $img = '<img src="'.esc_url($breadcrumb_img['url']).'">';
        }

        if($breadcrumb_color && $breadcrumbs_layout !== 'image') {
            $style[] = 'background-color:'.$breadcrumb_color;
        }

        $estyle = (!empty($style) && $breadcrumbs_layout !== 'text') ? ' style="'.implode(";", $style).'"' : "";

        $title = $nav = '';

        if($breadcrumbs_layout == 'image') {

            if(is_shop()) {
                $title = '<h1 class="page-title-main">'. get_the_title($page_id) .'</h1>';
            } elseif(is_archive()) {
                $title = '<h1 class="page-title-main">'. get_the_archive_title() .'</h1>';
            } else {
                $title = '<h1 class="page-title-main">'. get_the_title($page_id) .'</h1>';
            }

        } else {
            $nav = Kera_WooCommerce()->get_product_page_title();

            $breadcrumbs_class .= ' active-nav-icon';
        }

        $args['wrap_before'] = '<section id="tbay-breadscrumb" '.$estyle.' class="tbay-breadscrumb '.esc_attr($breadcrumbs_class).'">'.$img.'<div class="container"><div class="breadscrumb-inner">'. $title .'<ol class="tbay-woocommerce-breadcrumb breadcrumb">';
        $args['wrap_after'] = '</ol></div>'. $nav.'</div></section>';

        return $args;
    }
}

if (!function_exists('kera_remove_archive_title_prefix')) {
    function kera_remove_archive_title_prefix($prefix)
    {
        $prefix = '';
        return $prefix;
    }
    add_filter('get_the_archive_title_prefix', 'kera_remove_archive_title_prefix');
}

if (!function_exists('kera_tbay_woocommerce_get_cookie_display_mode')) {
    function kera_tbay_woocommerce_get_cookie_display_mode()
    {

        $woo_mode = kera_tbay_get_config('product_display_mode', 'grid');

        if(isset($_COOKIE['kera_display_mode']) && $_COOKIE['kera_display_mode'] == 'grid') {
            $woo_mode = 'grid';
        } elseif (isset($_COOKIE['kera_display_mode']) && $_COOKIE['kera_display_mode'] == 'grid2') {
            $woo_mode = 'grid2';
        } elseif(isset($_COOKIE['kera_display_mode']) && $_COOKIE['kera_display_mode'] == 'list') {
            $woo_mode = 'list';
        }

        return $woo_mode;
    }
}

if (!function_exists('kera_tbay_woocommerce_get_display_mode')) {
    function kera_tbay_woocommerce_get_display_mode()
    {

        $woo_mode = kera_tbay_woocommerce_get_cookie_display_mode();

        if(isset($_GET['display_mode']) && $_GET['display_mode'] == 'grid') {
            $woo_mode = 'grid';
        } elseif(isset($_GET['display_mode']) && $_GET['display_mode'] == 'list') {
            $woo_mode = 'list';
        }

        if(! is_shop() && ! is_product_taxonomy()) {
            $woo_mode = 'grid';
        }


        return $woo_mode;
    }
}


/*Check not child categories*/
if(!function_exists('kera_is_check_not_child_categories')) {
    function kera_is_check_not_child_categories()
    {

        if(is_product_category()) {

            $cat   = get_queried_object();
            $cat_id     = $cat->term_id;

            $args2 = array(
                'taxonomy'     => 'product_cat',
                'parent'       => $cat_id,
            );

            $sub_cats = get_categories($args2);
            if(!$sub_cats) {
                return true;
            }

        }

        return false;
    }
}

/*Check not product in categories*/
if(!function_exists('kera_is_check_hidden_filter')) {
    function kera_is_check_hidden_filter()
    {

        if(is_product_category()) {

            $checkchild_cat     =  kera_is_check_not_child_categories();

            if(!$checkchild_cat &&  'subcategories' === get_option('woocommerce_category_archive_display')) {
                return true;
            }
        }

        return false;
    }
}


// Two product thumbnail
if (!function_exists('kera_tbay_woocommerce_get_two_product_thumbnail')) {
    function kera_tbay_woocommerce_get_two_product_thumbnail()
    {
        global $post, $product, $woocommerce;

        $size = 'woocommerce_thumbnail';
        $placeholder = wc_get_image_size($size);
        $placeholder_width = $placeholder['width'];
        $placeholder_height = $placeholder['height'];
        $post_thumbnail_id =  $product->get_image_id();

        $output = '';
        $class = 'image-no-effect';
        if (has_post_thumbnail()) {
            $attachment_ids = $product->get_gallery_image_ids();

            $class = ($attachment_ids && isset($attachment_ids[0])) ? 'attachment-shop_catalog image-effect' : $class;

            $output .= wp_get_attachment_image($post_thumbnail_id, $size, false, array('class' => $class ));

            if ($attachment_ids && isset($attachment_ids[0])) {
                $output .= wp_get_attachment_image($attachment_ids[0], $size, false, array('class' => 'image-hover' ));
            }

        } else {
            $output .= '<img src="'.wc_placeholder_img_src().'" alt="'.esc_attr__('Placeholder', 'kera').'" class="'. esc_attr($class) .'" width="'. esc_attr($placeholder_width) .'" height="'. esc_attr($placeholder_height) .'" />';
        }
        return trim($output);
    }
}

if ( ! function_exists( 'kera_tbay_woocommerce_get_silder_product_thumbnail' ) ) {
    function kera_tbay_woocommerce_get_silder_product_thumbnail() {
        global $product;

        wp_enqueue_script( 'slick' );
        wp_enqueue_script( 'kera-custom-slick' );

        $size = 'woocommerce_thumbnail';
        $placeholder = wc_get_image_size( $size );
        $cache_key = 'kera_product_gallery_' . $product->get_id();
        $output = get_transient( $cache_key );

        if ( !$output ) {
            $post_thumbnail_id = $product->get_image_id();
            $attachment_ids = $product->get_gallery_image_ids();

            ob_start();
            wc_get_template( 'custom/product-slider-gallery.php', array(
                'post_thumbnail_id' => $post_thumbnail_id,
                'attachment_ids'    => $attachment_ids,
                'size'              => $size,
                'placeholder'       => $placeholder,
            ) );
            $output = ob_get_clean();

            set_transient( $cache_key, $output, HOUR_IN_SECONDS );
        }

        return trim( $output );
    }
}

if (!function_exists('kera_product_block_image_class')) {
    function kera_product_block_image_class($class = '')
    {
        $images_mode   = apply_filters('kera_woo_display_image_mode', 10, 2);

        if($images_mode !=  'slider') {
            return;
        }
        $class = ' has-slider-gallery';

        echo trim($class);
    }
}

if (!function_exists('kera_slick_carousel_product_block_image_class')) {
    function kera_slick_carousel_product_block_image_class($class = '')
    {
        $images_mode   = apply_filters('kera_woo_display_image_mode', 10, 2);

        if($images_mode !=  'slider') {
            return;
        }
        $class = ' slick-has-slider-gallery';

        echo trim($class);
    }
}


if (!function_exists('kera_tbay_product_class')) {
    function kera_tbay_product_class($class = array())
    {
        global $product;

        $class_array    = array();

        $type           = apply_filters('kera_woo_config_product_layout', 10, 2);
        $class_varible  = kera_is_product_variable_sale();

        $class    = trim(join(' ', $class));
        if(!is_array($class)) {
            $class = explode(" ", $class);
        }

        array_push($class_array, "product-block", "grid", "product", $type, $class_varible);

        $class_array    = array_merge($class_array, $class);

        $class_array    = trim(join(' ', $class_array));

        echo 'class="' . esc_attr($class_array) . '"';
    }
}



if(! function_exists('kera_has_swatch')) {
    function kera_has_swatch($id, $attr_name, $value)
    {
        $swatches = array();

        $color = $image = $button = '';

        $term = get_term_by('slug', $value, $attr_name);
        if (is_object($term)) {
            $color      =   sanitize_hex_color(get_term_meta($term->term_id, 'product_attribute_color', true));
            $image      =   get_term_meta($term->term_id, 'product_attribute_image', true);
            $button      =   $term->name;
        }

        if($color != '') {
            $swatches['color']  = $color;
            $swatches['type']   = 'color';
        } elseif($image != '') {
            $swatches['image']  = $image;
            $swatches['type']   = 'image';
        } else {
            $swatches['button'] = $button;
            $swatches['type']   = 'button';
        }

        return $swatches;
    }
}


if(! function_exists('kera_get_option_variations')) {
    function kera_get_option_variations($attribute_name, $available_variations, $option = false, $product_id = false)
    {
        $swatches_to_show = array();
        foreach ($available_variations as $key => $variation) {
            $option_variation = array();
            $attr_key = 'attribute_' . $attribute_name;
            if(! isset($variation['attributes'][$attr_key])) {
                return;
            }

            $val = $variation['attributes'][$attr_key]; // red green black ..

            if(! empty($variation['image']['thumb_src'])) {
                $option_variation = array(
                    'variation_id' => $variation['variation_id'],
                    'image_src' => $variation['image']['thumb_src'],
                    'image_srcset' => $variation['image']['srcset'],
                    'image_sizes' => $variation['image']['sizes'],
                    'is_in_stock' => $variation['is_in_stock'],
                );
            }

            // Get only one variation by attribute option value
            if($option) {
                if($val != $option) {
                    continue;
                } else {
                    return $option_variation;
                }
            } else {
                // Or get all variations with swatches to show by attribute name

                $swatch = kera_has_swatch($product_id, $attribute_name, $val);
                $swatches_to_show[$val] = array_merge($swatch, $option_variation);

            }

        }

        return $swatches_to_show;

    }
}

/**
 * ------------------------------------------------------------------------------------------------
 * Show attribute swatches list
 * ------------------------------------------------------------------------------------------------
 */
if ( ! function_exists( 'kera_swatches_list' ) ) {
    function kera_swatches_list( $attribute_name = false ) {
        global $product;
        $id = $product->get_id();
        if ( empty( $id ) || ! $product->is_type( 'variable' ) ) {
            return false;
        }

        $attribute_name = $attribute_name ? sanitize_key( $attribute_name ) : kera_get_swatches_attribute();
        if ( empty( $attribute_name ) ) {
            return false;
        }

        $cache_key = 'kera_swatches_' . $id . '_' . $attribute_name;
        $output = get_transient( $cache_key );
        if ( false === $output ) {
            $available_variations = $product->get_available_variations();
            if ( empty( $available_variations ) ) {
                return false;
            }

            $swatches_to_show = kera_get_option_variations( $attribute_name, $available_variations, false, $id );
            if ( empty( $swatches_to_show ) ) {
                return false;
            }

            $terms = wc_get_product_terms( $id, $attribute_name, array( 'fields' => 'slugs' ) );
            $swatches_to_show = array_intersect_key( $swatches_to_show, array_flip( $terms ) );

            ob_start();
            wc_get_template( 'custom/swatches-list.php', array(
                'attribute_name'    => $attribute_name,
                'swatches_to_show'  => $swatches_to_show,
            ) );
            $output = ob_get_clean();

            set_transient( $cache_key, $output, HOUR_IN_SECONDS );
        }

        return $output;
    }
}

if (! function_exists('kera_tbay_woocommerce_variable')) {

    /**
     * Output the variable product add to cart area.
     *
     * @subpackage  Product
     */
    function kera_tbay_woocommerce_variable()
    {
        global $product;

        $active = apply_filters('kera_enable_variation_selector', 10, 2);

        if($product->is_type('variable')  && class_exists('Woo_Variation_Swatches') && $active) {

            ?>

            <?php echo kera_swatches_list() ?>

            <?php

        }
    }
    add_action('woocommerce_after_shop_loop_item_title', 'kera_tbay_woocommerce_variable', 15);
}
if(! function_exists('kera_get_swatches_attribute')) {
    function kera_get_swatches_attribute()
    {
        $custom = get_post_meta(get_the_ID(), '_kera_attribute_select', true);

        return empty($custom) ? kera_tbay_get_config('variation_swatch') : $custom;
    }
}


// get layout configs
if (!function_exists('kera_tbay_get_woocommerce_layout_configs')) {
    function kera_tbay_get_woocommerce_layout_configs()
    {

        if(!is_product()) {
            $page = 'product_archive_sidebar';
        } else {
            $page = 'product_single_sidebar';
        }

        $sidebar = kera_tbay_get_config($page);


        if (!is_singular('product')) {

            $product_archive_layout  =   (isset($_GET['product_archive_layout'])) ? $_GET['product_archive_layout'] : kera_tbay_get_config('product_archive_layout', 'shop-left');

            if(kera_woo_is_wcmp_vendor_store()) {
                $sidebar = 'wc-marketplace-store';

                if(!is_active_sidebar($sidebar)) {
                    $configs['main'] = array( 'class' => 'archive-full' );
                }
            }

            if(isset($product_archive_layout)) {
                switch ($product_archive_layout) {
                    case 'shop-left':
                        $configs['sidebar'] = array( 'id'  => $sidebar, 'class' => 'col-12 col-xl-3'  );
                        $configs['main']    = array( 'class'    => 'col-12 col-xl-9' );
                        break;
                    case 'shop-right':
                        $configs['sidebar'] = array( 'id' => $sidebar,  'class' => 'col-12 col-xl-3' );
                        $configs['main']    = array( 'class'    => 'col-12 col-xl-9' );
                        break;
                    default:
                        $configs['main'] = array( 'class' => 'archive-full' );
                        break;
                }

                if(($product_archive_layout === 'shop-left' ||  $product_archive_layout === 'shop-right') && (empty($configs['sidebar']['id']) || !is_active_sidebar($configs['sidebar']['id']))) {
                    $configs['main'] = array( 'class' => 'archive-full' );
                }
            }
        } else {

            $product_single_layout  =   (isset($_GET['product_single_layout'])) ? $_GET['product_single_layout'] : kera_get_single_select_layout();
            $class_main = '';
            $class_sidebar = '';
            if ($product_single_layout == 'left-main' || $product_single_layout == 'main-right') {

                $class_main = 'col-12 col-xl-9';
                $class_sidebar = 'col-12 col-xl-3';

                $sidebar = kera_tbay_get_config('product_single_sidebar', 'product-single');
            }
            if(isset($product_single_layout)) {
                switch ($product_single_layout) {
                    case 'vertical':
                        $configs['main']            = array( 'class' => 'archive-full' );
                        $configs['thumbnail']       = 'vertical';
                        $configs['breadscrumb']     = 'color';
                        break;
                    case 'horizontal':
                        $configs['main']            = array( 'class' => 'archive-full' );
                        $configs['thumbnail']       = 'horizontal';
                        $configs['breadscrumb']     = 'color';
                        break;
                    case 'left-main':
                        $configs['sidebar']         = array( 'id'  => $sidebar, 'class' => $class_sidebar  );
                        $configs['main']            = array( 'class' => $class_main );
                        $configs['thumbnail']       = 'horizontal';
                        $configs['breadscrumb']     = 'color';
                        break;
                    case 'main-right':
                        $configs['sidebar']         = array( 'id'  => $sidebar, 'class' => $class_sidebar  );
                        $configs['main']            = array( 'class' => $class_main );
                        $configs['thumbnail']       = 'horizontal';
                        $configs['breadscrumb']     = 'color';
                        break;
                    default:
                        $configs['main']            = array( 'class' => 'archive-full' );
                        $configs['thumbnail']       = 'horizontal';
                        $configs['breadscrumb']     = 'color';
                        break;
                }

                if(($product_single_layout === 'left-main' ||  $product_single_layout === 'main-right') && (empty($configs['sidebar']['id']) || !is_active_sidebar($configs['sidebar']['id']))) {
                    $configs['main'] = array( 'class' => 'archive-full' );
                }

            }

        }

        return $configs;
    }
}

if (!function_exists('kera_class_wrapper_start')) {
    function kera_class_wrapper_start()
    {

        $configs['content']                 = 'content';
        $configs['main']                    = 'main-wrapper ';

        $sidebar_configs                    = kera_tbay_get_woocommerce_layout_configs();
        $configs['content']                 = kera_add_cssclass($configs['content'], $sidebar_configs['main']['class']);

        if(!is_product()) {
            $configs['content']  = kera_add_cssclass($configs['content'], 'archive-shop');
            $class_main         =  (isset($_GET['product_archive_layout'])) ? $_GET['product_archive_layout'] : kera_tbay_get_config('product_archive_layout', 'shop-left');


            $configs['main']  = kera_add_cssclass($configs['main'], $class_main);
        } elseif(is_product()) {

            $configs['content']  = kera_add_cssclass($configs['content'], 'singular-shop');

            $class_main         =  (isset($_GET['product_single_layout'])) ? $_GET['product_single_layout'] : kera_tbay_get_config('product_single_layout', 'horizontal');


            $configs['main']  = kera_add_cssclass($configs['main'], $class_main);
        }

        return $configs;
    }
}

if (! function_exists('kera_woocommerce_meta_query')) {
    function kera_woocommerce_meta_query($type)
    {
        global $woocommerce;

        $args = array();
        switch ($type) {

            case 'best_selling':
                $args['meta_key'] = 'total_sales';
                $args['order']    = 'DESC';
                $args['orderby']  = 'meta_value_num';
                break;

            case 'featured_product':
                $args['ignore_sticky_posts']    = 1;
                $args['meta_query']             = array();
                $args['meta_query'][]           = $woocommerce->query->stock_status_meta_query();
                $args['meta_query'][]           = $woocommerce->query->visibility_meta_query();
                $args['tax_query'][]            = array(
                    array(
                        'taxonomy' => 'product_visibility',
                        'field'    => 'name',
                        'terms'    => 'featured',
                        'operator' => 'IN'
                    )
                );
                break;

            case 'top_rate':
                $args['meta_query']     = WC()->query->get_meta_query();
                $args['tax_query']      = WC()->query->get_tax_query();
                $args['meta_key']       = '_wc_average_rating';
                $args['orderby']        = 'meta_value_num';
                $args['order']          = 'DESC';
                break;

            case 'newest':
            case 'recent_product':
                $args['orderby']    = 'date';
                $args['order']      =  'DESC';
                $args['meta_query'] = array();
                $args['meta_query'][] = $woocommerce->query->stock_status_meta_query();
                break;

            case 'random_product':
                $args['orderby']        = 'rand';
                $args['meta_query']     = array();
                $args['meta_query'][] = $woocommerce->query->stock_status_meta_query();
                break;

            case 'on_sale':
                $args['meta_query'][]   = $woocommerce->query->stock_status_meta_query();
                $args['meta_query'][]   = $woocommerce->query->visibility_meta_query();
                $args['post__in']       = array_merge(array( 0 ), wc_get_product_ids_on_sale());
                break;

        }

        if('yes' === get_option('woocommerce_hide_out_of_stock_items')) {
            $args['meta_query'][] =  array(
                'relation' => 'AND',
                array(
                    'key' => '_stock_status',
                    'value' => 'instock',
                    'compare' => '=',
                )
            );
        }

        $product_visibility_term_ids = wc_get_product_visibility_term_ids();
        $args[ 'tax_query' ]         = isset($args[ 'tax_query' ]) ? $args[ 'tax_query' ] : array();
        $args[ 'tax_query' ][]       = array(
            'taxonomy' => 'product_visibility',
            'field'    => 'term_taxonomy_id',
            'terms'    => is_search() ? $product_visibility_term_ids[ 'exclude-from-search' ] : $product_visibility_term_ids[ 'exclude-from-catalog' ],
            'operator' => 'NOT IN',
        );

        return $args;
    }
}

if ( ! function_exists( 'kera_woocommerce_product_fillter' ) ) {
    function kera_woocommerce_product_fillter( $options, $name, $default, $class = 'level-0' ) {
        if ( ! woocommerce_products_will_display() ) {
            return;
        }
        $name = sanitize_key( $name );
        ?>
        <form method="get" class="woocommerce-fillter">
            <select name="<?php echo esc_attr( $name ); ?>" onchange="this.form.submit()" class="select">
                <?php
                $i = 0;
                foreach ( $options as $key => $value ) : ?>
                    <option class="<?php echo esc_attr( $class[ $i ] ?? '' ); ?>" value="<?php echo esc_attr( $key ); ?>" <?php selected( $key, kera_woocommerce_get_fillter( $name, $default ) ); ?>><?php echo esc_html( $value ); ?></option>
                    <?php $i++; ?>
                <?php endforeach; ?>
            </select>
            <?php
            foreach ( $_GET as $key => $val ) {
                if ( $name === $key || 'submit' === $key ) {
                    continue;
                }
                if ( is_array( $val ) ) {
                    foreach ( $val as $inner_val ) {
                        echo '<input type="hidden" name="' . esc_attr( sanitize_key( $key ) ) . '[]" value="' . esc_attr( sanitize_text_field( $inner_val ) ) . '" />';
                    }
                } else {
                    echo '<input type="hidden" name="' . esc_attr( sanitize_key( $key ) ) . '" value="' . esc_attr( sanitize_text_field( $val ) ) . '" />';
                }
            }
            ?>
        </form>
        <?php
    }
}

//get value fillter
if (! function_exists('kera_woocommerce_get_fillter')) {
    function kera_woocommerce_get_fillter($name, $default)
    {

        if (isset($_GET[$name])) :
            return $_GET[$name];
        else :
            return $default;
        endif;
    }
}

if ( ! function_exists( 'kera_get_product_count_of_category' ) ) {
    function kera_get_product_count_of_category( $cat_id ) {
        $term = get_term( $cat_id, 'product_cat' );
        $count = $term ? $term->count : 0;
        return $count;
    }
}

//Count product of tag
if ( ! function_exists( 'kera_get_product_count_of_tags' ) ) {
    function kera_get_product_count_of_tags( $tag_id ) {
        $term = get_term( $tag_id, 'product_tag' );
        $count = $term ? $term->count : 0;
        return $count;
    }
}

/*Remove filter*/
if (! function_exists('kera_woocommerce_sub_categories')) {
    /**
     * Output the start of a product loop. By default this is a UL.
     *
     * @param bool $echo Should echo?.
     * @return string
     */
    function kera_woocommerce_sub_categories($echo = true)
    {
        ob_start();

        wc_set_loop_prop('loop', 0);

        $loop_start = apply_filters('kera_woocommerce_sub_categories', ob_get_clean());

        if ($echo) {
            echo trim($loop_start); // WPCS: XSS ok.
        } else {
            return $loop_start;
        }
    }
}


if (! function_exists('kera_is_product_variable_sale')) {
    function kera_is_product_variable_sale()
    {

        global $product;

        $class =  '';
        if($product->is_type('variable') && $product->is_on_sale()) {
            $class = 'tbay-variable-sale';
        }

        return $class;
    }
}

if (! function_exists('kera_woo_content_class')) {
    function kera_woo_content_class($class = '')
    {
        $sidebar_configs = kera_tbay_get_woocommerce_layout_configs();

        if(!(isset($sidebar_configs['right']) && is_active_sidebar($sidebar_configs['right']['sidebar'])) && !(isset($sidebar_configs['left']) && is_active_sidebar($sidebar_configs['left']['sidebar']))) {
            $class .= ' col-12';
        }

        return $class;
    }
}

if (! function_exists('kera_wc_wrapper_class')) {
    function kera_wc_wrapper_class($class = '')
    {

        $content_class = kera_woo_content_class($class);

        return apply_filters('kera_wc_wrapper_class', $content_class);
    }
}


if (!function_exists('kera_find_matching_product_variation')) {
    function kera_find_matching_product_variation($product, $attributes)
    {

        foreach($attributes as $key => $value) {
            if(strpos($key, 'attribute_') === 0) {
                continue;
            }

            unset($attributes[ $key ]);
            $attributes[ sprintf('attribute_%s', $key) ] = $value;
        }

        if(class_exists('WC_Data_Store')) {

            $data_store = WC_Data_Store::load('product');
            return $data_store->find_matching_product_variation($product, $attributes);

        } else {

            return $product->get_matching_variation($attributes);

        }

    }
}

if (! function_exists('kera_get_default_attributes')) {
    function kera_get_default_attributes($product)
    {

        if(method_exists($product, 'get_default_attributes')) {

            return $product->get_default_attributes();

        } else {

            return $product->get_variation_default_attributes();

        }

    }
}

/**
 * ------------------------------------------------------------------------------------------------
 * Compare button
 * ------------------------------------------------------------------------------------------------
 */
if (! function_exists('kera_the_yith_compare')) {
    function kera_the_yith_compare($product_id)
    {
        if (class_exists('YITH_Woocompare_Frontend')) { 
            ?>
            <div class="yith-compare">

                <?php do_action('kera_before_add_to_compare_button'); ?>

            </div>
        <?php }
        }
}

if (! function_exists('kera_remove_compare_button_from_loop')) {
    add_action( 'init', 'kera_remove_compare_button_from_loop', 20 );
    function kera_remove_compare_button_from_loop() {
        if ( class_exists( 'YITH_Woocompare_Frontend' ) ) {
            $frontend = new YITH_WooCompare_Frontend();
            global $yith_woocompare;
            
            remove_action( 'woocommerce_after_shop_loop_item', array( $yith_woocompare->obj, 'output_button' ), 20 );
            add_action( 'kera_before_add_to_compare_button', array( $frontend, 'output_button' ), 10 );
        }
    }
}

/**
 * ------------------------------------------------------------------------------------------------
 * WishList button
 * ------------------------------------------------------------------------------------------------
 */

if(! function_exists('kera_the_yith_wishlist')) {
    function kera_the_yith_wishlist()
    {

        if(!class_exists('YITH_WCWL_Shortcode')) {
            return;
        }

        $active         = kera_tbay_get_config('enable_wishlist_mobile', false);

        $class_mobile   = ($active) ? 'shown-mobile' : '';

        echo '<div class="button-wishlist '. esc_attr($class_mobile) .'" title="'. esc_attr__('Wishlist', 'kera') . '">'.YITH_WCWL_Shortcode::add_to_wishlist(array()).'</div>';
    }
}

/**
 * ------------------------------------------------------------------------------------------------
 * The Flash Sale
 * ------------------------------------------------------------------------------------------------
 */

if(! function_exists('kera_tbay_class_flash_sale')) {
    function kera_tbay_class_flash_sale($flash_sales)
    {
        global $product;

        if(isset($flash_sales) && $flash_sales) {
            $class_sale    = (!$product->is_on_sale()) ? 'tbay-not-flash-sale' : '';
            return $class_sale;
        }

    }
}

/**
 * ------------------------------------------------------------------------------------------------
 * The Item Deal ended Flash Sale
 * ------------------------------------------------------------------------------------------------
 */

if(! function_exists('kera_tbay_item_deal_ended_flash_sale')) {
    function kera_tbay_item_deal_ended_flash_sale($flash_sales, $end_date)
    {
        global $product;

        $today      = strtotime("today");


        if($today > $end_date) {
            return;
        }

        $output = '';
        if(isset($flash_sales) && $flash_sales && !$product->is_on_sale()) {

            $output .= '<div class="item-deal-ended">';
            $output .= '<span>'. esc_html__('Deal ended', 'kera') .'</span>';
            $output .= '</div>';

        }
        echo trim($output);
    }
}


/**
 * ------------------------------------------------------------------------------------------------
 * The Count Down Flash Sale
 * ------------------------------------------------------------------------------------------------
 */

if(!function_exists('kera_tbay_countdown_flash_sale')) {
    function kera_tbay_countdown_flash_sale($time_sale = '', $date_title = '', $date_title_ended = '', $strtotime = false)
    {
        wp_enqueue_script('jquery-countdowntimer');
        $_id        = kera_tbay_random_key();

        $today      = strtotime("today");


        if($strtotime) {
            $time_sale = strtotime($time_sale);
        }

        ?>
        <?php if(!empty($time_sale)) : ?>
            <div class="flash-sales-date">
            <?php if (($today <= $time_sale)): ?>
                    <div class="time">
                        <div class="tbay-countdown" id="tbay-flash-sale-<?php echo esc_attr($_id);?>" data-time="timmer"
                             data-date="<?php echo date('m', $time_sale).'-'.date('d', $time_sale).'-'.date('Y', $time_sale).'-'. date('H', $time_sale) . '-' . date('i', $time_sale) . '-' .  date('s', $time_sale) ; ?>">
                        </div>
                    </div> 
                    <?php if(isset($date_title) && !empty($date_title)) :  ?>
                        <div class="date-title"><?php echo trim($date_title); ?></div>
                    <?php endif; ?>
            <?php else: ?>
                <?php if(isset($date_title_ended) && !empty($date_title_ended)) :  ?>
                    <div class="date-title"><?php echo trim($date_title_ended); ?></div>
                <?php endif; ?>
            <?php endif; ?> 
            </div> 
        <?php endif; ?> 
        <?php
    }
}

/**
 * ------------------------------------------------------------------------------------------------
 * The Count Down Flash Sale
 * ------------------------------------------------------------------------------------------------
 */

if(!function_exists('kera_tbay_stock_flash_sale')) {
    function kera_tbay_stock_flash_sale($flash_sales = '')
    {
        global $product;

        if($flash_sales && $product->get_manage_stock()) : ?>
            <div class="stock-flash-sale stock">
                <?php
                $total_sales        = $product->get_total_sales();
            $stock_quantity     = $product->get_stock_quantity();

            $total_quantity   = (int)$total_sales + (int)$stock_quantity;

            $divi_total_quantity = ($total_quantity !== 0) ? $total_quantity : 1;

            $sold             = (int)$total_sales / (int)$divi_total_quantity;
            $percentsold      = $sold * 100;

            ?>
                <div class="progress">
                    <div class="progress-bar active" role="progressbar" aria-valuenow="80" aria-valuemin="0" aria-valuemax="100" style="width: <?php echo esc_attr($percentsold); ?>%">
                    </div>
                </div>
                <span class="tb-sold"><?php esc_html_e('Sold', 'kera'); ?> : <span class="sold"><?php echo esc_html($total_sales) ?></span><span class="total">/<?php echo esc_html($total_quantity) ?></span></span>
            </div>
        <?php endif;
    }
}


/**
 * ------------------------------------------------------------------------------------------------
 * QuickView button
 * ------------------------------------------------------------------------------------------------
 */
if (! function_exists('kera_the_quick_view')) {
    function kera_the_quick_view($product_id)
    {

        if (kera_tbay_get_config('enable_quickview', false)) {
            wp_enqueue_script('slick');
            wp_enqueue_script('kera-custom-slick');
            ?>
            <div class="tbay-quick-view">
                <a href="#" class="qview-button" title ="<?php esc_attr_e('Quick View', 'kera') ?>" data-effect="mfp-move-from-top" data-product_id="<?php echo esc_attr($product_id); ?>" data-toggle="modal" data-target="#tbay-quickview-modal">
                    <i class="icon-eye"></i>
                    <span><?php esc_html_e('Quick View', 'kera') ?></span>
                </a>
            </div>
            <?php

        }
    }
}


/**
 * ------------------------------------------------------------------------------------------------
 * Product name
 * ------------------------------------------------------------------------------------------------
 */

if(! function_exists('kera_the_product_name')) {
    function kera_the_product_name()
    {

        $active         = kera_tbay_get_config('enable_one_name_mobile', false);

        $class_mobile   = ($active) ? 'full_name' : '';

        do_action('woocommerce_shop_loop_item_title');
        ?>
        <h3 class="name <?php echo esc_attr($class_mobile); ?>"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
        <?php
    }
}

if (! function_exists('kera_woo_is_wcmp_vendor_store')) {
    function kera_woo_is_wcmp_vendor_store()
    {

        if (! class_exists('WCMp')) {
            return false;
        }

        global $WCMp;
        if (empty($WCMp)) {
            return false;
        }

        if (is_tax($WCMp->taxonomy->taxonomy_name)) {
            return true;
        }

        return false;
    }
}



/**
 * Check is vendor page
 *
 * @return bool
 */
if (! function_exists('kera_woo_is_vendor_page')) {
    function kera_woo_is_vendor_page()
    {

        if (function_exists('dokan_is_store_page') && dokan_is_store_page()) {
            return true;
        }

        if (class_exists('WCV_Vendors') && method_exists('WCV_Vendors', 'is_vendor_page')) {
            return WCV_Vendors::is_vendor_page();
        }

        if (kera_woo_is_wcmp_vendor_store()) {
            return true;
        }

        if (function_exists('wcfm_is_store_page') && wcfm_is_store_page()) {
            return true;
        }

        return false;
    }
}


if (! function_exists('kera_custom_product_get_rating_html')) {
    function kera_custom_product_get_rating_html($html, $rating, $count)
    {
        global $product;

        $output = '';

        $review_count = $product->get_review_count();

        if(empty($review_count)) {
            $review_count = 0;
        }

        $class = (empty($review_count)) ? 'no-rate' : '';

        $output .= '<div class="rating '. esc_attr($class) .'">';
        $output .= $html;
        $output .= '<div class="count"><span>'. $review_count .'</span></div>';
        $output .= '</div>';

        echo trim($output);

    }
}


/**
 * ------------------------------------------------------------------------------------------------
 * Mini cart Button
 * ------------------------------------------------------------------------------------------------
 */
if (!function_exists('kera_tbay_minicart_button')) {
    function kera_tbay_minicart_button($icon, $enable_text, $text, $enable_price)
    {
        global $woocommerce;
        ?>

        <span class="cart-icon">

            <?php if($icon['has_svg']) : ?>
                <?php echo trim($icon['svg']); ?>
            <?php else: ?>
                <i class="<?php echo esc_attr($icon['iconClass']); ?>"></i>
            <?php endif; ?>
            <span class="mini-cart-items">
               <?php echo sprintf('%d', $woocommerce->cart->cart_contents_count);?>
            </span>
        </span>

        <?php if((($enable_text === 'yes') && !empty($text)) || ($enable_price === 'yes')) { ?>
            <span class="text-cart">

            <?php if(($enable_text === 'yes') && !empty($text)) : ?>
                <span><?php echo trim($text); ?></span>
            <?php endif; ?>

            <?php if($enable_price === 'yes') : ?>
                <span class="subtotal"><?php echo WC()->cart->get_cart_subtotal();?></span>
            <?php endif; ?>

        </span>

        <?php }
        }
}

/*product time countdown*/
if(!function_exists('kera_woo_product_time_countdown')) {
    function kera_woo_product_time_countdown($countdown = false, $countdown_title = '')
    {
        global $product;

        if(!$countdown) {
            return;
        }

        wp_enqueue_script('jquery-countdowntimer');
        $time_sale = get_post_meta($product->get_id(), '_sale_price_dates_to', true);
        $_id = kera_tbay_random_key();
        $day        = apply_filters('kera_single_time_countdown_day', esc_html__('d', 'kera'));
        $hours      = apply_filters('kera_single_time_countdown_hour', esc_html__('h', 'kera'));
        $mins       = apply_filters('kera_single_time_countdown_mins', esc_html__('m', 'kera'));
        $secs       = apply_filters('kera_single_time_countdown_secs', esc_html__('s', 'kera'));
        ?>
        <?php if ($time_sale): ?>
            <div class="time">
                <div class="timming">
                    <?php if(isset($countdown_title) && !empty($countdown_title)) :  ?>
                    <div class="date-title"><?php echo trim($countdown_title); ?></div>
                    <?php endif; ?>
                    <div class="tbay-countdown" id="tbay-flash-sale-<?php echo esc_attr($_id);?>" data-time="timmer" data-date="<?php echo date('m', $time_sale).'-'.date('d', $time_sale).'-'.date('Y', $time_sale).'-'. date('H', $time_sale) . '-' . date('i', $time_sale) . '-' .  date('s', $time_sale) ; ?>" data-days="<?php echo esc_attr($day); ?>" data-hours="<?php echo esc_attr($hours); ?>" data-mins="<?php echo esc_attr($mins); ?>" data-secs="<?php echo esc_attr($secs); ?>"></div>
                </div>
            </div> 
        <?php endif; ?> 
        <?php
    }
}
if(!function_exists('kera_woo_product_time_countdown_stock')) {
    function kera_woo_product_time_countdown_stock($countdown = false)
    {
        global $product;
        if(!$countdown) {
            return;
        }

        if($product->get_manage_stock()) {?>
            <div class="stock">
                <?php
                    $total_sales    = $product->get_total_sales();
            $stock_quantity   = $product->get_stock_quantity();

            if($stock_quantity >= 0) {
                $total_quantity   = (int)$total_sales + (int)$stock_quantity;
                $sold         = (int)$total_sales / (int)$total_quantity;
                $percentsold    = $sold * 100;
            }
            ?>
              
                <?php if(isset($percentsold)) { ?>
                    <div class="progress">
                        <div class="progress-bar active" role="progressbar" aria-valuenow="80" aria-valuemin="0" aria-valuemax="100" style="width: <?php echo esc_attr($percentsold); ?>%">
                        </div>
                    </div>
                <?php } ?>
                <?php if($stock_quantity >= 0) { ?>
                    <span class="tb-sold"><?php esc_html_e('Sold', 'kera'); ?> : <span class="sold"><?php echo esc_html($total_sales) ?></span><span class="total">/<?php echo esc_html($total_quantity) ?></span></span>
                <?php } ?>
            </div>
        <?php }
        }
}

if(! function_exists('kera_get_single_select_layout')) {
    function kera_get_single_select_layout()
    {
        $custom = get_post_meta(get_the_ID(), '_kera_single_layout_select', true);

        return empty($custom) ? kera_tbay_get_config('product_single_layout') : $custom;
    }
}

if (!function_exists('kera_tbay_minicart')) {
    function kera_tbay_minicart()
    {
        $template = apply_filters('kera_tbay_minicart_version', '');
        get_template_part('woocommerce/cart/mini-cart-button', $template);
    }
}

if (! function_exists('kera_get_product_categories')) {
    function kera_get_product_categories()
    {
        $category = get_terms(
            array(
            'taxonomy'   => 'product_cat',
            'hide_empty' => false,
            )
        );
        $results = array();
        if (!is_wp_error($category)) {
            foreach ($category as $category) {
                $results[$category->slug] = $category->name.' ('.$category->count.') ';
            }
        }
        return $results;
    }
}

if(!function_exists('kera_get_thumbnail_gallery_item')) {
    function kera_get_thumbnail_gallery_item()
    {

        return apply_filters('kera_get_thumbnail_gallery_item', 'flex-control-nav.flex-control-thumbs li');
    }
}

if(!function_exists('kera_get_gallery_item_class')) {
    function kera_get_gallery_item_class()
    {

        return apply_filters('kera_get_gallery_item_class', "woocommerce-product-gallery__image");
    }
}

if (! function_exists('kera_video_type_by_url')) {
    /**
     * Retrieve the type of video, by url
     *
     * @param string $url The video's url
     *
     * @return mixed A string format like this: "type:ID". Return FALSE, if the url isn't a valid video url.
     *
     * @since 1.1.0
     */
    function kera_video_type_by_url($url)
    {

        $parsed = parse_url(esc_url($url));

        switch ($parsed['host']) {

            case 'www.youtube.com':
            case    'youtu.be':
                $id = kera_get_yt_video_id($url);

                return "youtube:$id";

            case 'vimeo.com':
            case 'player.vimeo.com':
                preg_match('/.*(vimeo\.com\/)((channels\/[A-z]+\/)|(groups\/[A-z]+\/videos\/))?([0-9]+)/', $url, $matches);
                $id = $matches[5];

                return "vimeo:$id";

            default:
                return apply_filters('kera_woocommerce_featured_video_type', false, $url);

        }
    }
}
if (! function_exists('kera_get_yt_video_id')) {
    /**
     * Retrieve the id video from youtube url
     *
     * @param string $url The video's url
     *
     * @return string The youtube id video
     *
     * @since 1.1.0
     */
    function kera_get_yt_video_id($url)
    {

        $pattern =
            '%^# Match any youtube URL
        (?:https?://)?  # Optional scheme. Either http or https
        (?:www\.)?      # Optional www subdomain
        (?:             # Group host alternatives
          youtu\.be/    # Either youtu.be,
        | youtube\.com  # or youtube.com
          (?:           # Group path alternatives
            /embed/     # Either /embed/
          | /v/         # or /v/
          | /watch\?v=  # or /watch\?v=
          )             # End path alternatives.
        )               # End host alternatives.
        ([\w-]{10,12})  # Allow 10-12 for 11 char youtube id.
        $%x';
        $result  = preg_match($pattern, $url, $matches);
        if (false !== $result) {
            return $matches[1];
        }

        return false;
    }
}

if (! function_exists('kera_get_product_menu_bar')) {
    function kera_get_product_menu_bar()
    {
        $menu_bar   = kera_tbay_get_config('enable_sticky_menu_bar', false);

        if (isset($_GET['sticky_menu_bar'])) {
            $menu_bar = $_GET['sticky_menu_bar'];
        }

        return $menu_bar;
    }
}



/** Ajax Elementor Addon kera Product Tabs **/
if ( ! function_exists( 'kera_get_products_tab_ajax' ) ) {
    function kera_get_products_tab_ajax() {
        check_ajax_referer( 'kera_products_tab', 'nonce' );
        if ( ! empty( $_POST['atts'] ) ) {
            $atts = wc_clean( $_POST['atts'] );
            $product_type = sanitize_text_field( $_POST['value'] );
            $atts['product_type'] = $product_type;

            $data = kera_elementor_products_ajax_template( $atts );
            wp_send_json( $data );
        }
        wp_die();
    }
    add_action( 'wp_ajax_kera_get_products_tab_shortcode', 'kera_get_products_tab_ajax' );
    add_action( 'wp_ajax_nopriv_kera_get_products_tab_shortcode', 'kera_get_products_tab_ajax' );
}

/** Ajax Elementor Addon Product Categories Tabs **/
if (! function_exists('kera_get_products_categories_tab_shortcode')) {
    function kera_get_products_categories_tab_shortcode()
    {
        if (! empty($_POST['atts'])) {

            $atts               = kera_clean($_POST['atts']);
            $categories         = kera_clean($_POST['value']);
            $atts['categories'] = $categories;

            $data = kera_elementor_products_ajax_template($atts);
            echo json_encode($data);
            die();
        }
    }
    add_action('wp_ajax_kera_get_products_categories_tab_shortcode', 'kera_get_products_categories_tab_shortcode');
    add_action('wp_ajax_nopriv_kera_get_products_categories_tab_shortcode', 'kera_get_products_categories_tab_shortcode');
}

if (! function_exists('kera_get_query_products')) {
    function kera_get_query_products($categories = array(), $cat_operator = 'IN', $product_type = 'newest', $limit = '', $orderby = '', $order = '')
    {
        $atts = [
            'limit' => $limit,
            'orderby' => $orderby,
            'order' => $order
        ];

        if (!empty($categories)) {
            if (!is_array($categories)) {
                $atts['category'] = $categories;
            } else {
                $atts['category'] = implode(', ', $categories);
                $atts['cat_operator'] = $cat_operator;
            }
        }

        $type = 'products';

        $shortcode = new WC_Shortcode_Products($atts, $type);
        $args = $shortcode->get_query_args();

        $args = kera_get_attribute_query_product_type($args, $product_type);
        return new WP_Query($args);
    }
}

if (! function_exists('kera_elementor_products_ajax_template')) {
    function kera_elementor_products_ajax_template($settings)
    {
        $cat_operator = 'IN';
        extract($settings);
        $loop = kera_get_query_products($categories, $cat_operator, $product_type, $limit, $orderby, $order);

        if (preg_match('/\\\\/m', $attr_row)) {
            $attr_row = preg_replace('/\\\\/m', '', $attr_row);
        }
        ob_start();

        if($loop->have_posts()) :

            wc_get_template('layout-products/layout-products.php', array( 'loop' => $loop, 'product_style' => $product_style, 'attr_row' => $attr_row));

        endif;

        wc_reset_loop();
        wp_reset_postdata();

        return [
            'html' => ob_get_clean(),
        ];
    }
}


if (! function_exists('kera_get_attribute_query_product_type')) {
    function kera_get_attribute_query_product_type($args, $product_type)
    {
        global $woocommerce;

        switch ($product_type) {
            case 'best_selling':
                $args['meta_key']   = 'total_sales';
                $args['order']          = 'desc';
                $args['orderby']    = 'meta_value_num';
                $args['ignore_sticky_posts']   = 1;
                $args['meta_query'] = array();
                $args['meta_query'][] = $woocommerce->query->stock_status_meta_query();
                $args['meta_query'][] = $woocommerce->query->visibility_meta_query();
                break;

            case 'featured':
                $args['ignore_sticky_posts']    = 1;
                $args['meta_query']             = array();
                $args['meta_query'][]           = $woocommerce->query->stock_status_meta_query();
                $args['meta_query'][]           = $woocommerce->query->visibility_meta_query();
                $args['tax_query'][]              = array(
                    array(
                        'taxonomy' => 'product_visibility',
                        'field'    => 'name',
                        'terms'    => 'featured',
                        'operator' => 'IN'
                    )
                );
                break;

            case 'top_rated':
                $args['meta_key']       = '_wc_average_rating';
                $args['orderby']        = 'meta_value_num';
                $args['order']          = 'desc';
                break;

            case 'newest':
                $args['meta_query'] = array();
                $args['meta_query'][] = $woocommerce->query->stock_status_meta_query();
                break;

            case 'random_product':
                $args['orderby']    = 'rand';
                $args['meta_query'] = array();
                $args['meta_query'][] = $woocommerce->query->stock_status_meta_query();
                break;

            case 'deals':
                $product_ids_on_sale    = wc_get_product_ids_on_sale();
                $product_ids_on_sale[]  = 0;
                $args['post__in'] = $product_ids_on_sale;
                $args['meta_query'] = array();
                $args['meta_query'][] = $woocommerce->query->stock_status_meta_query();
                $args['meta_query'][] = $woocommerce->query->visibility_meta_query();
                $args['meta_query'][] =  array(
                    'relation' => 'AND',
                    array(
                        'relation' => 'OR',
                        array(
                            'key'           => '_sale_price',
                            'value'         => 0,
                            'compare'       => '>',
                            'type'          => 'numeric'
                        ),
                        array(
                            'key'           => '_min_variation_sale_price',
                            'value'         => 0,
                            'compare'       => '>',
                            'type'          => 'numeric'
                        ),
                    ),
                    array(
                        'key'           => '_sale_price_dates_to',
                        'value'         => time(),
                        'compare'       => '>',
                        'type'          => 'numeric'
                    ),
                );
                break;

            case 'on_sale':
                $product_ids_on_sale    = wc_get_product_ids_on_sale();
                $product_ids_on_sale[]  = 0;
                $args['post__in'] = $product_ids_on_sale;
                break;
        }

        if('yes' === get_option('woocommerce_hide_out_of_stock_items')) {
            $args['meta_query'][] =  array(
                'relation' => 'AND',
                array(
                    'key' => '_stock_status',
                    'value' => 'instock',
                    'compare' => '=',
                )
            );
        }

        $product_visibility_term_ids = wc_get_product_visibility_term_ids();
        $args[ 'tax_query' ]         = isset($args[ 'tax_query' ]) ? $args[ 'tax_query' ] : array();
        $args[ 'tax_query' ][]       = array(
            'taxonomy' => 'product_visibility',
            'field'    => 'term_taxonomy_id',
            'terms'    => is_search() ? $product_visibility_term_ids[ 'exclude-from-search' ] : $product_visibility_term_ids[ 'exclude-from-catalog' ],
            'operator' => 'NOT IN',
        );

        return $args;
    }
}

if (!function_exists('kera_quick_view_view_details_btn')) {
    add_action('kera_woocommerce_after_product_thumbnails', 'kera_quick_view_view_details_btn', 10);
    function kera_quick_view_view_details_btn()
    {
        global $product;
        $permalink = $product->get_permalink();
        echo '<div class="details-btn-wrapper"><a class="view-details-btn" href="'. esc_url($permalink) .'">'. esc_html__('View details', 'kera') .'</a></div>';
    }
}

if (! function_exists('kera_is_variable_product_out_of_stock')) {
    function kera_is_variable_product_out_of_stock($product)
    {
        $children_count = 0; // initializing
        $variation_ids  = $product->get_visible_children();

        // Loop through children variations of the parent variable product
        foreach($variation_ids as $variation_id) {
            $variation = wc_get_product($variation_id); // Get the product variation Object

            if(! $variation->is_in_stock()) {
                $children_count++; // count out of stock children
            }
        }
        // Compare counts and return a boolean
        return count($variation_ids) == $children_count ? true : false;
    }
}

if (! function_exists('kera_woocommerce_single_title')) {
    function kera_woocommerce_single_title()
    {
        the_title('<h2 class="product_title entry-title">', '</h2>');
    }
}

/*Fix page search when product_cat emty WOOF  v3.3.4.3*/
if (! function_exists('kera_woo_fix_form_search_cate_empty_woof_new_version')) {
    add_action('admin_init', 'kera_woo_fix_form_search_cate_empty_woof_new_version', 99);
    function kera_woo_fix_form_search_cate_empty_woof_new_version()
    {
        $settings = get_option('woof_settings');

        $settings['force_ext_disable'] = 'url_request, by_text';

        update_option('woof_settings', $settings);
    }
}

if (!function_exists('kera_update_yith_wishlist_40')) {
    function kera_update_yith_wishlist_40()
    {
        update_option('yith_wcwl_add_to_wishlist_icon_type', 'default');
        update_option('yith_wcwl_added_to_wishlist_icon_type', 'default');
        update_option('yith_wcwl_add_to_wishlist_icon', 'heart-outline');
        update_option('yith_wcwl_added_to_wishlist_icon', 'heart-outline');
    }
}

if (!function_exists('kera_update_fix_new_plugin')) {
    add_action('after_setup_theme', 'kera_update_fix_new_plugin', 10);
    function kera_update_fix_new_plugin()
    {
        $current_theme_version = wp_get_theme()->get('Version');

        $stored_theme_version = get_option('kera_theme_version_fix_wishlist');

        if ($current_theme_version !== $stored_theme_version) {
            kera_update_yith_wishlist_40();

            update_option('kera_theme_version_fix_wishlist', $current_theme_version);
        }
    }
}
