<div class="tbay-swatches-wrapper">
    <ul data-attribute_name="attribute_<?php echo esc_attr( $attribute_name ); ?>">
        <?php foreach ( $swatches_to_show as $key => $swatch ) :
            $style = $class = $data = '';
            if ( isset( $swatch['image_src'] ) ) {
                $class .= ' swatch-has-image';
                $data .= ' data-image-src="' . esc_url( $swatch['image_src'] ) . '"';
                $data .= ' data-image-srcset="' . esc_attr( $swatch['image_srcset'] ) . '"';
                $data .= ' data-image-sizes="' . esc_attr( $swatch['image_sizes'] ) . '"';
                if ( ! $swatch['is_in_stock'] ) $class .= ' variation-out-of-stock';
            }

            $term = get_term_by( 'slug', $key, $attribute_name );
            $slug = $term->slug;
            $name = '';

            switch ( $swatch['type'] ) {
                case 'color':
                    $style = 'background-color: ' . esc_attr( $swatch['color'] );
                    $class .= ' variable-item-span-color';
                    break;
                case 'image':
                    $img = wp_get_attachment_image_src( $swatch['image'], 'woocommerce_thumbnail' );
                    $style = 'background-image: url(' . esc_url( $img[0] ) . ')';
                    $class .= ' variable-item-span-image';
                    break;
                case 'button':
                    $name = esc_html( $swatch['button'] );
                    $class .= ' variable-item-span-label';
                    break;
            } ?>
            <li>
                <a href="javascript:void(0)" class="<?php echo esc_attr( $class ); ?> swatch swatch-<?php echo esc_attr( strtolower( $slug ) ); ?>" style="<?php echo esc_attr( $style ); ?>" <?php echo $data; ?> data-toggle="tooltip" title="<?php echo esc_attr( $name ); ?>"><?php echo $name; ?></a>
            </li>
        <?php endforeach; ?>
    </ul>
</div>