<?php 
    // Get list of allowed product styles
    $allowedStyles = array_keys(apply_filters('kera_get_template_product', 'v1'));

    // Default product style
    $defaultStyle = 'inner-v1';

    if (isset($product_style)) {
        $product_style = sanitize_text_field($product_style);

        if (in_array($product_style, $allowedStyles, true)) {
            $stylePrefix = explode('-', $product_style)[0];

            // Prefix with 'inner-' unless style is vertical
            $product_style = ($stylePrefix !== 'vertical') 
                ? 'inner-' . $product_style 
                : $product_style;
        } else {
            $product_style = $defaultStyle;
        }
    } else {
        $product_style = $defaultStyle;
    }

	$flash_sales 		= isset($flash_sales) ? $flash_sales : false;
	$end_date 			= isset($end_date) ? $end_date : '';

	$countdown_title 	= isset($countdown_title) ? $countdown_title : '';
	$countdown 			= isset($countdown) ? $countdown : false;

?>
<div <?php echo trim($attr_row); ?>>

    <?php while ( $loop->have_posts() ) : $loop->the_post(); ?>

        <div class="item">
          <?php 
			$post_object = get_post( get_the_ID() );
			setup_postdata( $GLOBALS['post'] =& $post_object );

		  	wc_get_template( 'item-product/'. $product_style .'.php', array('flash_sales' => $flash_sales, 'end_date' => $end_date, 'countdown_title' => $countdown_title, 'countdown' => $countdown, 'product_style' => $product_style ) ); 
		  ?>
        </div>

    <?php endwhile; ?> 
</div>

<?php wp_reset_postdata(); ?>