<?php
/**
 * Related Products
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/related.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://docs.woocommerce.com/document/template-structure/
 * @package     WooCommerce/Templates
 * @version     10.3.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $product, $woocommerce_loop;

if ( empty( $product ) || ! $product->exists() ) {
	return;
}

if ( sizeof( $related_products ) == 0 ) return;

/**
 * Ensure all images of related products are lazy loaded by increasing the
 * current media count to WordPress's lazy loading threshold if needed.
 * Because wp_increase_content_media_count() is a private function, we
 * check for its existence before use.
 */
if ( function_exists( 'wp_increase_content_media_count' ) ) {
	$content_media_count = wp_increase_content_media_count( 0 );
	if ( $content_media_count < wp_omit_loading_attr_threshold() ) {
		wp_increase_content_media_count( wp_omit_loading_attr_threshold() - $content_media_count );
	}
}

if( isset($_GET['releated_columns']) ) { 
	$woocommerce_loop['columns'] = $_GET['releated_columns'];
} else {
	$woocommerce_loop['columns'] = kera_tbay_get_config('releated_product_columns', 4);
}

$columns_desktopsmall = 4;
$columns_tablet = 3;
$columns_mobile = 2;
$rows = 1;

$heading = apply_filters( 'woocommerce_product_related_products_heading', esc_html__( 'Related products', 'kera' ) );

$show_product_releated = kera_tbay_get_config('enable_product_releated', true);
 
if ( $show_product_releated ) : ?> 

	<div class="related products tbay-element tbay-element-products" id="product-related">

         <?php
		$heading = apply_filters( 'woocommerce_product_related_products_heading', esc_html__( 'Related products', 'kera' ) );

		if ( $heading ) :
			?>
			<h3 class="heading-tbay-title"><span><?php echo esc_html( $heading ); ?></span></h3>
		<?php endif; ?>

		<div class="tbay-element-content woocommerce">
		<?php  
			wc_get_template( 'layout-products/carousel-related.php' , array( 'loops'=>$related_products,'rows' => $rows, 'pagi_type' => 'no', 'nav_type' => 'yes','columns'=>$woocommerce_loop['columns'],'screen_desktop'=>$woocommerce_loop['columns'],'screen_desktopsmall'=>$columns_desktopsmall,'screen_tablet'=>$columns_tablet,'screen_mobile'=>$columns_mobile ) ); 
		?>
		</div>
	</div>

<?php endif;

wp_reset_postdata();