<?php
/**
 * Kingal functions and definitions.
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Kingal
 */

if ( ! function_exists( 'kingal_setup' ) ) :
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */
function kingal_setup() {
	/*
	 * Make theme available for translation.
	 * Translations can be filed in the /languages/ directory.
	 * If you're building a theme based on Kingal, use a find and replace
	 * to change 'kingal' to the name of your theme in all the template files.
	 */
	load_theme_textdomain( 'kingal', get_template_directory() . '/languages' );

	// Add default posts and comments RSS feed links to head.
	add_theme_support( 'automatic-feed-links' );

	/*
	 * Set woocommerce support  
	 * 
	 */
	add_theme_support( 'woocommerce' );
	
	/*
	 * Let WordPress manage the document title.
	 * By adding theme support, we declare that this theme does not use a
	 * hard-coded <title> tag in the document head, and expect WordPress to
	 * provide it for us.
	 */
	add_theme_support( 'title-tag' );

	/*
	 * Enable support for Post Thumbnails on posts and pages.
	 *
	 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
	 */
	add_theme_support( 'post-thumbnails' );
	
	add_image_size( 'kingal_slider_img', 1920,1080, true );
	add_image_size( 'kingal_who_we_are_img', 1500,994, true );
	add_image_size( 'kingal_testimonials', 115,115, true );
	add_image_size( 'kingal_team', 486,483, true );
	add_image_size( 'kingal_portfolio_img', 1680,1050, true );
	add_image_size( 'kingal_blog_img', 800,650, true );
	add_image_size( 'kingal_blog_img2', 770,450, true );
	add_image_size( 'kingal_blog_img3', 70,61, true );

	// This theme uses wp_nav_menu() in one location.
	register_nav_menus( array(
		'main_menu' => esc_html__( 'Main Menu', 'kingal' ),
	) );

	/*
	 * Switch default core markup for search form, comment form, and comments
	 * to output valid HTML5.
	 */
	add_theme_support( 'html5', array(
		'search-form',
		'comment-form',
		'comment-list',
		'gallery',
		'caption',
	) );

	/*
	 * Enable support for Post Formats.
	 * See https://developer.wordpress.org/themes/functionality/post-formats/
	 */
	add_theme_support( 'post-formats', array(
		'gallery',
		'audio',
		'video',
		'quote',
		'link',
	) );

	// Set up the WordPress core custom background feature.
	add_theme_support( 'custom-background', apply_filters( 'kingal_custom_background_args', array(
		'default-color' => 'ffffff',
		'default-image' => '',
	) ) );

add_editor_style( array( 'css/editor-style.css', kingal_fonts_url() ) );

}
endif;
add_action( 'after_setup_theme', 'kingal_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function kingal_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'kingal_content_width', 640 );
}
add_action( 'after_setup_theme', 'kingal_content_width', 0 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function kingal_widgets_init() {
	register_sidebar( array(
		'name'          => esc_html__( 'Sidebar', 'kingal' ),
		'id'            => 'sidebar-1',
		'description'   => 'Please add some widgets here',
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h4 class="blog_sidebar_title">',
		'after_title'   => '</h4>',
	) );	
	

}
add_action( 'widgets_init', 'kingal_widgets_init' );

function kingal_main_menu() {
		wp_nav_menu( array(
		'theme_location'    => 'main_menu',
		'depth'             => 5,
		'container'         => false,
		'menu_class'        => 'nav navbar-nav navbar-right',
		'fallback_cb'       => 'kingal_navwalker::fallback',
		
		)
	); 	
}
/**
 * register google fonts
 */
function kingal_fonts_url() {
	$fonts_url = '';
	
	/* Translators: If there are characters in your language that are not
	* supported by Source Sans Pro, translate this to 'off'. Do not translate
	* into your own language.
	*/
	$source_sans_pro = _x( 'on', 'Source Sans Pro font: on or off', 'kingal' );

	/* Translators: If there are characters in your language that are not
	* supported by Merriweather, translate this to 'off'. Do not translate
	* into your own language.
	*/
	
	$merriweather = _x( 'on', 'Merriweather: on or off', 'kingal' );	
	
	/* Translators: If there are characters in your language that are not
	* supported by Lato, translate this to 'off'. Do not translate
	* into your own language.
	*/
	
	$montserrat = _x( 'on', 'Montserrat font: on or off', 'kingal' );
	
	if ( 'off' !== $source_sans_pro || 'off' !== $merriweather || 'off' !== $montserrat ) {
	$font_families = array();
	 
	if ( 'off' !== $source_sans_pro ) {
	$font_families[] = 'Source Sans Pro:400,300,600,700';
	}
	 
	if ( 'off' !== $merriweather ) {
	$font_families[] = 'Merriweather:400,700,900,300';
	}	
	
	if ( 'off' !== $montserrat ) {
	$font_families[] = 'Montserrat:400,700';
	}
	 
	$query_args = array(
	'family' => urlencode( implode( '|', $font_families ) ),
	'subset' => urlencode( 'latin,latin-ext' ),
	);

	$fonts_url = add_query_arg( $query_args, 'https://fonts.googleapis.com/css' );
	}
	 
	return esc_url_raw( $fonts_url );	
}

/**
 * Enqueue scripts and styles.
 */
function kingal_scripts() {
	
	// Add Google Fonts css
	wp_enqueue_style( 'google-fonts', kingal_fonts_url(), array(), null );
	
	// Load CSS
	wp_enqueue_style('bootstrap' , get_template_directory_uri(). '/bootstrap/css/bootstrap.min.css');
	wp_enqueue_style('font-awesome.min' , get_template_directory_uri(). '/css/font-awesome.css');
	wp_enqueue_style('animate' , get_template_directory_uri(). '/css/animate.css');
	wp_enqueue_style('venobox' , get_template_directory_uri(). '/css/venobox.css');
	wp_enqueue_style('owl.carousel' , get_template_directory_uri(). '/css/owl.carousel.css');
	wp_enqueue_style( 'kingal-style', get_stylesheet_uri() );
	wp_enqueue_style('responsive' , get_template_directory_uri(). '/css/responsive.css');
	
	// Load JS Files
	wp_enqueue_script( 'html5shiv', get_template_directory_uri() . '/js/html5shiv.min.js', array(), '3.7.8' );	
	wp_script_add_data( 'html5shiv', 'conditional', 'lt IE 9' ); 	
	wp_enqueue_script( 'respond', get_template_directory_uri() . '/js/respond.min.js', array(), '3.7.4' );
	wp_script_add_data( 'respond', 'conditional', 'lt IE 9' ); 	
	wp_enqueue_script( 'bootstrap', get_template_directory_uri() . '/bootstrap/js/bootstrap.min.js', array('jquery'), '3.3', true );
	wp_enqueue_script( 'jquery.nav', get_template_directory_uri() . '/js/jquery.nav.js', array('jquery'), '3.3', true );
	wp_enqueue_script( 'jquery.countTo', get_template_directory_uri() . '/js/jquery.countTo.js', array('jquery'), '3.3', true );
	wp_enqueue_script( 'jquery.inview.min', get_template_directory_uri() . '/js/jquery.inview.min.js', array('jquery'), '3.3', true );
	wp_enqueue_script( 'jquery.appear', get_template_directory_uri() . '/js/jquery.appear.js', array('jquery'), '3.3', true );
	wp_enqueue_script( 'jquery.stellar.min', get_template_directory_uri() . '/js/jquery.stellar.min.js', array('jquery'), '3.3', true );
	wp_enqueue_script( 'jquery.mixitup', get_template_directory_uri() . '/js/jquery.mixitup.js', array('jquery'), '3.3', true );
	wp_enqueue_script( 'venobox.min', get_template_directory_uri() . '/js/venobox.min.js', array('jquery'), '3.3', true );
	wp_enqueue_script( 'owl.carousel.min', get_template_directory_uri() . '/js/owl.carousel.min.js', array('jquery'), '3.3', true );
	wp_enqueue_script( 'wow.min', get_template_directory_uri() . '/js/wow.min.js', array('jquery'), '3.3', true );
	wp_enqueue_script( 'scripts', get_template_directory_uri() . '/js/scripts.js', array('jquery'), '3.3', true );
	

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'kingal_scripts' );

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Custom functions that act independently of the theme templates.
 */
require get_template_directory() . '/inc/extras.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
require get_template_directory() . '/inc/jetpack.php';

/**
 * Load PHP file.
 */
require get_template_directory() . '/inc/navwalker.php';
require get_template_directory() . '/inc/admin/kingal-options.php';
require get_template_directory() . '/inc/admin/custom_css.php';
require get_template_directory() . '/inc/custom_functions.php';
require get_template_directory() . '/inc/class-tgm-plugin-activation.php';
require get_template_directory() . '/inc/required-plugin.php';
require get_template_directory() . '/inc/kingal_metabox.php';
require get_template_directory() . '/inc/demo_install.php';

/*---------------------------------------------
 Initialising Visual shortcode editor
----------------------------------------------*/ 
if (class_exists('WPBakeryVisualComposerAbstract')) {
 function kingal_requireVcExtend(){
  include_once( get_template_directory().'/vc_extend/extend_vc.php');  
 }
 add_action('init', 'kingal_requireVcExtend',2);
}

// modify search widget
function kingal_my_search_form( $form ) {
	$form = '
		<div class="search_form">
			<form role="search" method="get" id="searchform" class="searchform" action="' . esc_url(home_url( '/' )) . '" >
			<input type="text" value="' . get_search_query() . '" name="s" id="s" class="form-control" placeholder="' . esc_attr__('Enter Keyword Here &amp; Search...' , 'kingal') .'">
			</form>
		</div>
		
        ';
	return $form;
}
add_filter( 'get_search_form', 'kingal_my_search_form' );


// comment list modify

function kingal_comments($comment, $args, $depth) {
   $GLOBALS['comment'] = $comment; ?>

<li <?php comment_class(); ?> id="comment-<?php comment_ID() ?>">
	<div class="single_comment">
		<div class="media">
			<div class="comment_avatar">
				<?php echo get_avatar( $comment, 70 ); ?>
			</div>

			<div class="media-body text-left comment_single">
				<div class="creply_link"><i class="fa fa-link"></i> <?php comment_reply_link(array_merge( $args, array('depth' => $depth, 'max_depth' => $args['max_depth']))); ?></div>
				<h5 class="media-heading"><?php comment_author_link() ?> <span>&nbsp; &nbsp; <?php echo esc_html(get_comment_date('F j, Y')); ?> <?php echo esc_html(get_comment_date('g:i')); ?></span></h5>
				<?php if ($comment->comment_approved == '0') : ?>
				<p><em><?php esc_html_e('Your comment is awaiting moderation.','kingal'); ?></em></p>
				<?php endif; ?>
				 <?php comment_text(); ?>							
			</div>
		</div>
	</div>				
</li>


<?php } 

// comment box title change
add_filter( 'comment_form_defaults', 'kingal_remove_comment_form_allowed_tags' );
function kingal_remove_comment_form_allowed_tags( $defaults ) {

	$defaults['comment_notes_after'] = '';
	$defaults['comment_notes_before'] = '';
	return $defaults;

}

function kingal_comment_reform ($arg) {

$arg['title_reply'] = esc_html__('Write your comment Here','kingal');
$arg['comment_field'] = '<div class="row"><div class="form-group has-feedback col-md-12"><textarea id="comment" class="comment_field form-control" name="comment" cols="77" rows="3" placeholder="'. esc_html__("Write your Comment", "kingal").'" aria-required="true"></textarea><i class="fa fa-pencil  form-control-feedback"></i></div></div>';


return $arg;

}
add_filter('comment_form_defaults','kingal_comment_reform');

// comment form modify

function kingal_modify_comment_form_fields($fields){
	$commenter = wp_get_current_commenter();
	$req	   = get_option( 'require_name_email' );

	$fields['author'] = '<div class="row"><div class="form-group has-feedback col-md-4"><input type="text" name="author" id="author" value="'. esc_attr( $commenter['comment_author'] ) .'" placeholder="'. esc_attr__("Your Name *", "kingal").'" size="22" tabindex="1"'. ( $req ? 'aria-required="true"' : '' ).' class="input-name form-control" /><i class="fa fa-user form-control-feedback"></i></div>';

	$fields['email'] = '<div class="form-group has-feedback col-md-4"><input type="text" name="email" id="email" value="'. esc_attr( $commenter['comment_author_email'] ) .'" placeholder="'.esc_attr__("Your Email *", "kingal").'" size="22" tabindex="2"'. ( $req ? 'aria-required="true"' : '' ).' class="input-email form-control"  /><i class="fa fa-envelope-o form-control-feedback"></i></div>';
	
	$fields['url'] = '<div class="form-group has-feedback col-md-4"><input type="text" name="url" id="url" value="'. esc_attr( $commenter['comment_author_url'] ) .'" placeholder="'. esc_attr__("Website", "kingal").'" size="22" tabindex="2"'. ( $req ? 'aria-required="false"' : '' ).' class="input-url form-control"  /><i class="fa fa-globe form-control-feedback"></i></div></div>';

	return $fields;
}
add_filter('comment_form_default_fields','kingal_modify_comment_form_fields');

// Custom WP Kses

function kingal_wp_kses($val){
	return wp_kses($val, array(
	
	'p' => array(
		'class' =>array()
	),
	'span' => array(),
	'small' => array(),
	'div' => array(),
	'strong' => array(),
	'b' => array(),
	'br' => array(),
	'h1' => array(),
	'i' => array(
		'class' =>array()
	),	
	'ul' => array(
		'class' =>array()
	),	
	'ul' => array(
		'id' =>array()
	),	
	'li' => array(
		'class' =>array()
	),	
	'li' => array(
		'id' =>array()
	),
	'h2' => array(),
	'h3' => array(),
	'h4' => array(),
	'h5' => array(),
	'h6' => array(),
	'a'=> array('href' => array(),'target' => array()),
	'iframe'=> array('src' => array(),'height' => array(),'width' => array()),
	
	), '');
}