<?php
    /**
     * ReduxFramework Sample Config File
     * For full documentation, please visit: http://docs.reduxframework.com/
     */

    if ( ! class_exists( 'Redux' ) ) {
        return;
    }


    // This is your option name where all the Redux data is stored.
    $opt_name = "kingal";

    // This line is only for altering the demo. Can be easily removed.
    $opt_name = apply_filters( 'kingal/opt_name', $opt_name );
    

    /**
     * ---> SET ARGUMENTS
     * All the possible arguments for Redux.
     * For full documentation on arguments, please refer to: https://github.com/ReduxFramework/ReduxFramework/wiki/Arguments
     * */

    $theme = wp_get_theme(); // For use with some settings. Not necessary.

    $args = array(
        // TYPICAL -> Change these values as you need/desire
        'opt_name'             => $opt_name,

         'disable_tracking' => true,
        // This is where your data is stored in the database and also becomes your global variable name.
        'display_name'         => $theme->get( 'Name' ),
        // Name that appears at the top of your panel
        'display_version'      => $theme->get( 'Version' ),
        // Version that appears at the top of your panel
        'menu_type'            => 'menu',
        //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
        'allow_sub_menu'       => false,
        // Show the sections below the admin menu item or not
        'menu_title'           => esc_html__( 'Kingal Options', 'kingal' ),
        'page_title'           => esc_html__( 'Kingal Options', 'kingal' ),
        // You will need to generate a Google API key to use this feature.
        // Please visit: https://developers.google.com/fonts/docs/developer_api#Auth
        'google_api_key'       => '',
        // Set it you want google fonts to update weekly. A google_api_key value is required.
        'google_update_weekly' => false,
        // Must be defined to add google fonts to the typography module
        'async_typography'     => true,
        // Use a asynchronous font on the front end or font string
        //'disable_google_fonts_link' => true,                    // Disable this in case you want to create your own google fonts loader
        'admin_bar'            => true,
        // Show the panel pages on the admin bar
        'admin_bar_icon'       => 'dashicons-portfolio',
        // Choose an icon for the admin bar menu
        'admin_bar_priority'   => 50,
        // Choose an priority for the admin bar menu
        'global_variable'      => '',
        // Set a different name for your global variable other than the opt_name
        'dev_mode'             => false,
        // Show the time the page took to load, etc
        'update_notice'        => false,
        // If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo
        'customizer'           => false,
        // Enable basic customizer support
        //'open_expanded'     => true,                    // Allow you to start the panel in an expanded way initially.
        //'disable_save_warn' => true,                    // Disable the save warning when a user changes a field

        // OPTIONAL -> Give you extra features
        'page_priority'        => 3,
        // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
        'page_parent'          => 'themes.php',
        // For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
        'page_permissions'     => 'manage_options',
        // Permissions needed to access the options panel.
        'menu_icon'            => '',
        // Specify a custom URL to an icon
        'last_tab'             => '',
        // Force your panel to always open to a specific tab (by id)
        'page_icon'            => 'icon-themes',
        // Icon displayed in the admin panel next to your menu_title
        'page_slug'            => '',
        // Page slug used to denote the panel, will be based off page title then menu title then opt_name if not provided
        'save_defaults'        => true,
        // On load save the defaults to DB before user clicks save or not
        'default_show'         => false,
        // If true, shows the default value next to each field that is not the default value.
        'default_mark'         => '',
        // What to print by the field's title if the value shown is default. Suggested: *
        'show_import_export'   => true,
        // Shows the Import/Export panel when not used as a field.

        // CAREFUL -> These options are for advanced use only
        'transient_time'       => 60 * MINUTE_IN_SECONDS,
        'output'               => true,
        // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
        'output_tag'           => true,
        // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head
        // 'footer_credit'     => '',                   // Disable the footer credit of Redux. Please leave if you can help it.

        // FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
        'database'             => '',
        // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!
        'use_cdn'              => true,
        // If you prefer not to use the CDN for Select2, Ace Editor, and others, you may download the Redux Vendor Support plugin yourself and run locally or embed it in your code.

    );

 

    // Panel Intro text -> before the form
    if ( ! isset( $args['global_variable'] ) || $args['global_variable'] !== false ) {
        if ( ! empty( $args['global_variable'] ) ) {
            $v = $args['global_variable'];
        } else {
            $v = str_replace( '-', '_', $args['opt_name'] );
        }
        $args['intro_text'] = sprintf( esc_html__( '', 'kingal' ), $v );
    } else {
        $args['intro_text'] = esc_html__( '', 'kingal' );
    }

    // Add content after the form.
    $args['footer_text'] = esc_html__( '', 'kingal' );

    Redux::setArgs( $opt_name, $args );

    /*
     * ---> END ARGUMENTS
     */


    /*
     * ---> START HELP TABS
     */

    $tabs = array(
        array(
            'id'      => 'redux-help-tab-1',
            'title'   => esc_html__( 'Theme Information 1', 'kingal' ),
            'content' => esc_html__( '<p>This is the tab content, HTML is allowed.</p>', 'kingal' )
        ),
        array(
            'id'      => 'redux-help-tab-2',
            'title'   => esc_html__( 'Theme Information 2', 'kingal' ),
            'content' => esc_html__( '<p>This is the tab content, HTML is allowed.</p>', 'kingal' )
        )
    );
    Redux::setHelpTab( $opt_name, $tabs );

    // Set the help sidebar
    $content = esc_html__( '<p>This is the sidebar content, HTML is allowed.</p>', 'kingal' );
    Redux::setHelpSidebar( $opt_name, $content );


    /*
     * <--- END HELP TABS
     */


    /*
     *
     * ---> START SECTIONS
     *
     */

    /*

        As of Redux 3.5+, there is an extensive API. This API can be used in a mix/match mode allowing for


     */

      // -> START Basic Fields

    Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'General Settings', 'kingal' ),
		'desc'   => esc_html__( '', 'kingal' ),
		'icon'   => 'el el-cog',
		'fields' => array(

			array(
				'id'       => 'kingal_home_logo_ico',
				'type'     => 'media',
				'compiler' => true,
				'title'    => esc_html__('Logo Upload', 'kingal'), 
				'subtitle' => esc_html__('upload your logo', 'kingal'),
				'default'  => array(
						   'url'=> get_template_directory_uri().'/img/logo.png'
				  ),
			),
			array(
				'id'       => 'kingal_home_banner_img',
				'type'     => 'media',
				'compiler' => true,
				'title'    => esc_html__('Header Banner Image', 'kingal'), 
				'subtitle' => esc_html__('upload banner image here', 'kingal'),
				'default'  => array(
						   'url'=> get_template_directory_uri().'/img/bg/section-bg.jpg'
				  ),
			), 

			array(
                'id'          => 'body_textopt-typography',
                'type'        => 'typography',
                'title'       => esc_html__( 'Body Text Typography', 'kingal' ),
                'font-backup' => true,
                'font-style'    => true, // Includes font-style and weight. Can use font-style or font-weight to declare
                'subsets'       => false, // Only appears if google is true and subsets not set to false
                'font-size'     => true,
                'line-height'   => true,
                'word-spacing'  => true,  // Defaults to false
                'letter-spacing'=> true,  // Defaults to false
                'color'         => true,
                'preview'       => true, // Disable the previewer
                'all_styles'  => true,
                'output'      => array( 'body,p,a,html' ),
                'units'       => 'px',
                'default'     => array(
                    'color'       => '',
                    'font-style'  => '',
                    'font-family' => '',
                    'google'      => true,
                    'font-size'   => ''
                ),
            ),			
			
			array(
                'id'          => 'body_heading_opt-typography',
                'type'        => 'typography',
                'title'       => esc_html__( 'Heading Typography', 'kingal' ),
                'font-backup' => true,
                'font-style'    => true, // Includes font-style and weight. Can use font-style or font-weight to declare
                'subsets'       => false, // Only appears if google is true and subsets not set to false
                'font-size'     => false,
                'line-height'   => true,
                'word-spacing'  => true,  // Defaults to false
                'letter-spacing'=> true,  // Defaults to false
                'color'         => true,
                'preview'       => true, // Disable the previewer
                'all_styles'  => true,
                'output'      => array( 'h1,h2,h3,h4,h5,h6,.progress-bar-text,.footer_copyright' ),
                'units'       => 'px',
                'default'     => array(
                    'color'       => '',
                    'font-style'  => '',
                    'font-family' => '',
                    'google'      => true,
                    'font-size'   => ''
                ),
            ),			
			array(
				'id'       => 'kingal_menu_text_color',
				'type'     => 'color',
				'title'    => esc_html__('Menu Text Color', 'kingal'), 
				'subtitle' => esc_html__('Choice color here', 'kingal'),
				'default'  => '#ffffff'
			),						
			array(
				'id'       => 'kingal_menu_text_hover_acive_color',
				'type'     => 'color',
				'title'    => esc_html__('Menu Text Hover / Active Color', 'kingal'), 
				'subtitle' => esc_html__('Choice color here', 'kingal'),
				'default'  => '#1cbac8'
			),					
			array(
				'id'       => 'kingal_sticky_menu_bg_color',
				'type'     => 'text',
				'title'    => esc_html__('Sticky Menu Backgrund Color', 'kingal'), 
				'subtitle' => esc_html__('Please use rgba color code here. Such as - 0, 0, 0, 0.8', 'kingal'),
				'default'  => '0,0,0,0.8'
			),		
		)
    ) ); 

    Redux::setSection( $opt_name, array(
        'title'            => esc_html__( 'Footer Settings', 'kingal' ),
        'id'               => 'kingal-foooter-setting',
        'icon'             => 'el el-stop-alt',
        'customizer_width' => '400px',
        'fields'           => array(

            array(
                'id'       => 'kingal_newsletter_widget',
                'type'     => 'switch',
                'title'    => esc_html__('Display Newsletter Widget ?', 'kingal'),
                'subtitle' => esc_html__('If yes then click the checkbox.', 'kingal'),
                'default'  => '1'// 1 = on | 0 = off
            ),  
			array(
                'id'       => 'kingal_ne_icon',
                'type'             => 'text',
                'title'            => esc_html__('Icon', 'kingal'), 
                'subtitle'         => esc_html__('change icon here. get all icon here <a href="//fortawesome.github.io/Font-Awesome/3.2.1/icons/" target="_blank">click here</a>', 'kingal'),
				'default'		=> 'fa-paper-plane-o',
				'required' => array( 'kingal_newsletter_widget', '=', '1' ),
            ),	 		
			
			array(
                'id'       => 'kingal_ne_title',
                'type'             => 'text',
                'title'            => esc_html__('Title', 'kingal'), 
                'subtitle'         => esc_html__('write text here.', 'kingal'),
				'default'		=> 'Subscribe with our newsletter',
				'required' => array( 'kingal_newsletter_widget', '=', '1' ),
            ),	 		

			array(
                'id'       => 'kingal_ne_short',
                'type'             => 'text',
                'title'            => esc_html__('MailChimp for wordpress Shortcode', 'kingal'), 
                'subtitle'         => esc_html__('enter  mailChimp for wordpress shortcode here.', 'kingal'),
				'default'		=> '[mc4wp_form id="234"]',
				'required' => array( 'kingal_newsletter_widget', '=', '1' ),
            ),				
			
			array(
                'id'       => 'kingal_ne_icon_color',
                'type'             => 'color',
                'title'            => esc_html__('Icon Color', 'kingal'), 
                'subtitle'         => esc_html__('choice color here.', 'kingal'),		
				'required' => array( 'kingal_newsletter_widget', '=', '1' ),
            ),		

			array(
                'id'       => 'kingal_ne_title_color',
                'type'             => 'color',
                'title'            => esc_html__('Title Color', 'kingal'), 
                'subtitle'         => esc_html__('choice color here.', 'kingal'),		
				'required' => array( 'kingal_newsletter_widget', '=', '1' ),
            ),				
			
			array(
                'id'       => 'kingal_ne_btn_bg_color',
                'type'             => 'color',
                'title'            => esc_html__('Button Background Color', 'kingal'), 
                'subtitle'         => esc_html__('choice color here.', 'kingal'),		
				'required' => array( 'kingal_newsletter_widget', '=', '1' ),
            ),	 		

			array(
                'id'       => 'kingal_ne_btn_text_color',
                'type'             => 'color',
                'title'            => esc_html__('Button Text Color', 'kingal'), 
                'subtitle'         => esc_html__('choice color here.', 'kingal'),		
				'required' => array( 'kingal_newsletter_widget', '=', '1' ),
            ),				
			
			array(
                'id'       => 'kingal_ne_btn_hove_bg_color',
                'type'             => 'color',
                'title'            => esc_html__('Button Hover Background Color', 'kingal'), 
                'subtitle'         => esc_html__('choice color here.', 'kingal'),		
				'required' => array( 'kingal_newsletter_widget', '=', '1' ),
            ),	 			
			
			array(
                'id'       => 'kingal_ne_btn_hove_text_color',
                'type'             => 'color',
                'title'            => esc_html__('Button Hover Text Color', 'kingal'), 
                'subtitle'         => esc_html__('choice color here.', 'kingal'),		
				'required' => array( 'kingal_newsletter_widget', '=', '1' ),
            ),	 			

            array(
                'id'       => 'kingal_copywrite_text',
                'type'             => 'editor',
                'title'            => esc_html__('Copyright Text', 'kingal'), 
                'subtitle'         => esc_html__('Write Copyright text here.', 'kingal'),
                'default'          => 'Copyright © 2025 Kingal | All Rights Reserved',
                'args'   => array(
                    'teeny'            => true,
                    'textarea_rows'    => 4
                )
            ),

			array(
                'id'       => 'kingal_copright_text_color',
                'type'             => 'color',
                'title'            => esc_html__('Copyright Text Color', 'kingal'), 
                'subtitle'         => esc_html__('choice color here.', 'kingal'),		
            ),  			
			
			array(
                'id'       => 'kingal_copright_link_color',
                'type'             => 'color',
                'title'            => esc_html__('Copyright Link Color', 'kingal'), 
                'subtitle'         => esc_html__('choice color here.', 'kingal'),		
            ), 			
			
			array(
                'id'       => 'kingal_copright_linkhover_color',
                'type'             => 'color',
                'title'            => esc_html__('Copyright Link Hover Color', 'kingal'), 
                'subtitle'         => esc_html__('choice color here.', 'kingal'),		
            ), 			
			
			array(
                'id'       => 'kingal_footer_bg_color',
                'type'             => 'color',
                'title'            => esc_html__('Footer Background Color', 'kingal'), 
                'subtitle'         => esc_html__('choice color here.', 'kingal'),		
            ),            
					
        )
    ) );

    Redux::setSection( $opt_name, array(
        'title'            => esc_html__( 'Advance Settings', 'kingal' ),
        'id'               => 'kingal-advance-setting',
        'customizer_width' => '400px',
        'fields'           => array(
			array(
				'id'       => 'kingal_theme_color',
				'type'     => 'color',
				'title'    => esc_html__('Theme Color', 'kingal'), 
				'subtitle' => esc_html__('Please use color ', 'kingal'),
				'default'  => ''
			),			
			array(
				'id'       => 'kingal_theme_hover_color',
				'type'     => 'color',
				'title'    => esc_html__('Theme Hover Color', 'kingal'), 
				'subtitle' => esc_html__('Please use color ', 'kingal'),
				'default'  => ''
			),			
            array(
                'id'       => 'kingal_preloader_opt',
                'type'     => 'switch',
                'title'    => esc_html__('Display Preloader', 'kingal'),
                'subtitle' => esc_html__('If yes then click the checkbox.', 'kingal'),
                'default'  => '1'// 1 = on | 0 = off
            ),  
			array(
                'id'       => 'kingal_homepage_opt',
                'type'             => 'checkbox',
                'title'            => esc_html__('Only Enable Home Page', 'kingal'), 
				'default'  => '0',
                'subtitle'         => esc_html__('if check this option preloader only will be enable for home page', 'kingal'),
				'required' => array( 'kingal_preloader_opt', '=', '1' ),
            ),				
			
			array(
                'id'       => 'kingal_preloader_bg_color',
                'type'             => 'color',
                'title'            => esc_html__('Preloader Background Color', 'kingal'), 
				'default'  => '#1cbac8',
                'subtitle'         => esc_html__('choice color here', 'kingal'),
				'required' => array( 'kingal_preloader_opt', '=', '1' ),
            ),		

			array(
                'id'       => 'kingal_preloader_imge',
                'type'             => 'media',
                'title'            => esc_html__('Preloader Background Color', 'kingal'), 
				'default'  => array(
					'url'	=> get_template_directory_uri(). '/img/status.gif'
				),
                'subtitle'         => esc_html__('upload preloader image here', 'kingal'),
				'required' => array( 'kingal_preloader_opt', '=', '1' ),
            ),	
			
            array(
                'id'       => 'kingal_css_editor',
                'type'     => 'ace_editor',
                'title'    => esc_html__('Custom CSS', 'kingal'),
                'subtitle' => esc_html__('Write your CSS code here.', 'kingal'),
                'mode'     => 'css',
                'theme'    => 'monokai',
            ),
			
			

        )
    ) );




    Redux::setSection( $opt_name, array(
        'icon'            => 'el el-list-alt',
        'title'           => esc_html__( 'Customizer Only', 'kingal' ),
        'desc'            => esc_html__( '<p class="description">This Section should be visible only in Customizer</p>', 'kingal' ),
        'customizer_only' => true,
        'fields'          => array(
            array(
                'id'              => 'opt-customizer-only',
                'type'            => 'select',
                'title'           => esc_html__( 'Customizer Only Option', 'kingal' ),
                'subtitle'        => esc_html__( 'The subtitle is NOT visible in customizer', 'kingal' ),
                'desc'            => esc_html__( 'The field desc is NOT visible in customizer.', 'kingal' ),
                'customizer_only' => true,
                //Must provide key => value pairs for select options
                'options'         => array(
                    '1' => 'Opt 1',
                    '2' => 'Opt 2',
                    '3' => 'Opt 3'
                ),
                'default'         => '2'
            ),
        )
    ) );

    if ( file_exists( get_template_directory() . '/../README.md' ) ) {
        $section = array(
            'icon'   => 'el el-list-alt',
            'title'  => esc_html__( 'Documentation', 'kingal' ),
            'fields' => array(
                array(
                    'id'       => '17',
                    'type'     => 'raw',
                    'markdown' => true,
                    'content_path' => get_template_directory() . '/../README.md', // FULL PATH, not relative please
                    //'content' => 'Raw content here',
                ),
            ),
        );
        Redux::setSection( $opt_name, $section );
    }
    /*
     * <--- END SECTIONS
     */


 