<?php

function kingla_header_section(){ 
	global $kingal;
	
	$kingal_site_logo = '';
	$kingal_preloader_opt = '';
	$kingal_homepage_opt = '';
	$kingal_preloader_bg_color = '';

	if ( isset( $kingal['kingal_home_logo_ico']['url']) ) {
		$kingal_site_logo = $kingal['kingal_home_logo_ico']['url'];
	}	
	
	if ( isset( $kingal['kingal_preloader_opt']) ) {
		$kingal_preloader_opt = $kingal['kingal_preloader_opt'];
	}
	
	if ( isset( $kingal['kingal_homepage_opt']) ) {
		$kingal_homepage_opt = $kingal['kingal_homepage_opt'];
	}	
	
	if ( isset( $kingal['kingal_preloader_bg_color']) ) {
		$kingal_preloader_bg_color = $kingal['kingal_preloader_bg_color'];
	}

	
	if ( isset( $kingal['kingal_preloader_imge']['url']) ) {
		$kingal_preloader_imge = $kingal['kingal_preloader_imge']['url'];
	}
	

	
	$kingal_default_site_logo = get_template_directory_uri(). '/img/logo.png';
?>

<?php if($kingal_preloader_opt == '1' && !$kingal_homepage_opt == '1') { ?>
<!-- START PRELOADER -->
	<div class="preloader" style="background-color: <?php if(isset($kingal_preloader_bg_color)) { echo esc_attr($kingal_preloader_bg_color);}?>;">
		<div class="status">
			<div class="status-mes" style="background-image: url(<?php if(isset($kingal_preloader_imge)) { echo esc_url($kingal_preloader_imge);}?>);"></div>
		</div>
	</div>
<?php }elseif($kingal_preloader_opt == '1' && $kingal_homepage_opt == '1'){ ?>	

<?php if(is_front_page()) {?>
<!-- START PRELOADER -->
	<div class="preloader" style="background-color: <?php if(isset($kingal_preloader_bg_color)) { echo esc_attr($kingal_preloader_bg_color);}?>;">
		<div class="status">
			<div class="status-mes" style="background-image: url(<?php if(isset($kingal_preloader_imge)) { echo esc_url($kingal_preloader_imge);}?>);"></div>
		</div>
	</div>
<?php } } ?>
		
	<!-- START NAVBAR -->
	<div class="navbar navbar-default navbar-fixed-top menu-top" role="navigation">
		<div class="container">
			<div class="navbar-header">
				<button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".navbar-collapse">
					<span class="sr-only"><?php esc_html_e('Toggle navigation' , 'kingal');?></span>
					<span class="icon-bar"></span>
					<span class="icon-bar"></span>
					<span class="icon-bar"></span>
				</button>
				<a class="navbar-brand" href="<?php echo esc_url(home_url('/'));?>"><img src="<?php if($kingal_site_logo){echo esc_url($kingal_site_logo);}else{ echo esc_url($kingal_default_site_logo);}?>" alt="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" /></a>
			</div>
			<div class="navbar-collapse collapse mainmenu">
				<?php kingal_main_menu();?>
			</div> 
		</div><!--- END CONTAINER -->
	</div> 
	<!-- END NAVBAR -->	
<?php }


function kingla_main_banner_mix(){ 
	global $kingal;
	
	$kingal_home_banner_img_opt = '';

	if ( isset( $kingal['kingal_home_banner_img']['url']) ) {
		$kingal_home_banner_img_opt = $kingal['kingal_home_banner_img']['url'];
	}
	
	$kingal_home_banner_img_cus = get_post_meta(get_the_ID(),'_kingal_upload_banner_image',true);
	$kingal_home_banner_img_default = get_template_directory_uri(). '/img/bg/section-bg.jpg';
	
?>

	<!-- START  HOME DESIGN -->
	<section class="section-top" style="background-image: url(<?php if($kingal_home_banner_img_cus){ echo esc_url($kingal_home_banner_img_cus) ; }elseif($kingal_home_banner_img_opt) { echo esc_url($kingal_home_banner_img_opt); }else{ echo esc_url($kingal_home_banner_img_default);} ?>);  background-size:cover; background-position: center center;background-attachment:fixed;">
		<div class="overlay">
			<div class="container">
				<div class="col-md-10 col-md-offset-1 col-xs-12 text-center">
					<div class="section-top-title">
						<h2><?php the_title();?></h2>
						<ol class="breadcrumb">
						  <li><a href="<?php echo esc_url(home_url('/'));?>"><?php echo esc_html_e('Home' , 'kingal');?></a></li>
						  <li class="active"><?php the_title();?></li>
						</ol>
					</div><!-- //.HERO-TEXT -->
				</div><!--- END COL -->
			</div><!--- END CONTAINER -->
		</div><!--- END HOME OVERLAY -->
	</section>	
	<!-- END  HOME DESIGN -->
	
<?php }

function kingla_main_banner_404(){ 
	global $kingal;
	
	$kingal_home_banner_img_opt = '';

	if ( isset( $kingal['kingal_home_banner_img']['url']) ) {
		$kingal_home_banner_img_opt = $kingal['kingal_home_banner_img']['url'];
	}
	
	$kingal_home_banner_img_default = get_template_directory_uri(). '/img/bg/section-bg.jpg';
	
?>

	<!-- START  HOME DESIGN -->
	<section class="section-top" style="background-image: url(<?php if($kingal_home_banner_img_opt){echo esc_url($kingal_home_banner_img_opt);}else{ echo esc_url($kingal_home_banner_img_default);}?>);  background-size:cover; background-position: center center;background-attachment:fixed;">
		<div class="overlay">
			<div class="container">
				<div class="col-md-10 col-md-offset-1 col-xs-12 text-center">
					<div class="section-top-title">
						<h2><?php esc_html_e('404' , 'kingal');?></h2>
						<ol class="breadcrumb">
						  <li><a href="<?php echo esc_url(home_url('/'));?>"><?php echo esc_html_e('Home' , 'kingal');?></a></li>
						  <li class="active"><?php esc_html_e('404' , 'kingal');?></li>
						</ol>
					</div><!-- //.HERO-TEXT -->
				</div><!--- END COL -->
			</div><!--- END CONTAINER -->
		</div><!--- END HOME OVERLAY -->
	</section>	
	
<?php }

function kingla_main_banner_blog(){ 
	global $kingal;
	
	$kingal_home_banner_img_opt = '';

	if ( isset( $kingal['kingal_home_banner_img']['url']) ) {
		$kingal_home_banner_img_opt = $kingal['kingal_home_banner_img']['url'];
	}
	
	$kingal_home_banner_img_default = get_template_directory_uri(). '/img/bg/section-bg.jpg';
?>

	<!-- START  HOME DESIGN -->
	<section class="section-top" style="background-image: url(<?php if($kingal_home_banner_img_opt){echo esc_url($kingal_home_banner_img_opt);}else{ echo esc_url($kingal_home_banner_img_default);}?>);  background-size:cover; background-position: center center;background-attachment:fixed;">
		<div class="overlay">
			<div class="container">
				<div class="col-md-10 col-md-offset-1 col-xs-12 text-center">
					<div class="section-top-title">
						<h2><?php echo esc_html_e('Blog' , 'kingal');?></h2>
						<ol class="breadcrumb">
						  <li><a href="<?php echo esc_url(home_url('/'));?>"><?php echo esc_html_e('Home' , 'kingal');?></a></li>
						  <li class="active"><?php echo esc_html_e('Blog' , 'kingal');?></li>
						</ol>
					</div><!-- //.HERO-TEXT -->
				</div><!--- END COL -->
			</div><!--- END CONTAINER -->
		</div><!--- END HOME OVERLAY -->
	</section>	
		
	
<?php }


function kingla_main_banner_archive(){ 
	global $kingal;
	
	$kingal_home_banner_img_opt = '';

	if ( isset( $kingal['kingal_home_banner_img']['url']) ) {
		$kingal_home_banner_img_opt = $kingal['kingal_home_banner_img']['url'];
	}
	
	$kingal_home_banner_img_default = get_template_directory_uri(). '/img/bg/section-bg.jpg';
?>

	<!-- START  HOME DESIGN -->
	<section class="section-top" style="background-image: url(<?php if($kingal_home_banner_img_opt){echo esc_url($kingal_home_banner_img_opt);}else{ echo esc_url($kingal_home_banner_img_default);}?>);  background-size:cover; background-position: center center;background-attachment:fixed;">
		<div class="overlay">
			<div class="container">
				<div class="col-md-10 col-md-offset-1 col-xs-12 text-center">
					<div class="section-top-title">
						<h2><?php echo esc_html_e('Archives' , 'kingal');?></h2>
						<ol class="breadcrumb">
						  <li><a href="<?php echo esc_url(home_url('/'));?>"><?php echo esc_html_e('Home' , 'kingal');?></a></li>
						  <li class="active"><?php the_archive_title();?></li>
						</ol>
					</div><!-- //.HERO-TEXT -->
				</div><!--- END COL -->
			</div><!--- END CONTAINER -->
		</div><!--- END HOME OVERLAY -->
	</section>	
	
<?php }

function kingla_shop_banner_archive(){ 
	global $kingal;
	
	$kingal_home_banner_img_opt = '';

	if ( isset( $kingal['kingal_home_banner_img']['url']) ) {
		$kingal_home_banner_img_opt = $kingal['kingal_home_banner_img']['url'];
	}
	
	$kingal_home_banner_img_default = get_template_directory_uri(). '/img/bg/section-bg.jpg';
?>

	<!-- START  HOME DESIGN -->
	<section class="section-top" style="background-image: url(<?php if($kingal_home_banner_img_opt){echo esc_url($kingal_home_banner_img_opt);}else{ echo esc_url($kingal_home_banner_img_default);}?>);  background-size:cover; background-position: center center;background-attachment:fixed;">
		<div class="overlay">
			<div class="container">
				<div class="col-md-10 col-md-offset-1 col-xs-12 text-center">
					<div class="section-top-title">
						<h2><?php echo esc_html_e('Shop' , 'kingal');?></h2>
						<ol class="breadcrumb">
						  <li><a href="<?php echo esc_url(home_url('/'));?>"><?php echo esc_html_e('Home' , 'kingal');?></a></li>
						  <li class="active"><?php echo esc_html_e('Shop' , 'kingal');?></li>
						</ol>
					</div><!-- //.HERO-TEXT -->
				</div><!--- END COL -->
			</div><!--- END CONTAINER -->
		</div><!--- END HOME OVERLAY -->
	</section>	
	
<?php }


function kingla_main_banner_search(){ 
	global $kingal;
	
	$kingal_home_banner_img_opt = '';

	if ( isset( $kingal['kingal_home_banner_img']['url']) ) {
		$kingal_home_banner_img_opt = $kingal['kingal_home_banner_img']['url'];
	}
	
	$kingal_home_banner_img_default = get_template_directory_uri(). '/img/bg/section-bg.jpg';
?>

	<!-- START  HOME DESIGN -->
	<section class="section-top" style="background-image: url(<?php if($kingal_home_banner_img_opt){ echo esc_url($kingal_home_banner_img_opt);}else{ echo esc_url($kingal_home_banner_img_default);} ?>);  background-size:cover; background-position: center center;background-attachment:fixed;">
		<div class="overlay">
			<div class="container">
				<div class="col-md-10 col-md-offset-1 col-xs-12 text-center">
					<div class="section-top-title">
						<h2><?php esc_html_e('Search Results' , 'kingal');?></h2>
						<ol class="breadcrumb">
						  <li><a href="<?php echo esc_url(home_url('/'));?>"><?php echo esc_html_e('Home' , 'kingal');?></a></li>
						  <li class="active"><?php printf( esc_html__( 'Search Results for: %s', 'kingal' ), '<span>' . get_search_query() . '</span>' ); ?></li>
						</ol>
					</div><!-- //.HERO-TEXT -->
				</div><!--- END COL -->
			</div><!--- END CONTAINER -->
		</div><!--- END HOME OVERLAY -->
	</section>	
	
<?php }

function kingla_footer_section(){
	
	global $kingal;

	$kingal_newsletter_widget = '';
	$kingal_ne_icon = '';
	$kingal_ne_title = '';
	$kingal_ne_short = '';
	$kingal_copywrite_text = '';

	if ( isset( $kingal['kingal_newsletter_widget']) ) {
		$kingal_newsletter_widget = $kingal['kingal_newsletter_widget'];
	}
	
	if ( isset( $kingal['kingal_ne_icon']) ) {
		$kingal_ne_icon = $kingal['kingal_ne_icon'];
	}	
	
	if ( isset( $kingal['kingal_ne_title']) ) {
		$kingal_ne_title = $kingal['kingal_ne_title'];
	}	
	
	if ( isset( $kingal['kingal_ne_short']) ) {
		$kingal_ne_short = $kingal['kingal_ne_short'];
	}
	
	if ( isset( $kingal['kingal_copywrite_text']) ) {
		$kingal_copywrite_text = $kingal['kingal_copywrite_text'];
	}

?>

	<!-- START FOOTER -->
	<footer class="footer section-padding">
		<div class="container">
<?php if($kingal_newsletter_widget == '1'){ ?>		
			<div class="row">
				<div class="col-md-6 col-md-offset-3 col-sm-12 col-xs-12 text-center wow zoomIn">
					<div class="newsletter">
						<h3><i class="fa <?php echo esc_attr($kingal_ne_icon);?>"></i> <?php echo esc_html($kingal_ne_title);?></h3>
						
						<?php 
						if($kingal_ne_short){
							
							echo do_shortcode($kingal_ne_short);						
						}
						
						?>
					</div>						
				</div><!-- END COL -->				
			</div><!--- END ROW -->
		<?php } ?>
		
			<div class="row">
				<div class="col-sm-12 text-center wow zoomIn">	
					<div class="footer-content">						
						<p>
						<?php 
							if($kingal_copywrite_text){
							echo kingal_wp_kses($kingal_copywrite_text);
							}else{
								echo esc_html__('Copyright © 2025 Kingal | All Rights Reserved' , 'kingal');
							}
						?>
						</p>
					</div>
				</div><!--- END COL -->
			</div>
		</div><!--- END CONTAINER -->
	</footer>
	<!-- END FOOTER -->		
	
<?php  }
