<?php


add_action( 'cmb2_init', 'kingal_page_metabox' );

function kingal_page_metabox(){
	// Start with an underscore to hide fields from custom fields list
	$prefix = '_kingal_';


	// Page Options	

	$cmb2_page_options = new_cmb2_box( array(
		'id'           => $prefix . 'page_option',
		'title'        => esc_html__( 'Home Versions', 'kingal' ),
		'object_types' => array( 'page'), // Post type
		'context'      => 'normal',
		'priority'     => 'high',
		'show_names'   => true, // Show field names on the left
		//'show_on'      => array( 'id' => array( 2, ) ), // Specific post IDs to display this metabox
	) );

	$cmb2_page_options->add_field( array(
	    'id'               => $prefix .'page_home_versions',
	    'desc'             => esc_html__( 'select version here. this option only for Page Fullscreen Template ','kingal' ),
		 'type'             => 'select',
		'default'          => 'light',
		'options'          => array(
			'light' => __( 'Light', 'kingal' ),
			'dark'   => __( 'Dark', 'kingal' ),
		),
	) );

	$cmb2_post_1_options = new_cmb2_box( array(
		'id'           => $prefix . 'p1banner_option',
		'title'        => esc_html__( 'Upload Banner Image', 'kingal' ),
		'object_types' => array( 'page' , 'post', 'services', 'portfolios' , 'product'), // Post type
		'context'      => 'normal',
		'priority'     => 'high',
		'show_names'   => true, // Show field names on the left
		//'show_on'      => array( 'id' => array( 2, ) ), // Specific post IDs to display this metabox
	) );

	$cmb2_post_1_options->add_field( array(
	    'id'               => $prefix .'upload_banner_image',
	    'desc'             => esc_html__( 'Please upload banner image here ','kingal' ),
		 'type'             => 'file',
	) );	
	
	//Post Options	
	$cmb2_post_options = new_cmb2_box( array(
		'id'           => $prefix . 'posts_option',
		'title'        => esc_html__( 'Post Formats', 'kingal' ),
		'object_types' => array( 'post'), // Post type
		'context'      => 'normal',
		'priority'     => 'high',
		'show_names'   => true, // Show field names on the left
		//'show_on'      => array( 'id' => array( 2, ) ), // Specific post IDs to display this metabox
	) );	
	
	$cmb2_post_options->add_field( array(
	    'name'             => 'Gallery Post',
	    'id'               => $prefix .'gallery_post_title',
	    'type'    => 'title',
	) );		
	
	$cmb2_post_options->add_field( array(
	    'name'             => 'Gallery Images',
	    'id'               => $prefix .'gallery_imgs',
		'desc'    => 'upload gallery images here',
	    'type'    => 'file_list',
	) );	
	
	$cmb2_post_options->add_field( array(
	    'name'             => 'Audio / Video Post Embed Code ',
	    'id'               => $prefix .'vid_post_title',
	    'type'    => 'title',
	) );		
	
	$cmb2_post_options->add_field( array(
	    'name'             => 'Embed Code',
	    'id'               => $prefix .'embed_code',
		'desc'    => 'enter embed code here',
	    'type'    => 'textarea_code',
	) );		
	
	$cmb2_post_options->add_field( array(
	    'name'             => 'Link Post ',
	    'id'               => $prefix .'link_post_title',
	    'type'    => 'title',
	) );		
	
	$cmb2_post_options->add_field( array(
	    'name'             => 'Website Name',
	    'id'               => $prefix .'website_name',
		'desc'    => 'enter website name here',
	    'type'    => 'text',
	) );		
	
	$cmb2_post_options->add_field( array(
	    'name'             => 'Website Url',
	    'id'               => $prefix .'website_url',
		'desc'    => 'enter website url here',
	    'type'    => 'text',
	) );	
	
	$cmb2_post_options->add_field( array(
	    'name'             => 'Quote Post ',
	    'id'               => $prefix .'quote_post_title',
	    'type'    => 'title',
	) );		
	
	$cmb2_post_options->add_field( array(
	    'name'             => 'Quote',
	    'id'               => $prefix .'quote_content',
		'desc'    => 'enter quote content here',
	    'type'    => 'textarea',
	) );
	
	// Slider Options	

	$cmb2_home_slider = new_cmb2_box( array(
		'id'           => $prefix . 'home_slider',
		'title'        => esc_html__( 'Kingal Slider Info', 'kingal' ),
		'object_types' => array( 'kingal_slider'), // Post type
		'context'      => 'normal',
		'priority'     => 'high',
		'show_names'   => true, // Show field names on the left
		//'show_on'      => array( 'id' => array( 2, ) ), // Specific post IDs to display this metabox
	) );

	$cmb2_home_slider->add_field( array(
	    'name'             => esc_html__('Slider Title Font Size' , 'kingal'),
	    'id'               => $prefix .'slide_title_font_size',
	    'desc'             => esc_html__( 'write font size here.','kingal' ),
		'type'       => 'text',
		'default'       => '60px',
	) );	
	
	$cmb2_home_slider->add_field( array(
	    'name'             => esc_html__('Slider Title Font Color' , 'kingal'),
	    'id'               => $prefix .'slide_title_font_color',
	    'desc'             => esc_html__( 'choice color here.','kingal' ),
		'type'       => 'colorpicker',
		'default'       => '#ffffff',
	) );
	
	$cmb2_home_slider->add_field( array(
	    'name'             => esc_html__('Subtitle' , 'kingal'),
	    'id'               => $prefix .'slide_subtitle',
	    'desc'             => esc_html__( 'write subtitle here.','kingal' ),
		'type'       => 'wysiwyg',
    	'options' => array(
    	 'textarea_rows' => 3, 
		 )
	) );		

	$cmb2_home_slider->add_field( array(
	    'name'             => esc_html__('Slider Sub Title Font Size' , 'kingal'),
	    'id'               => $prefix .'slide_subtitle_font_size',
	    'desc'             => esc_html__( 'write font size here.','kingal' ),
		'type'       => 'text',
		'default'       => '18px',
	) );	
	
	$cmb2_home_slider->add_field( array(
	    'name'             => esc_html__('Slider Sub Title Font Color' , 'kingal'),
	    'id'               => $prefix .'slide_subtitle_font_color',
	    'desc'             => esc_html__( 'choice color here.','kingal' ),
		'type'       => 'colorpicker',
		'default'       => '#ffffff',
	) );
	
	$cmb2_home_slider->add_field( array(
	    'name'             => esc_html__('Button Text' , 'kingal'),
	    'id'               => $prefix .'slide_btn_text',
	    'desc'             => esc_html__( 'write button text here.','kingal' ),
		'type'       => 'text',
		'default'       => 'Get Started',
	) );	
	$cmb2_home_slider->add_field( array(
	    'name'             => esc_html__('Button Font Size' , 'kingal'),
	    'id'               => $prefix .'slide_btn_font_size',
	    'desc'             => esc_html__( 'write font size here.','kingal' ),
		'type'       => 'text',
		'default'       => '16px',
	) );	
	
	$cmb2_home_slider->add_field( array(
	    'name'             => esc_html__('Button Border color' , 'kingal'),
	    'id'               => $prefix .'slide_btn_border_color',
	    'desc'             => esc_html__( 'choice color here.','kingal' ),
		'type'       => 'colorpicker',
		'default'       => '#ffffff',
	) );	
	
	$cmb2_home_slider->add_field( array(
	    'name'             => esc_html__('Button Bakcground color' , 'kingal'),
	    'id'               => $prefix .'slide_btn_bg_color',
	    'desc'             => esc_html__( 'choice color here.','kingal' ),
		'type'       => 'colorpicker',
	) );	
	
	$cmb2_home_slider->add_field( array(
	    'name'             => esc_html__('Button Text color' , 'kingal'),
	    'id'               => $prefix .'slide_btn_text_color',
	    'desc'             => esc_html__( 'choice text color here.','kingal' ),
		'type'       => 'colorpicker',
		'default'       => '#ffffff',
	) );	
	
	$cmb2_home_slider->add_field( array(
	    'name'             => esc_html__('Button hover Border Color' , 'kingal'),
	    'id'               => $prefix .'slide_btn_hover_border_color',
	    'desc'             => esc_html__( 'choice text color here.','kingal' ),
		'type'       => 'colorpicker',
		'default'       => '#00cccc',
	) );	
	
	$cmb2_home_slider->add_field( array(
	    'name'             => esc_html__('Button hover Bakcground Color' , 'kingal'),
	    'id'               => $prefix .'slide_btn_hover_bg_color',
	    'desc'             => esc_html__( 'choice text color here.','kingal' ),
		'type'       => 'colorpicker',
		'default'       => '#00cccc',
	) );	
	
	$cmb2_home_slider->add_field( array(
	    'name'             => esc_html__('Button hover Text Color' , 'kingal'),
	    'id'               => $prefix .'slide_btn_hover_text_color',
	    'desc'             => esc_html__( 'choice text color here.','kingal' ),
		'type'       => 'colorpicker',
		'default'       => '#ffffff',
	) );
	
	$cmb2_home_slider->add_field( array(
	    'name'             => esc_html__('Button Link' , 'kingal'),
	    'id'               => $prefix .'slide_btn_link',
	    'desc'             => esc_html__( 'enter button link here.','kingal' ),
		'type'       => 'text',
		'default'       => '#',

	) );	
	

	$cmb2_who_we_are = new_cmb2_box( array(
		'id'           => $prefix . 'who_we-are_option',
		'title'        => esc_html__( 'Who We Are Options', 'kingal' ),
		'object_types' => array( 'who_we_are'), // Post type
		'context'      => 'normal',
		'priority'     => 'high',
		'show_names'   => true, // Show field names on the left
		//'show_on'      => array( 'id' => array( 2, ) ), // Specific post IDs to display this metabox
	) );
	
	$cmb2_who_we_are->add_field( array(
	    'name'             => esc_html__('Button Text' , 'kingal'),
	    'id'               => $prefix .'whoware_btn_text',
	    'desc'             => esc_html__( 'enter button Text here.','kingal' ),
		'type'       => 'text',
		'default'       => 'Continue Reading',

	) );	
	
	$cmb2_who_we_are->add_field( array(
	    'name'             => esc_html__('Button L' , 'kingal'),
	    'id'               => $prefix .'whoware_btn_link',
	    'desc'             => esc_html__( 'enter button link here.','kingal' ),
		'type'       => 'text',
		'default'       => '#',

	) );

	$cmb2_features = new_cmb2_box( array(
		'id'           => $prefix . 'features_options',
		'title'        => esc_html__( 'Features Info', 'kingal' ),
		'object_types' => array( 'features'), // Post type
		'context'      => 'normal',
		'priority'     => 'high',
		'show_names'   => true, // Show field names on the left
		//'show_on'      => array( 'id' => array( 2, ) ), // Specific post IDs to display this metabox
	) );

	$cmb2_features->add_field( array(
	    'name'             => esc_html__('Feature Icon' , 'kingal'),
	    'id'               => $prefix .'feature_icon',
	    'desc'             => esc_html__( 'write icon name here. get all icon <a href="//fortawesome.github.io/Font-Awesome/icons/" target="_blank">click here</a>','kingal' ),
		'type'       => 'text',
		'default'       => 'fa-laptop',
	) );		
	
	$cmb2_testimonials = new_cmb2_box( array(
		'id'           => $prefix . 'testimonials_options',
		'title'        => esc_html__( 'Testimonials Info', 'kingal' ),
		'object_types' => array( 'testimonials'), // Post type
		'context'      => 'normal',
		'priority'     => 'high',
		'show_names'   => true, // Show field names on the left
		//'show_on'      => array( 'id' => array( 2, ) ), // Specific post IDs to display this metabox
	) );

	$cmb2_testimonials->add_field( array(
	    'name'             => esc_html__('Designation' , 'kingal'),
	    'id'               => $prefix .'test_designation',
	    'desc'             => esc_html__( 'write designation here','kingal' ),
		'type'       => 'text',
		'default'       => 'Founder',
	) );		
	
	$cmb2_testimonials->add_field( array(
	    'name'             => esc_html__('Rating' , 'kingal'),
	    'id'               => $prefix .'test_rating',
	    'desc'             => esc_html__( 'check reating here','kingal' ),
		'type'             => 'radio',
		'options'          => array(
			'1' => esc_html__( 'One Star', 'kingal' ),
			'2'   => esc_html__( 'Two Star', 'kingal' ),
			'3'     => esc_html__( 'Three Star', 'kingal' ),
			'4'     => esc_html__( 'Four Star', 'kingal' ),
			'5'     => esc_html__( 'Five Star', 'kingal' ),
		),
		'default'    => '1',
	) );	
	
	$cmb2_team = new_cmb2_box( array(
		'id'           => $prefix . 'team_mem_options',
		'title'        => esc_html__( 'Team Member Info', 'kingal' ),
		'object_types' => array( 'k_team'), // Post type
		'context'      => 'normal',
		'priority'     => 'high',
		'show_names'   => true, // Show field names on the left
		//'show_on'      => array( 'id' => array( 2, ) ), // Specific post IDs to display this metabox
	) );

	$cmb2_team->add_field( array(
	    'name'             => esc_html__('Style Option' , 'kingal'),
	    'id'               => $prefix .'team_style',
	    'desc'             => esc_html__( 'select styles here','kingal' ),
		'type'             => 'radio',
		'options'          => array(
			'1' => __( 'Style One', 'kingal' ),
			'2'   => __( 'Style Two', 'kingal' ),
		),
		'default'    => '1',
	) );
	
	$cmb2_team->add_field( array(
	    'name'             => esc_html__('Designation' , 'kingal'),
	    'id'               => $prefix .'team_designation',
	    'desc'             => esc_html__( 'write designation here','kingal' ),
		'type'       => 'text',
		'default'       => 'Founder & Creative Director',
	) );	
	
	$teamgroup_field_id = $cmb2_team->add_field( array(
		'id'          => $prefix .'tean_group_field_opt',
		'type'        => 'group',
		// 'repeatable'  => false, // use false if you want non-repeatable group
		'options'     => array(
			'group_title'   => __( 'Social Media link {#}', 'kingal' ), // since version 1.1.4, {#} gets replaced by row number
			'add_button'    => __( 'Add New Link', 'kingal' ),
			'remove_button' => __( 'Remove Link', 'kingal' ),
			'sortable'      => true, // beta
			// 'closed'     => true, // true to have the groups closed by default
		),
	) );

	// Id's for group's fields only need to be unique for the group. Prefix is not needed.
	$cmb2_team->add_group_field( $teamgroup_field_id, array(
		'name' => 'Social Media Icon',
		'id'   => $prefix .'team_sm_icon',
		'type' => 'text',
		'default' => 'fa-facebook',
		'description' => 'enter social media icon here. get all icon <a href="//fortawesome.github.io/Font-Awesome/icons/" target="_blank">click here</a>',
		// 'repeatable' => true, // Repeatable fields are supported w/in repeatable groups (for most types)
	) );

	$cmb2_team->add_group_field( $teamgroup_field_id, array(
		'name' => 'Social Media Url',
		'description' => esc_html__( 'enter social media url','kingal' ),		
		'id'   => $prefix .'team_sm_link',
		'type' => 'text',
		'default' => '#',
	) );	
	
	$cmb2_team->add_group_field( $teamgroup_field_id, array(
		'name' => 'Social Media Link Bakcground Color',
		'description' => esc_html__( 'choice color here','kingal' ),		
		'id'   => $prefix .'team_sm_link_bg',
		'type' => 'colorpicker',
	) );	
	
	$cmb2_team->add_group_field( $teamgroup_field_id, array(
		'name' => 'Social Media Link Text Color',
		'description' => esc_html__( 'choice color here','kingal' ),		
		'id'   => $prefix .'team_sm_link_text_color',
		'type' => 'colorpicker',
	) );
	
	$cmb2_portfolios = new_cmb2_box( array(
		'id'           => $prefix . 'portfolios_options',
		'title'        => esc_html__( 'Portfolios Info', 'kingal' ),
		'object_types' => array( 'portfolios'), // Post type
		'context'      => 'normal',
		'priority'     => 'high',
		'show_names'   => true, // Show field names on the left
		//'show_on'      => array( 'id' => array( 2, ) ), // Specific post IDs to display this metabox
	) );

	$cmb2_portfolios->add_field( array(
	    'name'             => esc_html__('Client Label' , 'kingal'),
	    'id'               => $prefix .'port_client_label',
	    'desc'             => esc_html__( 'write client Label here','kingal' ),
		'type'             => 'text',
		'default'    => 'Client',
	) );		
	
	$cmb2_portfolios->add_field( array(
	    'name'             => esc_html__('Client Name' , 'kingal'),
	    'id'               => $prefix .'port_client_name',
	    'desc'             => esc_html__( 'write client name here','kingal' ),
		'type'             => 'text',
		'default'    => 'Themeforest',
	) );	
	
	$cmb2_portfolios->add_field( array(
	    'name'             => esc_html__('Date Label' , 'kingal'),
	    'id'               => $prefix .'port_date_label',
	    'desc'             => esc_html__( 'write date Label here','kingal' ),
		'type'             => 'text',
		'default'    => 'Project Date',
	) );		
	
	$cmb2_portfolios->add_field( array(
	    'name'             => esc_html__('Date' , 'kingal'),
	    'id'               => $prefix .'port_date',
	    'desc'             => esc_html__( 'write Date here','kingal' ),
		'type'             => 'text',
		'default'    => 'February 18, 2016',
	) );		
	
	$cmb2_portfolios->add_field( array(
	    'name'             => esc_html__('Project Url Label' , 'kingal'),
	    'id'               => $prefix .'port_project_url_label',
	    'desc'             => esc_html__( 'write date Label here','kingal' ),
		'type'             => 'text',
		'default'    => 'Project Url',
	) );		
	
	$cmb2_portfolios->add_field( array(
	    'name'             => esc_html__('Project Url' , 'kingal'),
	    'id'               => $prefix .'port_pro_url',
	    'desc'             => esc_html__( 'write project url here','kingal' ),
		'type'             => 'text',
		'default'    => 'www.themeforest.net',
	) );	
	
	$cmb2_services = new_cmb2_box( array(
		'id'           => $prefix . 'services_options',
		'title'        => esc_html__( 'Services Info', 'kingal' ),
		'object_types' => array( 'services'), // Post type
		'context'      => 'normal',
		'priority'     => 'high',
		'show_names'   => true, // Show field names on the left
		//'show_on'      => array( 'id' => array( 2, ) ), // Specific post IDs to display this metabox
	) );

	$cmb2_services->add_field( array(
	    'name'             => esc_html__('Service Icon' , 'kingal'),
	    'id'               => $prefix .'service_icon',
	    'desc'             => __( 'write icon name here here. get all icon <a href="//fortawesome.github.io/Font-Awesome/icons/" target="_blank">click here</a>','kingal' ),
		'type'             => 'text',
		'default'    => 'fa-camera',
	) );		

	$cmb2_pricing_table = new_cmb2_box( array(
		'id'           => $prefix . 'pricing_table_options',
		'title'        => esc_html__( 'Pricing Table Info', 'kingal' ),
		'object_types' => array( 'pricing_table'), // Post type
		'context'      => 'normal',
		'priority'     => 'high',
		'show_names'   => true, // Show field names on the left
		//'show_on'      => array( 'id' => array( 2, ) ), // Specific post IDs to display this metabox
	) );

	$cmb2_pricing_table->add_field( array(
	    'name'             => esc_html__('Currency Type' , 'kingal'),
	    'id'               => $prefix .'pt_currency_type',
	    'desc'             => esc_html__( 'write currency type here','kingal' ),
		'type'             => 'text',
		'default'    => '$',
	) );		
	
	$cmb2_pricing_table->add_field( array(
	    'name'             => esc_html__('Amount' , 'kingal'),
	    'id'               => $prefix .'pt_amount',
	    'desc'             => esc_html__( 'write amount here','kingal' ),
		'type'             => 'text',
		'default'    => '50',
	) );	
	
	$cmb2_pricing_table->add_field( array(
	    'name'             => esc_html__('Period' , 'kingal'),
	    'id'               => $prefix .'pt_period',
	    'desc'             => esc_html__( 'write period here','kingal' ),
		'type'             => 'text',
		'default'    => 'year',
	) );	
	$pricing_field_id = $cmb2_pricing_table->add_field( array(
		'id'          => $prefix .'pricing_group_field_opt',
		'type'        => 'group',
		// 'repeatable'  => false, // use false if you want non-repeatable group
		'options'     => array(
			'group_title'   => __( 'Pricing Feature {#}', 'kingal' ), // since version 1.1.4, {#} gets replaced by row number
			'add_button'    => __( 'Add New Feature', 'kingal' ),
			'remove_button' => __( 'Remove Feature', 'kingal' ),
			'sortable'      => true, // beta
			// 'closed'     => true, // true to have the groups closed by default
		),
	) );

	// Id's for group's fields only need to be unique for the group. Prefix is not needed.
	$cmb2_pricing_table->add_group_field( $pricing_field_id, array(
		'name' => 'Feature',
		'id'   => $prefix .'pt_feature',
		'type' => 'text',
		'default' => 'Unlimited Users',
	) );	
	
	$cmb2_pricing_table->add_field( array(
	    'name'             => esc_html__('Button Link' , 'kingal'),
	    'id'               => $prefix .'pt_button_link',
	    'desc'             => esc_html__( 'write Button link here','kingal' ),
		'type'             => 'text',
		'default'    => '#',
	) );	
	
}