/*
Author       : Syed Ekram.
Template Name: Kingal - Responsive Business Template.
Version      : 1.0
*/

(function($) {
	"use strict";


	/*preloader js*/
	$(window).load(function() { 
		$('.status').fadeOut();
		$('.preloader').delay(350).fadeOut('slow'); 
	}); 
	/*End preloader js*/
		
	/*wow animation js*/
	new WOW().init();	
	/*End wow animation js*/
	  
	jQuery(document).ready(function($){

	// one page nav
	$('.mainmenu').onePageNav({
	    currentClass: 'current',
	    changeHash: true,
	    scrollSpeed: 1500,
	    scrollThreshold: 0.5,
	    filter: ':not(.external)',
	    easing: 'swing',
	    begin: function() {
	        //I get fired when the animation is starting
	    },
	    end: function() {
	        //I get fired when the animation is ending
	    },
	    scrollChange: function(jQuerycurrentListItem) {
	        //I get fired when you enter a section and I pass the list item of the section
	    }
	});		
	
	


			$(window).scroll(function() {
			  if ($(this).scrollTop() > 100) {
				$('.menu-top').addClass('menu-shrink');
			  } else {
				$('.menu-top').removeClass('menu-shrink');
			  }
			});
		/*End Menu js*/


		// Owl Carousel for Services	
		var ServicesCarousel = $('.service_carousel');
		ServicesCarousel.owlCarousel({
			loop:false,
			autoplay:false,
			dots:false,
			margin:30,
			responsive:{
				0:{
					items:1
				},
				400:{
					items:1
				},
				600:{
					items:2
				},
				992:{
					items:3
				}
			}
		});	
		
		/*Slider */
		
		$('#home-slider').carousel({
		  interval: 9000
		});
	
		/*progress-bar*/
	    $('.progress-bar > span').each(function(){
			var $this = $(this);
			var width = $(this).data('percent');
			$this.css({
				'transition' : 'width 2s'
			});
			
			setTimeout(function() {
				$this.appear(function() {
						$this.css('width', width + '%');
				});
			}, 500);
		});
		/*End progress-bar*/
		
		/* Countdown js*/
		$('#counter_timer').bind('inview', function(event, visible, visiblePartX, visiblePartY) {
			if (visible) {
				$(this).find('.timer').each(function () {
					var $this = $(this);
					$({ Counter: 0 }).animate({ Counter: $this.text() }, {
						duration: 2000,
						easing: 'swing',
						step: function () {
							$this.text(Math.ceil(this.Counter));
						}
					});
				});
				$(this).unbind('inview');
			}
		});
		/* End Countdown js */

		/*testimonial carousel js*/
		$('.carousel').carousel({
			interval:5000,
			pause:"false",
		});
		
		/*End testimonial carousel js*/
		

		/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
			post-carousel
		-=-=-=-=-=-=-=-=-=--=-=-=-=-=-*/
		$(".post-carousel").owlCarousel({
			items: 1,
			loop: true,
			nav: true,
			mouseDrag: false,
			dots: false,
			smartSpeed: 900,
			animateOut: 'fadeOut',
			navText: ['<i class="fa fa-angle-left"></i>', '<i class="fa fa-angle-right"></i>']
		});
		
	   
	});	
	
	$('#home-slider .item:first').addClass('active');
	$('.who_we_are_content .item:first').addClass('active');
	$('.who_we_are_text .item:first').addClass('active');
	$('.testi_indicators li:first').addClass('active');
	$('#team__carousel .item:first').addClass('active');
	
	// jQuery MixItUp
    $('.work_all_item').mixItUp();	
	// jQuery Lightbox
    $('.lightbox').venobox({
        numeratio: true,
        infinigall: true
    });
	
})(jQuery);