<?php get_header();?>

<?php kingla_main_banner_mix();?>

		<!-- START PORTFOLIO SINGLE PROJECT -->
		<section class="single_project section-padding">	
			<div class="container">
				<div class="row">
				<?php while(have_posts()) : the_post() ;
				
				$kingal_port_image = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()),'kingal_portfolio_img');
				$client_label_label = get_post_meta(get_the_ID(), '_kingal_port_client_label', true);
				$port_client_name = get_post_meta(get_the_ID(), '_kingal_port_client_name', true);
				$port_date_label = get_post_meta(get_the_ID(), '_kingal_port_date_label', true);
				$port_date = get_post_meta(get_the_ID(), '_kingal_port_date', true);
				$port_project_url_label = get_post_meta(get_the_ID(), '_kingal_port_project_url_label', true);
				$port_pro_url = get_post_meta(get_the_ID(), '_kingal_port_pro_url', true);
				?>
					<div class="col-md-8">
						<div class="project_dec">
							<a href="<?php echo esc_url($kingal_port_image['0']);?>" class="lightbox"><img src="<?php echo esc_url($kingal_port_image['0']);?>" class="img-responsive" alt="<?php echo esc_attr(get_the_title());?>" /></a>		
						</div>
					</div>
					
					<div class="col-md-4">
						<div class="project_details">
							<div class="about_project">
								<h4><?php esc_html_e('About Project' , 'kingal');?></h4>
								<?php the_content();?>
							</div>
							<div class="about_project_details">
								<h4><?php esc_html_e('Project Details' , 'kingal');?></h4>
								<ul>
									<?php if($client_label_label) { ?>
										<li><i class="fa fa-user"></i><b><?php echo esc_html($client_label_label);?>: </b><?php echo esc_html($port_client_name);?></li>
									<?php }?>
									
									<?php if($port_date_label) { ?>
										<li><i class="fa fa-clock-o"></i><b><?php echo esc_html($port_date_label);?>: </b><?php echo esc_html($port_date);?></li>
									<?php }?>
									<li><i class="fa fa-folder"></i><b><?php echo esc_html_e('Category:' , 'kingal');?> </b>
																
										<?php 
											$terms = get_the_terms($post->ID, 'cat_portfolios');
											 foreach ( $terms as $term ) { ?>
											<span class="cat_name"><?php echo kingal_wp_kses($term->name); ?></span>
											<?php } ?> 
											
									</li>
									<?php if($port_project_url_label) { ?>
										<li><i class="fa fa-folder"></i><b><?php echo esc_html($port_project_url_label);?>: </b><a href="<?php echo esc_url($port_pro_url);?>" target="_blank"><?php echo esc_html($port_pro_url);?></a></li>
									<?php }?>
								</ul>
							</div>
							<?php if($port_pro_url) {?>
								<a class="btn btn-default btn-light-bg" href="<?php echo esc_url($port_pro_url);?>" target="_blank"><?php echo esc_html_e('See Live Project' , 'kingal');?></a>
							<?php }?>
						</div>
					</div>
					
				<?php endwhile;?>	
			

					</div><!--- END ROW -->
						
						<div class="row">
							<div class="col-md-8">
								<h4 class="similar_p"><?php echo esc_html_e('Similar Projects' , 'kingal');?></h4>
							<div class="row">
								<?php // WP_Query arguments
								$args = array (
									'post_type'              => array( 'portfolios' ),
									'post__not_in' => array($post->ID),
									'posts_per_page'=> 3
								);

								// The Query
								$related_port_query = new WP_Query( $args );

								// The Loop
								if ( $related_port_query->have_posts() ) {
									while ( $related_port_query->have_posts() ) {
										$related_port_query->the_post(); 
										$kingal_port_image = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()),'kingal_portfolio_img');
										?>
										<div class="col-md-4">
											<div class="related_project">
												<img src="<?php echo esc_url($kingal_port_image['0']);?>" class="img-responsive" alt="<?php echo esc_attr(get_the_title());?>" />
												<a href="<?php the_permalink();?>"><h4><?php the_title();?></h4></a>
												<p>
												<?php 
													$terms = get_the_terms($post->ID, 'cat_portfolios');
													 foreach ( $terms as $term ) {
													 echo $term->name;
													} ?> 
												
												</p>
											</div>
										</div>
								<?php	}
								} else {
									// no posts found
								}

								// Restore original Post Data
								wp_reset_postdata();?>							
			
							</div>
						</div>				
					</div>
								
			</div><!--- END CONTAINER -->
		</section>	
		<!-- END PORTFOLIO SINGLE PROJECT -->
		
<?php get_footer();?>
