<?php
/**
 * Template part for displaying posts.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Kingal
 */
 
$kingal_id = get_the_ID();
$kingal_embed_code = get_post_meta($kingal_id,'_kingal_embed_code', true);
$categories_list = get_the_category_list( esc_html__( ', ', 'kingal' ) );
$tags_list = get_the_tag_list( '', esc_html__( ' ', 'kingal' ) );
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

	 <div class="blog-post">
		<?php if($kingal_embed_code) {?>	 
			<div class="embed-responsive embed-responsive-16by9">
				<?php echo $kingal_embed_code;?>
			</div>			
		<?php }?>
		<?php if(!is_single()){the_title( '<h4 class="blogpost-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h4>' );}?>		
		
		<!-- BLOG DETAIL --> 
		 <div class="post-bt <?php if(is_single()){echo 'maring-top30';}?>">
			<span class="muser"><i class="fa fa-user"></i> <a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) );?>"><?php echo esc_html( get_the_author() ); ?></a></span>   
			<span class="mdate"><i class="fa fa-calendar"></i> <?php echo esc_html(get_the_time('M d, Y') , get_the_ID());?></span>  
			<span class="mcategory"><i class="fa fa-folder-open"></i> <?php echo $categories_list; ?></span>
			<span class="mcomments_numbers"><i class="fa fa-comments"></i> <?php comments_number( '0', '1', '%' ); ?></span>
		 </div>
		<?php if(is_single()) { the_content();
		
		}else{
			
			the_excerpt ();
		}
		wp_link_pages( array(
			'before'      => '<div class="page-links pagination"><span class="page-links-title">' . __( 'Pages:', 'kingal' ) . '</span>',
			'after'       => '</div>',
			'link_before' => '<span>',
			'link_after'  => '</span>',
			'pagelink'    => '<span class="screen-reader-text">' . __( 'Page', 'kingal' ) . ' </span>%',
			'separator'   => '<span class="screen-reader-text">, </span>',
		) );		
		?>
					
		<?php if(!is_single()) {?><a class="btn btn-lg btn-light-bg" href="<?php the_permalink();?>"><?php esc_html_e('Read more' , 'kingal');?></a><?php }?>
		
		<?php if(is_single()) { 
		   if($tags_list) {
		?>
		<div class="tags_list">
			<?php echo $tags_list;?>
		</div>
		<?php } } ?>	
	</div>
	
</article><!-- #post-## -->


