<?php
/**
 * @package Case-Themes
 */
$subtitle_404 = konstruc()->get_theme_opt('subtitle_404');
$title_404 = konstruc()->get_theme_opt('title_404');
$des_404 = konstruc()->get_theme_opt('des_404');
$button_404 = konstruc()->get_theme_opt('button_404');
$background_404 = konstruc()->get_opt( 'background_404', ['url' => get_template_directory_uri().'/assets/img/404.webp', 'id' => '' ] );
get_header(); ?>
<div class="wrap-content-404">
    <div class="pxl-error-image" style="background-image:url(<?php echo esc_url($background_404['url']); ?>);"></div>
    <div class="pxl-error-inner">
        <div class="content">
            <span class="pxl-error-subtitle">
                <?php if (!empty($subtitle_404)) {
                    echo pxl_print_html($subtitle_404);
                } else{
                    echo esc_html__('404 Page', 'konstruc'); 
                } ?>
            </span>
            <h3 class="pxl-error-title">
                <?php if (!empty($title_404)) {
                    echo pxl_print_html($title_404);
                } else{
                    echo esc_html__('Page not found', 'konstruc'); 
                } ?>
                
            </h3>
            <p class="pxl-error-description">
                <?php if (!empty($des_404)) {
                    echo pxl_print_html($des_404);
                } else{
                    echo esc_html__('Our clients, our employees, and our community through our commitment to leadership, excellence in craft, and attention to detail.', 'konstruc');
                } ?>
            </p>
            <a class="btn" href="<?php echo esc_url(home_url('/')); ?>">
                <span class="pxl--btn-text">
                    <?php if (!empty($button_404)) {
                        echo pxl_print_html($button_404);
                    } else{
                       echo esc_html__('GO TO HOMEPAGE', 'konstruc'); 
                   } ?>
               </span>
               <span class="pxl--btn-icon">
                <svg xmlns="http://www.w3.org/2000/svg" width="45" height="45" viewBox="0 0 45 45" fill="none">
                    <path d="M25.3362 20.8403L18.1765 28L17 26.8235L24.1598 19.6638H17.8492V18H27V27.1508H25.3362V20.8403Z" fill="#FF792D"/>
                </svg>
            </span>
        </a>
    </div>
</div>
</div>
<?php get_footer();
