<?php
$widget->add_render_attribute( 'counter', [
    'class' => 'pxl-counter--value '.$settings['effect'].'',
    'data-duration' => $settings['duration'],
    'data-startnumber' => $settings['starting_number'],
    'data-endnumber' => $settings['ending_number'],
    'data-to-value' => $settings['ending_number'],
    'data-delimiter' => $settings['thousand_separator_char'],
] ); 

$is_users = (isset($settings['users']) && !empty($settings['users']) && count($settings['users'])) || false;
?>
<div class="pxl-counter pxl-counter2 <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">

    <ul class="pxl-counter--holder">

        <?php if($is_users): ?>
            <?php foreach($settings['users'] as $user) : ?>
                <?php 
                $avatar = konstruc_get_thumbnail($user['avatar']['id']);    
                ?>
                <li class="pxl-item--single">
                    <?php pxl_print_html($avatar); ?>
                </li>
            <?php endforeach ?>
        <?php endif; ?>

        
    </ul>
    <div class="pxl-counter--content">
        <h3 class="pxl-counter--number">
            <span class="pxl-counter--prefix el-empty pxl-mr-6"><?php echo pxl_print_html($settings['prefix']); ?></span>
            <span <?php pxl_print_html($widget->get_render_attribute_string( 'counter' )); ?>>
                <?php echo esc_html($settings['starting_number']); ?>
            </span>
            <?php if ($settings['icon_plus_ct'] === 'true') : ?>
                <span class="pxl-icon--plus-ct">
                    <?php echo "+"; ?>
                </span>
            <?php endif; ?>
            <?php if(!empty($settings['suffix'])) : ?>
                <span class="pxl-counter--suffix el-empty"><?php echo pxl_print_html($settings['suffix']); ?></span>
            <?php endif; ?>
        </h3>
        <?php if(!empty($settings['title'])) : ?>
            <div class="pxl-counter--title"><?php echo pxl_print_html($settings['title']); ?></div>
        <?php endif; ?>

    </div>
    
</div>